/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import oracle.json.parser.AndORTree;
import oracle.json.parser.Evaluator;
import oracle.json.parser.JsonQueryPath;
import oracle.json.parser.Predicate;
import oracle.json.parser.QueryException;
import oracle.json.parser.QueryMessage;
import oracle.json.parser.ValueTypePair;

class AndORNode {
    private Evaluator.EvaluatorCode eval;
    private Predicate predicate;
    private List<AndORNode> children = new ArrayList<AndORNode>();
    private final AndORNode parent;
    private int numVals = 0;
    private JsonQueryPath downScopePath = null;
    private boolean notOp = false;
    private static final int KEY_TYPE_OPERATOR = 1;
    private static final int KEY_TYPE_AND = 2;
    private static final int KEY_TYPE_OR = 3;
    private static final int KEY_TYPE_LEAF = 4;
    private static final int KEY_TYPE_ID = 5;
    private static final int KEY_TYPE_NOR = 6;
    private static final boolean useSqlNotIn = false;
    private static final boolean generateNIN = false;

    public AndORNode(AndORNode andORNode) {
        this.parent = andORNode;
    }

    Evaluator.EvaluatorCode getEval() {
        return this.eval;
    }

    AndORNode getParent() {
        return this.parent;
    }

    int getNumVals() {
        return this.numVals;
    }

    String getDownScopePath() {
        if (this.downScopePath != null) {
            return this.downScopePath.toQueryString(false);
        }
        return null;
    }

    Predicate getPredicate() {
        return this.predicate;
    }

    boolean getNotOperation() {
        return this.notOp;
    }

    void setEval(Evaluator.EvaluatorCode evaluatorCode) {
        this.eval = evaluatorCode;
    }

    private void setNotEval(Evaluator.EvaluatorCode evaluatorCode) {
        boolean bl = true;
        switch (evaluatorCode) {
            case $eq: {
                evaluatorCode = Evaluator.EvaluatorCode.$ne;
                bl = false;
                break;
            }
            case $ne: {
                evaluatorCode = Evaluator.EvaluatorCode.$eq;
                bl = false;
                break;
            }
            case $gt: {
                evaluatorCode = Evaluator.EvaluatorCode.$lte;
                bl = false;
                break;
            }
            case $lt: {
                evaluatorCode = Evaluator.EvaluatorCode.$gte;
                bl = false;
                break;
            }
            case $gte: 
            case $ge: {
                evaluatorCode = Evaluator.EvaluatorCode.$lt;
                bl = false;
                break;
            }
            case $lte: 
            case $le: {
                evaluatorCode = Evaluator.EvaluatorCode.$gt;
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        this.eval = evaluatorCode;
        this.notOp = bl;
    }

    private void setPredicatePath(String string) throws QueryException {
        this.downScopePath = new JsonQueryPath(string);
    }

    private void incrementNumVals() {
        ++this.numVals;
    }

    void setPredicate(Predicate predicate) {
        this.predicate = predicate;
    }

    private void setNotOperation() {
        this.notOp = true;
    }

    private static Evaluator.EvaluatorCode codeFor(String string) throws QueryException {
        Evaluator.EvaluatorCode evaluatorCode = null;
        try {
            evaluatorCode = Evaluator.EvaluatorCode.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            QueryException.throwSyntaxException(QueryMessage.EX_NOT_AN_OPERATOR, string);
        }
        return evaluatorCode;
    }

    private static int checkScalarType(Evaluator.EvaluatorCode evaluatorCode, String string, ValueTypePair valueTypePair) throws QueryException {
        int n = valueTypePair.getType();
        if (evaluatorCode == Evaluator.EvaluatorCode.$startsWith || evaluatorCode == Evaluator.EvaluatorCode.$regex) {
            if (n != 2) {
                QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_STRING, string);
            }
        } else if (evaluatorCode != Evaluator.EvaluatorCode.$eq && evaluatorCode != Evaluator.EvaluatorCode.$ne && evaluatorCode != Evaluator.EvaluatorCode.$exists && (n == 3 || n == 4)) {
            QueryException.throwSyntaxException(QueryMessage.EX_NULL_BOOLEAN_INVALID, string, ValueTypePair.getStringType(n));
        }
        return n;
    }

    static int getKeyType(String string) throws QueryException {
        int n = 0;
        if (string.length() == 0) {
            n = 4;
        } else if (string.charAt(0) != '$') {
            n = 4;
        } else if (string.equalsIgnoreCase("$and")) {
            n = 2;
        } else if (string.equalsIgnoreCase("$or")) {
            n = 3;
        } else if (string.equalsIgnoreCase("$nor")) {
            n = 6;
        } else if (string.equalsIgnoreCase("$id")) {
            n = 5;
        } else if (string.equalsIgnoreCase("$gt") || string.equalsIgnoreCase("$gte") || string.equalsIgnoreCase("$ge") || string.equalsIgnoreCase("$lt") || string.equalsIgnoreCase("$lte") || string.equalsIgnoreCase("$le") || string.equalsIgnoreCase("$eq") || string.equalsIgnoreCase("$ne") || string.equalsIgnoreCase("$in") || string.equalsIgnoreCase("$nin") || string.equalsIgnoreCase("$all") || string.equalsIgnoreCase("$not") || string.equalsIgnoreCase("$regex") || string.equalsIgnoreCase("$exists") || string.equalsIgnoreCase("$startsWith")) {
            n = 1;
        } else {
            QueryException.throwSyntaxException(QueryMessage.EX_NOT_AN_OPERATOR, string);
        }
        return n;
    }

    private void addArrayValues(AndORTree andORTree, JsonValue jsonValue, String string) throws QueryException {
        JsonArray jsonArray = (JsonArray)jsonValue;
        Iterator iterator = jsonArray.iterator();
        if (!iterator.hasNext()) {
            QueryException.throwSyntaxException(QueryMessage.EX_CANNOT_BE_EMPTY, string);
        }
        while (iterator.hasNext()) {
            JsonValue jsonValue2 = (JsonValue)iterator.next();
            if (andORTree.isJSONObject(jsonValue2)) {
                QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_SCALAR, string);
            }
            this.incrementNumVals();
            andORTree.addToValueArray(jsonValue2, string);
        }
    }

    void addNode(AndORTree andORTree, Map.Entry<String, JsonValue> entry) throws QueryException {
        AndORNode andORNode = null;
        String string = entry.getKey();
        int n = AndORNode.getKeyType(string);
        switch (n) {
            case 2: 
            case 3: 
            case 6: {
                Iterator iterator;
                AndORNode andORNode2;
                AndORNode andORNode3 = this;
                if (n == 2) {
                    if (this.getEval() != Evaluator.EvaluatorCode.$and) {
                        andORNode2 = new AndORNode(this);
                        andORNode2.setEval(Evaluator.EvaluatorCode.$and);
                        this.children.add(andORNode2);
                        andORNode3 = andORNode2;
                    }
                } else if (n == 3) {
                    if (this.getEval() != Evaluator.EvaluatorCode.$or || this.getNotOperation()) {
                        andORNode2 = new AndORNode(this);
                        andORNode2.setEval(Evaluator.EvaluatorCode.$or);
                        this.children.add(andORNode2);
                        andORNode3 = andORNode2;
                    }
                } else if (!(n != 6 || this.getEval() == Evaluator.EvaluatorCode.$or && this.getNotOperation())) {
                    andORNode2 = new AndORNode(this);
                    andORNode2.setEval(Evaluator.EvaluatorCode.$or);
                    this.children.add(andORNode2);
                    andORNode3 = andORNode2;
                    andORNode2.setNotOperation();
                }
                if (!andORTree.isJSONArray(entry.getValue())) {
                    QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_ARRAY, string);
                }
                if (!(iterator = (andORNode2 = (JsonArray)entry.getValue()).iterator()).hasNext()) {
                    QueryException.throwSyntaxException(QueryMessage.EX_CANNOT_BE_EMPTY, string);
                }
                while (iterator.hasNext()) {
                    JsonValue jsonValue = (JsonValue)iterator.next();
                    if (jsonValue.getValueType() != JsonValue.ValueType.OBJECT) {
                        QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_OBJECT, string);
                    }
                    JsonObject jsonObject = (JsonObject)jsonValue;
                    Set set = jsonObject.entrySet();
                    Iterator iterator2 = set.iterator();
                    AndORNode andORNode4 = andORNode3;
                    if (andORNode4.getEval() != Evaluator.EvaluatorCode.$and) {
                        andORNode4 = new AndORNode(andORNode3);
                        andORNode4.setEval(Evaluator.EvaluatorCode.$and);
                        andORNode3.children.add(andORNode4);
                    }
                    if (!iterator2.hasNext()) {
                        QueryException.throwSyntaxException(QueryMessage.EX_CANNOT_BE_EMPTY, string);
                    }
                    while (iterator2.hasNext()) {
                        andORNode4.addNode(andORTree, (Map.Entry)iterator2.next());
                    }
                }
                break;
            }
            case 5: {
                JsonValue jsonValue;
                if (this.parent != null) {
                    QueryException.throwSyntaxException(QueryMessage.EX_ID_MISPLACED, new Object[0]);
                }
                if (andORTree.isJSONPrimitive(jsonValue = entry.getValue())) {
                    String string2 = andORTree.getScalarKey(jsonValue);
                    andORTree.addToKeys(string2);
                    break;
                }
                if (andORTree.isJSONArray(jsonValue)) {
                    JsonArray jsonArray = (JsonArray)jsonValue;
                    for (JsonValue jsonValue2 : jsonArray) {
                        String string3 = andORTree.getScalarKey(jsonValue2);
                        andORTree.addToKeys(string3);
                    }
                    if (andORTree.getKeys().size() > 0) break;
                    QueryException.throwSyntaxException(QueryMessage.EX_CANNOT_BE_EMPTY, string);
                    break;
                }
                QueryException.throwSyntaxException(QueryMessage.EX_NON_SCALAR_KEY, new Object[0]);
                break;
            }
            case 1: {
                QueryException.throwSyntaxException(QueryMessage.EX_UNEXPECTED_OPERATOR, string);
            }
            default: {
                String string4 = string;
                JsonValue jsonValue = entry.getValue();
                if (andORTree.isJSONPrimitive(jsonValue)) {
                    andORNode = new AndORNode(this);
                    andORNode.predicate = new Predicate(new JsonQueryPath(string4), jsonValue.toString());
                    andORNode.setEval(Evaluator.EvaluatorCode.$eq);
                    andORTree.addToValueArray(jsonValue, string4);
                    this.children.add(andORNode);
                    break;
                }
                if (andORTree.isJSONObject(jsonValue)) {
                    JsonObject jsonObject = (JsonObject)jsonValue;
                    Set set = jsonObject.entrySet();
                    Iterator iterator = set.iterator();
                    boolean bl = false;
                    if (!iterator.hasNext()) {
                        QueryException.throwSyntaxException(QueryMessage.EX_CANNOT_BE_EMPTY, string4);
                    }
                    while (iterator.hasNext()) {
                        Map.Entry entry2 = (Map.Entry)iterator.next();
                        String string5 = (String)entry2.getKey();
                        JsonValue jsonValue3 = (JsonValue)entry2.getValue();
                        andORNode = new AndORNode(this);
                        this.children.add(andORNode);
                        if (AndORNode.getKeyType(string5) == 1) {
                            Evaluator.EvaluatorCode evaluatorCode = AndORNode.codeFor(string5);
                            bl = true;
                            block5 : switch (evaluatorCode) {
                                case $not: {
                                    JsonObject jsonObject2;
                                    Set set2;
                                    Iterator iterator3;
                                    if (!andORTree.isJSONObject(jsonValue3)) {
                                        QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_OBJECT, string5);
                                    }
                                    if (!(iterator3 = (set2 = (jsonObject2 = (JsonObject)jsonValue3).entrySet()).iterator()).hasNext()) {
                                        QueryException.throwSyntaxException(QueryMessage.EX_CANNOT_BE_EMPTY, string5);
                                    }
                                    Map.Entry entry3 = (Map.Entry)iterator3.next();
                                    if (iterator3.hasNext()) {
                                        QueryException.throwSyntaxException(QueryMessage.EX_NUMBER_OF_MEMBERS, Integer.toString(set2.size()), string5);
                                    }
                                    JsonValue jsonValue4 = (JsonValue)entry3.getValue();
                                    andORNode.predicate = new Predicate(new JsonQueryPath(string4));
                                    String string6 = (String)entry3.getKey();
                                    Evaluator.EvaluatorCode evaluatorCode2 = AndORNode.codeFor(string6);
                                    switch (evaluatorCode2) {
                                        case $in: 
                                        case $nin: 
                                        case $all: {
                                            if (!andORTree.isJSONArray(jsonValue4)) {
                                                QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_ARRAY, string6);
                                            }
                                            andORNode.addArrayValues(andORTree, jsonValue4, string6);
                                            break;
                                        }
                                        case $and: 
                                        case $or: 
                                        case $nor: 
                                        case $not: 
                                        case $orderby: 
                                        case $id: {
                                            QueryException.throwSyntaxException(QueryMessage.EX_NOT_IS_NOT_ALLOWED, string6);
                                            break;
                                        }
                                        default: {
                                            AndORNode.checkScalarType(evaluatorCode2, string6, andORTree.addToValueArray(jsonValue4, string6));
                                        }
                                    }
                                    switch (evaluatorCode2) {
                                        case $nin: {
                                            andORNode.setEval(Evaluator.EvaluatorCode.$in);
                                            break block5;
                                        }
                                        case $in: {
                                            andORNode.setEval(evaluatorCode2);
                                            andORNode.setNotOperation();
                                            break block5;
                                        }
                                        case $ne: {
                                            andORNode.setEval(Evaluator.EvaluatorCode.$eq);
                                            break block5;
                                        }
                                    }
                                    andORNode.setEval(evaluatorCode2);
                                    andORNode.setNotOperation();
                                    break;
                                }
                                case $in: 
                                case $nin: 
                                case $all: {
                                    if (!andORTree.isJSONArray(jsonValue3)) {
                                        QueryException.throwSyntaxException(QueryMessage.EX_MUST_BE_ARRAY, string5);
                                    }
                                    andORNode.addArrayValues(andORTree, jsonValue3, string5);
                                    if (evaluatorCode == Evaluator.EvaluatorCode.$nin) {
                                        andORNode.setEval(Evaluator.EvaluatorCode.$in);
                                        andORNode.setNotOperation();
                                    } else {
                                        andORNode.setEval(evaluatorCode);
                                    }
                                    andORNode.predicate = new Predicate(new JsonQueryPath(string4));
                                    break;
                                }
                                default: {
                                    if (andORTree.isJSONArray(jsonValue3)) {
                                        QueryException.throwSyntaxException(QueryMessage.EX_CONTAINER_NOT_ALLOWED, string5, "array");
                                    } else if (andORTree.isJSONObject(jsonValue3)) {
                                        QueryException.throwSyntaxException(QueryMessage.EX_CONTAINER_NOT_ALLOWED, string5, "object");
                                    }
                                    andORNode.predicate = new Predicate(new JsonQueryPath(string4), jsonValue3.toString());
                                    andORNode.setEval(evaluatorCode);
                                    AndORNode.checkScalarType(evaluatorCode, string5, andORTree.addToValueArray(jsonValue3, string5));
                                    break;
                                }
                            }
                            continue;
                        }
                        if (AndORNode.getKeyType(string5) == 4 && !bl) {
                            andORNode.setEval(Evaluator.EvaluatorCode.$and);
                            andORNode.setPredicatePath(string4);
                            andORNode.addNode(andORTree, entry2);
                            while (iterator.hasNext()) {
                                andORNode.addNode(andORTree, (Map.Entry)iterator.next());
                            }
                            continue;
                        }
                        QueryException.throwSyntaxException(QueryMessage.EX_KEY_NOT_ALLOWED, string5);
                    }
                    break;
                }
                if (andORTree.isJSONArray(jsonValue)) {
                    andORNode = new AndORNode(this);
                    andORNode.addArrayValues(andORTree, jsonValue, string4);
                    andORNode.setEval(Evaluator.EvaluatorCode.$all);
                    andORNode.predicate = new Predicate(new JsonQueryPath(string4));
                    this.children.add(andORNode);
                    break;
                }
                QueryException.throwSyntaxException(QueryMessage.EX_SYNTAX_ERROR, new Object[0]);
            }
        }
    }

    private void appendPathOp(String string, StringBuilder stringBuilder, String string2, String string3) {
        stringBuilder.append(string);
        stringBuilder.append(string2);
        if (string3 != null) {
            stringBuilder.append(" ");
            stringBuilder.append(string3);
        }
    }

    private void appendBind(StringBuilder stringBuilder, int n) throws QueryException {
        stringBuilder.append(" $B");
        stringBuilder.append(n);
    }

    private void appendBind(StringBuilder stringBuilder, AndORTree andORTree) throws QueryException {
        this.appendBind(stringBuilder, andORTree.getNextBind());
    }

    private void prependNotWrapper(StringBuilder stringBuilder) {
        stringBuilder.append("(!");
    }

    private void appendNotWrapper(StringBuilder stringBuilder) {
        stringBuilder.append(")");
    }

    StringBuilder generateJsonExists(AndORTree andORTree) throws QueryException {
        StringBuilder stringBuilder = new StringBuilder();
        this.generateJsonExists(andORTree, stringBuilder);
        return stringBuilder;
    }

    private void generateJsonExists(AndORTree andORTree, StringBuilder stringBuilder) throws QueryException {
        if (this.eval == null) {
            QueryException.throwSyntaxException(QueryMessage.EX_SYNTAX_ERROR, new Object[0]);
        }
        String string = null;
        String string2 = Evaluator.Operator.get((Object)this.eval);
        String string3 = " && ";
        boolean bl = false;
        boolean bl2 = false;
        if (this.predicate != null && this.predicate.path != null) {
            string = this.predicate.path.toQueryString(true);
        }
        switch (this.eval) {
            case $all: {
                if (this.getNotOperation()) {
                    this.prependNotWrapper(stringBuilder);
                }
                string2 = Evaluator.Operator.get((Object)Evaluator.EvaluatorCode.$eq);
                int n = this.getNumVals();
                if (n > 1) {
                    stringBuilder.append("(");
                }
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        stringBuilder.append(string3);
                    }
                    stringBuilder.append("(");
                    this.appendPathOp(andORTree.getPredChar(), stringBuilder, string, string2);
                    this.appendOrInlineBind(andORTree, stringBuilder);
                    stringBuilder.append(")");
                }
                if (n > 1) {
                    stringBuilder.append(")");
                }
                if (!this.getNotOperation()) break;
                this.appendNotWrapper(stringBuilder);
                break;
            }
            case $nin: {
                QueryException.throwExecutionException(QueryMessage.EX_UNSUPPORTED_OP, new Object[0]);
                break;
            }
            case $in: {
                if (this.getNotOperation()) {
                    this.prependNotWrapper(stringBuilder);
                }
                stringBuilder.append("(");
                int n = this.getNumVals();
                if (n == 1) {
                    string2 = Evaluator.Operator.get((Object)Evaluator.EvaluatorCode.$eq);
                    this.appendPathOp(andORTree.getPredChar(), stringBuilder, string, string2);
                    this.appendOrInlineBind(andORTree, stringBuilder);
                } else {
                    this.appendPathOp(andORTree.getPredChar(), stringBuilder, string, string2);
                    stringBuilder.append(" (");
                    for (int i = 0; i < n; ++i) {
                        if (i > 0) {
                            stringBuilder.append(",");
                        }
                        this.appendOrInlineBind(andORTree, stringBuilder);
                    }
                    stringBuilder.append(")");
                }
                stringBuilder.append(")");
                if (!this.getNotOperation()) break;
                this.appendNotWrapper(stringBuilder);
                break;
            }
            case $exists: {
                boolean bl3 = this.getNotOperation();
                int n = andORTree.getNextBind();
                ValueTypePair valueTypePair = andORTree.getValueArray().get(n);
                if (valueTypePair.getType() == 3) {
                    if (!valueTypePair.getBooleanValue()) {
                        bl3 = !bl3;
                    }
                } else if (valueTypePair.getType() == 4) {
                    bl3 = !bl3;
                } else if (valueTypePair.getType() == 1 && BigDecimal.ZERO.equals(valueTypePair.getNumberValue())) {
                    boolean bl4 = bl3 = !bl3;
                }
                if (bl3) {
                    this.prependNotWrapper(stringBuilder);
                }
                string = this.predicate.path.toQueryString(false);
                stringBuilder.append("(exists(");
                this.appendPathOp(andORTree.getPredChar(), stringBuilder, string, null);
                stringBuilder.append(")) ");
                if (bl3) {
                    this.appendNotWrapper(stringBuilder);
                }
                andORTree.removeBind(n);
                break;
            }
            case $or: {
                string3 = " || ";
            }
            case $and: {
                int n;
                String string4;
                if (this.children == null || this.children.size() == 0) {
                    return;
                }
                if (this.getNotOperation()) {
                    this.prependNotWrapper(stringBuilder);
                }
                if ((string4 = this.getDownScopePath()) != null) {
                    bl = true;
                    stringBuilder.append("( exists(");
                    stringBuilder.append(andORTree.getPredChar());
                    stringBuilder.append(string4);
                    stringBuilder.append("?");
                    bl2 = true;
                }
                if ((n = this.children.size()) > 1) {
                    bl2 = true;
                }
                if (bl2) {
                    stringBuilder.append("( ");
                }
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        stringBuilder.append(string3);
                    }
                    AndORNode andORNode = this.children.get(i);
                    andORNode.generateJsonExists(andORTree, stringBuilder);
                }
                if (bl2) {
                    stringBuilder.append(" )");
                }
                if (bl) {
                    stringBuilder.append(") )");
                }
                if (!this.getNotOperation()) break;
                this.appendNotWrapper(stringBuilder);
                break;
            }
            case $ne: {
                if (this.getNotOperation()) {
                    this.prependNotWrapper(stringBuilder);
                }
                this.prependNotWrapper(stringBuilder);
                stringBuilder.append("(");
                this.appendPathOp(andORTree.getPredChar(), stringBuilder, string, Evaluator.Operator.get((Object)Evaluator.EvaluatorCode.$eq));
                this.appendOrInlineBind(andORTree, stringBuilder);
                stringBuilder.append(")");
                this.appendNotWrapper(stringBuilder);
                if (!this.getNotOperation()) break;
                this.appendNotWrapper(stringBuilder);
                break;
            }
            default: {
                if (this.getNotOperation()) {
                    this.prependNotWrapper(stringBuilder);
                }
                stringBuilder.append("(");
                this.appendPathOp(andORTree.getPredChar(), stringBuilder, string, string2);
                int n = this.getNumVals();
                if (n <= 1) {
                    this.appendOrInlineBind(andORTree, stringBuilder);
                } else {
                    stringBuilder.append("(");
                    for (int i = 0; i < n; ++i) {
                        if (i > 0) {
                            stringBuilder.append(", ");
                        }
                        this.appendBind(stringBuilder, andORTree);
                    }
                    stringBuilder.append(")");
                }
                stringBuilder.append(")");
                if (!this.getNotOperation()) break;
                this.appendNotWrapper(stringBuilder);
            }
        }
    }

    private void appendOrInlineBind(AndORTree andORTree, StringBuilder stringBuilder) throws QueryException {
        String string;
        boolean bl = false;
        int n = andORTree.getNextBind();
        ValueTypePair valueTypePair = andORTree.getValueArray().get(n);
        if (valueTypePair.getType() == 3) {
            stringBuilder.append(valueTypePair.getBooleanValue() ? " true" : " false");
            bl = true;
        } else if (valueTypePair.getType() == 4) {
            stringBuilder.append(" null");
            bl = true;
        } else if (valueTypePair.getType() == 2 && (string = valueTypePair.getStringValue()) != null && (string.equals("true") || string.equals("false") || string.equals("null"))) {
            stringBuilder.append(" \"");
            stringBuilder.append(string);
            stringBuilder.append("\"");
            bl = true;
        }
        if (!bl) {
            this.appendBind(stringBuilder, n);
        } else {
            andORTree.removeBind(n);
        }
    }
}

