/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.common;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Message {
    public static final Message EX_NO_BOUND = Message.create(1001);
    public static final Message EX_NO_LINE_BREAK = Message.create(1002);
    public static final Message EX_CHARSET_CONVERSION = Message.create(1003);
    public static final Message EX_QUERY_STR_CONVERSION = Message.create(1004);
    public static final Message EX_NO_LINE_TERMINATOR = Message.create(1005);
    public static final Message EX_FIELD_NAME_NOT_FOUND = Message.create(1006);
    public static final Message EX_FIELD_NAME_NOT_VALID = Message.create(1007);
    public static final Message EX_NO_CLOSING_QUOTE = Message.create(1008);
    public static final Message EX_NO_START_OF_FIELD = Message.create(1009);
    public static final Message EX_NO_END_OF_FIELD = Message.create(1010);
    public static final Message EX_ILLEGAL_DATE_TIME = Message.create(1011);
    public static final Message EX_QBE_SYNTAX_ERROR = Message.create(1012);
    public static final Message EX_UNKNOWN_ENCODING = Message.create(1013);
    public static final Message EX_BAD_HEX_VALUES = Message.create(1014);
    public static final Message EX_UNSUPPORTED_MEDIA = Message.create(1015);
    public static final Message EX_INVALID_CONFIG = Message.create(1016);
    public static final Message EX_UNKNOWN_ACCOUNT = Message.create(1017);
    public static final Message EX_ILLEGAL_DATE_TIME2 = Message.create(1018);
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(Message.class.getPackage().getName() + ".Messages");
    private int key;

    protected Message(int n) {
        this.key = n;
    }

    public int getKey() {
        return this.key;
    }

    public String get(Object ... objectArray) {
        return MessageFormat.format(this.getMessageTemplate(), objectArray);
    }

    private static Message create(int n) {
        return new Message(n);
    }

    protected String getMessageTemplate() {
        String string = String.valueOf(this.getKey());
        String string2 = this.getPrefix();
        try {
            return this.getBundle().getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string2 + "-" + string;
        }
    }

    protected ResourceBundle getBundle() {
        return MESSAGES;
    }

    protected String getPrefix() {
        return "JSON";
    }
}

