/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.navigator;

import java.util.Arrays;
import java.util.Iterator;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.ssh.SshSupportResources;
import oracle.dbtools.raptor.ssh.navigator.Hosts;
import oracle.dbtools.raptor.ssh.navigator.SshController;
import oracle.ide.controller.Controller;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultAttributes;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.Element;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public class SshNavWindow
extends NavigatorWindow {
    protected SshNavWindow(ViewId viewId) {
        super(viewId);
    }

    protected Controller createController() {
        return new SshController();
    }

    protected Element getRootElement() {
        return Root.INSTANCE;
    }

    public String getTitleName() {
        return SshSupportResources.getString("NAVIGATOR_ROOT");
    }

    public String getTabName() {
        return SshSupportResources.getString("NAVIGATOR_LABEL");
    }

    protected boolean isRootVisible() {
        return false;
    }

    public boolean canCollapse(NavigatorTreeNode navigatorTreeNode) {
        Element element = navigatorTreeNode.getElement();
        return !(element instanceof Root) && !(element instanceof Hosts);
    }

    private static class Root
    extends DefaultElement
    implements Subject {
        private static Root INSTANCE = new Root();
        private IdeSubject delegate = new IdeSubject();
        private Element[] children = new Element[]{Hosts.INSTANCE};

        private Root() {
        }

        public Iterator getChildren() {
            return Arrays.asList(this.children).iterator();
        }

        public boolean mayHaveChildren() {
            return true;
        }

        public Attributes getAttributes() {
            return DefaultAttributes.EMPTY_ATTRIBUTES;
        }

        public void attach(Observer observer) {
            this.delegate.attach(observer);
        }

        public void detach(Observer observer) {
            this.delegate.detach(observer);
        }

        public void notifyObservers(Object object, UpdateMessage updateMessage) {
            this.delegate.notifyObservers(object, updateMessage);
        }
    }
}

