/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.config;

import java.net.URL;
import oracle.dbtools.raptor.utils.RaptorHashStructureAdapter;
import oracle.ide.config.Preferences;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;

public final class SshConfiguration
extends RaptorHashStructureAdapter {
    private static final String DATA_KEY = "SQLDeveloper.SSHConfiguration";
    private static final String ROOT_KEY = "SshRoot";
    public static final String KNOWN_HOSTS_KEY = "KnownHosts";

    public static SshConfiguration getInstance(PropertyStorage propertyStorage) {
        return new SshConfiguration(SshConfiguration.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
    }

    public static SshConfiguration createSettings(TraversableContext traversableContext) {
        return SshConfiguration.getInstance(traversableContext.getPropertyStorage());
    }

    public static SshConfiguration getInstance() {
        return SshConfiguration.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    private SshConfiguration(HashStructure hashStructure) {
        super(hashStructure);
    }

    protected String getRootKey() {
        return ROOT_KEY;
    }

    public URL getKnownHostsFile() {
        HashStructure hashStructure = this.getRootHash();
        return hashStructure.getURL(KNOWN_HOSTS_KEY);
    }

    public void setKnownHostsFile(URL uRL) {
        HashStructure hashStructure = this.getRootHash();
        hashStructure.putURL(KNOWN_HOSTS_KEY, uRL, true);
    }
}

