/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.searchbar;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.Ide;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpSystem;
import oracle.ideimpl.searchbar.Bundle;
import oracle.ideimpl.searchbar.ColorProvider;
import oracle.ideimpl.searchbar.ProviderReference;
import oracle.ideimpl.searchbar.QuickSearchCommand;
import oracle.ideimpl.searchbar.SearchBarController;
import oracle.ideimpl.searchbar.SearchBarHook;
import oracle.ideimpl.searchbar.ShowAllEditorAddin;
import oracle.ideimpl.searchbar.ShowAllNode;
import oracle.javatools.ui.JCheckBoxMenuItemNoClose;
import oracle.javatools.ui.search.PromptedTextField;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;

final class SearchBar {
    private SearchBar() {
    }

    private static SearchField createSearchField() {
        if (Boolean.getBoolean("ide.searchbar.disabled")) {
            return null;
        }
        SearchBarHook hook = SearchBarHook.get();
        if (hook == null) {
            return null;
        }
        if (hook.providers() == null) {
            return null;
        }
        if (hook.providers().isEmpty()) {
            return null;
        }
        SearchField searchField = SearchBar.createSearchFieldImpl();
        Ide.getToolbar().add(Box.createHorizontalGlue());
        Ide.getToolbar().add((Component)searchField);
        new SearchBarController(searchField, hook.providers());
        EditorManager.getEditorManager().register((EditorAddin)new ShowAllEditorAddin(), new Class[]{ShowAllNode.class});
        Ide.getMainWindow().registerView(Ide.getMainWindow().getIdeMainWindowView(), (Component)searchField);
        ColorProvider.updateUIManager();
        return searchField;
    }

    private static SearchField createSearchFieldImpl() {
        SearchField searchField = new SearchField((PromptedTextField)new CustomPrompt());
        searchField.getTextField().getAccessibleContext().setAccessibleName(Bundle.get("ACCESSIBLE_SEARCH_NAME"));
        searchField.getTextField().getAccessibleContext().setAccessibleDescription(Bundle.get("ACCESSIBLE_SEARCH_DESCRIPTION"));
        searchField.setStyle(SearchField.Style.FILTER);
        QuickSearchCommand.setSearchField(searchField);
        searchField.getTextField().setColumns(15);
        searchField.setPrompt(Bundle.get("SEARCH_PROMPT"));
        searchField.setMaximumSize(searchField.getPreferredSize());
        HelpSystem.getHelpSystem().registerTopic((JComponent)searchField, "f1_globalsearch_html");
        SearchBar.createSearchDropMenu(searchField);
        return searchField;
    }

    static void createSearchDropMenu(SearchField searchField) {
        ArrayList<ProviderReference> refs = new ArrayList<ProviderReference>(SearchBarHook.get().providers());
        Collections.sort(refs, new Comparator<ProviderReference>(){

            @Override
            public int compare(ProviderReference o1, ProviderReference o2) {
                return o1.name().compareTo(o2.name());
            }
        });
        for (ProviderReference pro : refs) {
            DisableProviderAction a = new DisableProviderAction(pro.name(), pro, searchField);
            JCheckBoxMenuItemNoClose item = new JCheckBoxMenuItemNoClose((Action)a);
            item.setState(SearchBarHook.get().isProviderEnabled(pro));
            searchField.addCategoryMenuItem((JMenuItem)item);
        }
        searchField.getCategoriesPopup().addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                Component[] items;
                for (Component item : items = ((JPopupMenu)e.getSource()).getComponents()) {
                    JCheckBoxMenuItem cbItem = (JCheckBoxMenuItem)item;
                    DisableProviderAction action = (DisableProviderAction)cbItem.getAction();
                    cbItem.setSelected(SearchBarHook.get().isProviderEnabled(action.proRef));
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    static class CustomPrompt
    extends PromptedTextField {
        CustomPrompt() {
        }

        void updateAccessibleName(String name) {
            if (name == null || name.equals("")) {
                this.getAccessibleContext().setAccessibleName(Bundle.get("ACCESSIBLE_SEARCH_NAME"));
                this.getAccessibleContext().setAccessibleDescription(Bundle.get("ACCESSIBLE_SEARCH_DESCRIPTION"));
                return;
            }
            this.getAccessibleContext().setAccessibleName(name);
            this.getAccessibleContext().firePropertyChange("AccessibleSelection", null, "");
            this.getAccessibleContext().firePropertyChange("AccessibleSelection", null, this.getText());
        }
    }

    private static class DisableProviderAction
    extends AbstractAction {
        ProviderReference proRef;
        SearchField searchField;

        public DisableProviderAction(String name, ProviderReference proRef, SearchField searchField) {
            super(name);
            this.proRef = proRef;
            this.searchField = searchField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean enabled = ((JCheckBoxMenuItem)e.getSource()).isSelected();
            SearchBarHook.get().setProviderEnabled(this.proRef, enabled);
            this.searchField.doSearch(null, this.searchField.getText(), SearchEvent.Direction.FORWARD, true);
        }
    }
}

