/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.searchbar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import oracle.ide.searchbar.Result;

final class ResultListModel
extends AbstractListModel {
    private int maxVisibleResults = 7;
    private final List<Result> allResults = Collections.synchronizedList(new ArrayList());
    private final List<Result> visibleModel = new ArrayList<Result>();
    private final Comparator<Result> resultComparator = new WeightComparator();

    ResultListModel() {
    }

    void clear() {
        this.allResults.clear();
        this.updateVisibleModel();
    }

    void add(Result result) {
        if (!this.allResults.contains(result)) {
            this.allResults.add(result);
        }
    }

    boolean remove(Result result) {
        int i = this.allResults.indexOf(result);
        if (i != -1) {
            this.allResults.remove(result);
            int j = this.visibleModel.indexOf(result);
            if (j != -1) {
                this.visibleModel.remove(result);
                this.fireIntervalRemoved(this, j, j);
            }
            this.updateVisibleModel();
            return true;
        }
        return false;
    }

    @Override
    public int getSize() {
        return this.visibleModel.size();
    }

    @Override
    public Object getElementAt(int index) {
        if (index == -1 || index >= this.visibleModel.size()) {
            return null;
        }
        return this.visibleModel.get(index);
    }

    Result resultAt(int index) {
        if (index >= this.visibleModel.size()) {
            return null;
        }
        return this.visibleModel.get(index);
    }

    Result[] getAllResults() {
        return this.allResults.toArray(new Result[this.allResults.size()]);
    }

    int getTotalSize() {
        return this.allResults.size();
    }

    void setMaxVisibleCount(int i) {
        if (i != this.maxVisibleResults) {
            this.maxVisibleResults = i;
            this.updateVisibleModel();
        }
    }

    int getMaxVisibleCount() {
        return this.maxVisibleResults;
    }

    void updateVisibleModel() {
        ArrayList<Result> copy = new ArrayList<Result>(this.allResults);
        Collections.sort(copy, this.resultComparator);
        this.visibleModel.clear();
        this.visibleModel.addAll(copy.subList(0, Math.min(this.maxVisibleResults, copy.size())));
        int newSize = this.visibleModel.size();
        if (newSize > 0) {
            this.fireContentsChanged(this, 0, newSize - 1);
        }
    }

    private class WeightComparator
    implements Comparator<Result> {
        private WeightComparator() {
        }

        @Override
        public int compare(Result o1, Result o2) {
            int result = o2.weight() - o1.weight();
            if (result == 0 && (result = o1.displayText().compareTo(o2.displayText())) == 0) {
                String l1 = o1.displayLocation();
                String l2 = o1.displayLocation();
                if (l1 != null && l2 != null) {
                    result = l1.compareTo(l2);
                }
            }
            return result;
        }
    }
}

