/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.todo;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.adapters.AdapterManager;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.todo.TaskPriority;
import oracle.jdeveloper.todo.TaskTag;

public class TaskTagImpl
extends HashStructureAdapter
implements TaskTag {
    private static final String NAME_ELMT = "name/#text";
    private static final String SEARCH_STR_ELMT = "searchString/#text";
    private static final String PRIORITY_ELMT = "priorityId/#text";
    private static final String ENABLED_ELMT = "enabled/#text";
    private static final String EXT_ID = "#__extension-id";
    private Pattern pattern;

    private TaskTagImpl(HashStructure hash) {
        super(hash);
        this.pattern = Pattern.compile(hash.getString(SEARCH_STR_ELMT, ""));
    }

    @Override
    public String name() {
        return this.getHashStructure().getString(NAME_ELMT);
    }

    @Override
    public TaskPriority priority() {
        return TaskPriority.valueOf(this.getHashStructure().getInt(PRIORITY_ELMT, TaskPriority.NORMAL.value));
    }

    @Override
    public String searchString() {
        return this.getHashStructure().getString(SEARCH_STR_ELMT);
    }

    @Override
    public boolean enabled() {
        return this.getHashStructure().getBoolean(ENABLED_ELMT, true);
    }

    @Override
    public int compareTo(TaskTag other) {
        return this.priority().value - other.priority().value;
    }

    @Override
    public Pair<Integer, Integer> indexOf(String str) {
        return this.indexOf(str, 0);
    }

    @Override
    public Pair<Integer, Integer> indexOf(String str, int offset) {
        if (!this.enabled()) {
            return NOT_FOUND;
        }
        if (!ModelUtil.hasLength((String)str) || offset >= str.length()) {
            return NOT_FOUND;
        }
        Matcher matcher = this.pattern.matcher(str);
        if (matcher.find(offset)) {
            return new Pair((Object)matcher.start(), (Object)matcher.end());
        }
        return NOT_FOUND;
    }

    @Override
    public boolean isUserDefined() {
        return false == this.getHashStructure().containsKey(EXT_ID);
    }

    private HashStructure toHashStructure() {
        return this.getHashStructure();
    }

    @Override
    public void name(String name) {
        this.checkUserDefined();
        this.getHashStructure().putString(NAME_ELMT, name);
    }

    @Override
    public void priority(TaskPriority priority) {
        this.checkUserDefined();
        this.getHashStructure().putInt(PRIORITY_ELMT, priority.value);
    }

    @Override
    public void enabled(boolean enabled) {
        this.getHashStructure().putBoolean(ENABLED_ELMT, enabled);
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            return true;
        }
        if (!(o instanceof TaskTag)) {
            return false;
        }
        TaskTag that = (TaskTag)o;
        if (ModelUtil.areDifferent((Object)this.name(), (Object)that.name())) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)this.searchString(), (Object)that.searchString())) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)((Object)this.priority()), (Object)((Object)that.priority()))) {
            return false;
        }
        HashStructure thisHash = (HashStructure)AdapterManager.Factory.getAdapterManager().adapt((Object)this, HashStructure.class);
        HashStructure thatHash = (HashStructure)AdapterManager.Factory.getAdapterManager().adapt((Object)that, HashStructure.class);
        if (null == thisHash || null == thatHash) {
            return false;
        }
        return !ModelUtil.areDifferent((Object)thisHash.getString(EXT_ID), (Object)thatHash.getString(EXT_ID));
    }

    @Override
    public void searchString(String searchString) {
        this.checkUserDefined();
        this.getHashStructure().putString(SEARCH_STR_ELMT, searchString);
        this.pattern = Pattern.compile(searchString);
    }

    private void checkUserDefined() {
        if (!this.isUserDefined()) {
            throw new UnsupportedOperationException("Cannot modify a non-user-defined task tag");
        }
    }

    public static final class ToHashStructureAdapterFactory
    implements AdapterFactory<TaskTag, HashStructure> {
        public HashStructure adapt(TaskTag tag) {
            if (null == tag) {
                return null;
            }
            if (tag instanceof TaskTagImpl) {
                return ((TaskTagImpl)tag).toHashStructure();
            }
            HashStructure hash = HashStructure.newInstance();
            hash.putString(TaskTagImpl.NAME_ELMT, tag.name());
            hash.putInt(TaskTagImpl.PRIORITY_ELMT, tag.priority().value);
            hash.putString(TaskTagImpl.SEARCH_STR_ELMT, tag.searchString());
            return hash;
        }
    }

    public static final class FromHashStructureAdapterFactory
    implements AdapterFactory<HashStructure, TaskTag> {
        public TaskTag adapt(HashStructure hash) {
            if (null == hash) {
                return null;
            }
            return new TaskTagImpl(hash);
        }
    }
}

