/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.db2v10;

import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.offline.Db2OfflineCapturer;
import oracle.dbtools.migration.workbench.plugin.db2v9.DB2v9Plugin;

public class DB2v10Plugin
extends DB2v9Plugin {
    @Override
    public MigrationPlugin.PluginSupportLevel getPlatformSupportLevel(String string, int n, int n2, String string2) {
        if (string.startsWith(this.getPlatformName()) && n >= 10) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_PREFERRED_VERSION;
        }
        return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_NONE;
    }

    @Override
    public String getPublishedVersion() {
        return "10";
    }

    @Override
    public OfflineCapturer getOfflineCapturer() {
        return new Db2OfflineCapturer(){

            @Override
            protected String[] getFilesToWrite(int n) {
                String string = "/oracle/dbtools/migration/workbench/db2v10/resources/";
                String[] stringArray = n == 2 ? new String[]{string + "startDump.sh", string + "getForeignKeys.sh", string + "getProcedures.sh", string + "db2v10.ocp"} : new String[]{string + "startDump.bat", string + "db2v10.ocp"};
                return stringArray;
            }

            @Override
            public String getModelName() throws CaptureException {
                return "DB2 (10)";
            }
        };
    }
}

