/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdIdentityColumn;
import oracle.dbtools.metadata.persistence.MdIndexDetail;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdSynonym;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.capture.CaptureAudience;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.QueryCapture;
import oracle.dbtools.migration.core.Messages;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.plugin.DB2Messages;

public class DB2OnlineCapturer {
    private static final String GET_SCHEMA_QUERY = "select TRIM(SCHEMANAME) SCHEMA_NAME from SYSCAT.SCHEMATA WHERE DEFINER <> 'SYSIBM' AND SCHEMANAME <> 'NULLID' AND SCHEMANAME <> 'SQLJ' AND SCHEMANAME <> 'SYSTOOLS'";
    private static final String GET_TABLE_QUERY = "select TABNAME TABLE_NAME from syscat.tables";
    private static final String GET_SYNONYM_QUERY = "select TABNAME, BASE_TABSCHEMA, BASE_TABNAME  from syscat.tables where tabschema = '${schema}' and type = 'A'";
    private static final String GET_COLUMN_QUERY = "select COLNAME, CASE  WHEN (CODEPAGE = 0 and (TYPENAME = ''VARCHAR'' OR TYPENAME = ''CHAR'' OR TYPENAME = ''LONG VARCHAR'' OR  TYPENAME = ''CHARACTER''))  THEN  TYPENAME || '' FOR BIT DATA''  ELSE TYPENAME   END TYPENAME, LENGTH, SCALE, NULLS, DEFAULT DEFAULTS, IDENTITY from SYSCAT.COLUMNS {0} ORDER BY COLNO";
    private static final String GET_VIEW_QUERY = "select VIEWNAME, TEXT, OWNER, READONLY, VALID from syscat.views";
    private static final String GET_INDEXES_QUERY = "select INDNAME , INDEXTYPE, UNIQUERULE from SYSCAT.INDEXES WHERE ";
    private static final String GET_INDEX_DETAILS_QUERY = "select COLNAME, COLSEQ from SYSCAT.INDEXCOLUSE";
    private static final String GET_TRIGGERS_QUERY = "select TRIGNAME, OWNER, TABSCHEMA, TABNAME, TRIGEVENT, VALID, TEXT,  REMARKS from SYSCAT.TRIGGERS";
    private static final String GET_PROCEDURES_QUERY = "select ROUTINENAME NAME, CASE ROUTINETYPE WHEN ''P'' THEN ''PROCEDURE'' WHEN ''F'' THEN ''FUNCTION'' WHEN ''M'' THEN ''FUNCTION'' ELSE ''NONE''  END ROUTINETYPE, TEXT, CREATE_TIME, REMARKS from SYSCAT.ROUTINES where ROUTINESCHEMA = ''{0}''";
    private String GET_PK_CONSTRAINTS_QUERY = "SELECT X.CONSTNAME, X.TYPE, X.TABSCHEMA, X.TABNAME, Z.COLNAME, Z.COLSEQ, X.REMARKS from (select CONSTNAME, TYPE, TABSCHEMA, TABNAME, REMARKS from SYSCAT.TABCONST where (type = 'P' OR type = 'U')) X FULL OUTER JOIN (select COLNAME,  COLSEQ, CONSTNAME, TABSCHEMA, TABNAME from SYSCAT.KEYCOLUSE) Z on  (X.CONSTNAME = Z.CONSTNAME and X.TABSCHEMA = Z.TABSCHEMA and X.TABNAME = Z.TABNAME) ";
    private String GET_FK_CONSTRAINTS_QUERY = "SELECT A.CONSTNAME, A.TABNAME, A.TABSCHEMA, A.REFKEYNAME, A.REFTABSCHEMA, A.REFTABNAME,        B.COLNAME, B.REFCOLNAME, B.COLSEQ, C.TYPE, C.REMARKS from (SELECT * from SYSCAT.REFERENCES WHERE TABNAME = ''{0}'' and TABSCHEMA = ''{1}'') A JOIN   (SELECT X.CONSTNAME, X.COLNAME, X.TABNAME, X.TABSCHEMA,         Y.CONSTNAME REFCONSTNAME, Y.COLNAME REFCOLNAME, Y.TABNAME REFTABNAME, Y.TABSCHEMA REFTABSCHEMA, X.COLSEQ from     (SELECT * from SYSCAT.KEYCOLUSE WHERE TABNAME = ''{0}'' and TABSCHEMA = ''{1}'') X     JOIN     (SELECT * from SYSCAT.KEYCOLUSE) Y     on (X.COLSEQ = Y.COLSEQ)  ) B  on (A.CONSTNAME = B.CONSTNAME and A.TABNAME = B.TABNAME and A.TABSCHEMA = B.TABSCHEMA      and A.REFKEYNAME = B.REFCONSTNAME and A.REFTABNAME = B.REFTABNAME and A.REFTABSCHEMA = B.REFTABSCHEMA), SYSCAT.TABCONST C WHERE (A.CONSTNAME = C.CONSTNAME and A.TABNAME = C.TABNAME and A.TABSCHEMA = C.TABSCHEMA)";
    private String GET_CHECK_CONSTRAINTS_QUERY = "SELECT A.CONSTNAME, TEXT , A.TABNAME , COLNAME   FROM SYSCAT.CHECKS A , SYSCAT.COLCHECKS B WHERE A.CONSTNAME = B.CONSTNAME AND A.TABSCHEMA = B.TABSCHEMA AND A.TABNAME=B.TABNAME AND A.TABSCHEMA = '${SCHEMA}' AND A.TABNAME = '${TABLE}' ";
    public static final String DB2_LANGUAGE_ID = "DB2LANG";
    private Connection m_sourceConnection;
    private MigrationStorer m_storer;

    private String getIdentitySQLString(String string, CaptureContext captureContext) {
        String string2 = (String)captureContext.getContextVariable("TABLE");
        String string3 = captureContext.applyToSQLString("${schema}");
        return "select START, INCREMENT, MINVALUE, MAXVALUE, CYCLE  from SYSCAT.COLIDENTATTRIBUTES where TABNAME = '" + string2 + "' and TABSCHEMA = '" + string3 + "' and COLNAME = '" + string + "'";
    }

    public DB2OnlineCapturer(MigrationStorer migrationStorer, Connection connection) {
        this.setStorer(migrationStorer);
        this.m_sourceConnection = connection;
    }

    public String getSourceURL() {
        return "/tmp/db2v95";
    }

    public void setStorer(MigrationStorer migrationStorer) {
        this.m_storer = migrationStorer;
    }

    public MigrationStorer getStorer() {
        return this.m_storer;
    }

    public Connection getConnection() {
        return this.m_sourceConnection;
    }

    public void captureObjects(String string, CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) {
        if (captureContext.shouldCancel()) {
            CaptureEvent captureEvent = new CaptureEvent(-1, string, "");
            captureContext.getAudience().fireListeners(captureEvent);
            return;
        }
        try {
            if (string.equals("MD_CATALOGS")) {
                this.captureCatalog(captureContext, migrationObjectFilter);
            } else if (string.equals("MD_SCHEMAS")) {
                this.captureSchemas(captureContext, migrationObjectFilter);
            } else if (string.equals("MD_TABLES")) {
                this.captureTables(captureContext, migrationObjectFilter);
            } else if (string.equals("MD_VIEWS")) {
                this.captureViews(captureContext, migrationObjectFilter);
            } else if (string.equals("MD_COLUMNS")) {
                this.captureColumns(captureContext, migrationObjectFilter);
            } else if (string.equals("MD_INDEXES")) {
                this.captureIndexes(captureContext, migrationObjectFilter);
            } else if (string.equals("MD_TRIGGERS")) {
                this.captureTriggers(captureContext, migrationObjectFilter);
            } else if (string.equals("MD_STORED_PROGRAMS")) {
                this.captureProcedures(captureContext, migrationObjectFilter);
            } else if (string.equals("MD_CONSTRAINTS")) {
                this.captureConstraints(captureContext, migrationObjectFilter);
            } else if (string.equals("MD_SYNONYMS")) {
                this.captureSynonyms(captureContext, migrationObjectFilter);
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureSynonyms(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        HashSet<String> hashSet = new HashSet<String>();
        CloseableResultSet closeableResultSet = null;
        StringBuffer stringBuffer = new StringBuffer(this.getSynonymQuery());
        this.processFilter(migrationObjectFilter, stringBuffer, hashSet, "MD_SYNONYMS");
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CATALOGID");
        try {
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            ResultSet resultSet = closeableResultSet.getResultSet();
            while (resultSet.next() && !captureContext.shouldCancel()) {
                String string = resultSet.getString(1);
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !hashSet.contains(string)) continue;
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                DBObjectId dBObjectId2 = persistenceUtility.getIdForTable(persistenceUtility.getIdForSchema(dBObjectId, string2), string3);
                MdSynonym mdSynonym = new MdSynonym((DBObjectId)captureContext.getContextVariable("SCHEMAID"), string, dBObjectId2, "MD_TABLES");
                mdSynonym.setNativeKey(persistenceUtility.getIdForSchema(dBObjectId, string2).toString());
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_SYNONYM"), mdSynonym.getName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdSynonym = (MdSynonym)this.getStorer().storeObject((PersistableObject)mdSynonym);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    protected String getSynonymQuery() {
        return GET_SYNONYM_QUERY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureProcedures(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        CloseableResultSet closeableResultSet = null;
        try {
            Object object;
            Serializable serializable;
            StringBuffer stringBuffer = this.getStoredPgmQuery(captureContext);
            DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
            if (migrationObjectFilter != null) {
                serializable = new StringBuffer();
                ((StringBuffer)serializable).append(migrationObjectFilter.toWhereClause("ROUTINENAME "));
                object = ((StringBuffer)serializable).toString().replaceAll("WHERE", "AND");
                stringBuffer.append((String)object);
            }
            serializable = new HashSet();
            this.processFilter(migrationObjectFilter, stringBuffer, (Set<String>)((Object)serializable), "MD_STORED_PROGRAMS");
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            object = closeableResultSet.getResultSet();
            while (object.next() && !captureContext.shouldCancel()) {
                String string = object.getString("NAME");
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !serializable.contains(string)) continue;
                MdStoredProgram mdStoredProgram = new MdStoredProgram(dBObjectId, DB2_LANGUAGE_ID);
                mdStoredProgram.setName(string);
                mdStoredProgram.setProgramtype(object.getString("ROUTINETYPE"));
                String string2 = object.getString("REMARKS");
                if (string2 != null && string2.length() > 0) {
                    mdStoredProgram.setComments(string2);
                }
                ClobHelper clobHelper = new ClobHelper(object.getClob("TEXT"));
                mdStoredProgram.setNativeSql(clobHelper);
                Timestamp timestamp = object.getTimestamp("CREATE_TIME");
                mdStoredProgram.setCreatedOn(new Date(timestamp.getTime()));
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_STORED_PROGRAMS"), mdStoredProgram.getName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdStoredProgram = (MdStoredProgram)this.getStorer().storeObject((PersistableObject)mdStoredProgram);
                try {
                    Reader reader = clobHelper.getReader();
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                }
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    protected StringBuffer getStoredPgmQuery(CaptureContext captureContext) {
        String string = captureContext.applyToSQLString("${schema}");
        String string2 = MessageFormat.format(GET_PROCEDURES_QUERY, string);
        StringBuffer stringBuffer = new StringBuffer(string2);
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void capturePrimaryKeyConstraints(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("TABLEID");
        StringBuffer stringBuffer = this.getPKConstrQuery(captureContext);
        CloseableResultSet closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
        ResultSet resultSet = closeableResultSet.getResultSet();
        HashMap<String, MdConstraint> hashMap = new HashMap<String, MdConstraint>();
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        try {
            while (resultSet.next() && !captureContext.shouldCancel()) {
                CaptureEvent captureEvent;
                String string;
                String string2 = resultSet.getString("TYPE");
                String string3 = null;
                String string4 = resultSet.getString("CONSTNAME");
                if (string2.trim().equals("P") || string2.trim().equals("PRIMARY KEY")) {
                    string3 = "PK";
                } else if (string2.trim().equals("U") || string2.trim().equals("UNIQUE")) {
                    string3 = "UNIQUE";
                }
                MdConstraint mdConstraint = (MdConstraint)hashMap.get(string4);
                if (mdConstraint == null && string3 != null) {
                    MdConstraint mdConstraint2 = new MdConstraint(dBObjectId, DB2_LANGUAGE_ID);
                    mdConstraint2.setName(string4);
                    mdConstraint2.setConstraintType(string3);
                    string = resultSet.getString("REMARKS");
                    mdConstraint2.setComments(string);
                    captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint2.getName());
                    captureContext.getAudience().fireListeners(captureEvent);
                    mdConstraint2 = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint2);
                    hashMap.put(string4, mdConstraint2);
                    captureEvent.setEventId(4);
                    captureContext.getAudience().fireListeners(captureEvent);
                } else if (string3 == null) {
                    Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, DB2Messages.getString("DB2OnlineCapturer.0") + string4 + DB2Messages.getString("DB2OnlineCapturer.65") + string2);
                    continue;
                }
                if ((mdConstraint = (MdConstraint)hashMap.get(string4)) == null) continue;
                int n = resultSet.getInt("COLSEQ");
                string = resultSet.getString("COLNAME");
                captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), string);
                captureContext.getAudience().fireListeners(captureEvent);
                MdConstraintDetail mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(n));
                mdConstraintDetail.setColumnId(persistenceUtility.getIdForColumn(mdConstraint.getTableId(), string));
                mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    protected StringBuffer getPKConstrQuery(CaptureContext captureContext) {
        String string = captureContext.applyToSQLString("${schema}");
        String string2 = captureContext.applyToSQLString("${table}");
        StringBuffer stringBuffer = new StringBuffer(this.GET_PK_CONSTRAINTS_QUERY);
        stringBuffer.append(" WHERE X.TABNAME='").append(string2).append("' ");
        stringBuffer.append(" and X.TABSCHEMA='").append(string).append("' ");
        stringBuffer.append(" ORDER BY X.CONSTNAME");
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureForeignKeyConstraints(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("TABLEID");
        String string = this.getFKConstrQuery(captureContext);
        CloseableResultSet closeableResultSet = QueryCapture.issueSQL((String)string, (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
        ResultSet resultSet = closeableResultSet.getResultSet();
        HashMap<String, MdConstraint> hashMap = new HashMap<String, MdConstraint>();
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        try {
            while (resultSet.next() && !captureContext.shouldCancel()) {
                String string2 = resultSet.getString("TYPE");
                String string3 = resultSet.getString("CONSTNAME");
                String string4 = resultSet.getString("REFTABSCHEMA");
                DBObjectId dBObjectId2 = persistenceUtility.getIdForSchema((DBObjectId)captureContext.getContextVariable("CATALOGID"), string4);
                if (dBObjectId2 == null) {
                    dBObjectId2 = persistenceUtility.getIdForSchema((DBObjectId)captureContext.getContextVariable("CATALOGID"), string4.trim());
                }
                String string5 = resultSet.getString("REFTABNAME");
                if (dBObjectId2 == null) {
                    Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, DB2Messages.getString("DB2OnlineCapturer.7") + string3);
                    continue;
                }
                DBObjectId dBObjectId3 = persistenceUtility.getIdForTable(dBObjectId2, string5);
                if (string2.trim().equals("F") || string2.trim().equals("FOREIGN KEY")) {
                    String string6;
                    MdConstraint mdConstraint;
                    if (hashMap.get(string3) == null) {
                        mdConstraint = new MdConstraint(dBObjectId, DB2_LANGUAGE_ID);
                        mdConstraint.setName(string3);
                        mdConstraint.setConstraintType("FOREIGN KEY");
                        String string7 = resultSet.getString("REMARKS");
                        mdConstraint.setComments(string7);
                        if (dBObjectId3 == null) {
                            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, DB2Messages.getString("DB2OnlineCapturer.82") + string3 + DB2Messages.getString("DB2OnlineCapturer.83"));
                        }
                        mdConstraint.setReftableId(dBObjectId3);
                        string6 = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint.getName());
                        captureContext.getAudience().fireListeners((CaptureEvent)string6);
                        mdConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint);
                        hashMap.put(string3, mdConstraint);
                        string6.setEventId(4);
                        captureContext.getAudience().fireListeners((CaptureEvent)string6);
                    }
                    if ((mdConstraint = (MdConstraint)hashMap.get(string3)) == null) continue;
                    int n = resultSet.getInt("COLSEQ");
                    string6 = resultSet.getString("COLNAME");
                    CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), string6);
                    captureContext.getAudience().fireListeners(captureEvent);
                    MdConstraintDetail mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(n));
                    mdConstraintDetail.setColumnId(persistenceUtility.getIdForColumn(mdConstraint.getTableId(), string6));
                    mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
                    captureEvent.setEventId(4);
                    captureContext.getAudience().fireListeners(captureEvent);
                    String string8 = resultSet.getString("REFCOLNAME");
                    captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), string8);
                    captureContext.getAudience().fireListeners(captureEvent);
                    mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(n + 1));
                    mdConstraintDetail.setRefFlag("Y");
                    if (dBObjectId3 == null) {
                        Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, DB2Messages.getString("DB2OnlineCapturer.87") + string3 + DB2Messages.getString("DB2OnlineCapturer.88"));
                        continue;
                    }
                    DBObjectId dBObjectId4 = persistenceUtility.getIdForColumn(dBObjectId3, string8);
                    mdConstraintDetail.setColumnId(dBObjectId4);
                    mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
                    captureEvent.setEventId(4);
                    captureContext.getAudience().fireListeners(captureEvent);
                    continue;
                }
                Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, DB2Messages.getString("DB2OnlineCapturer.89") + string3 + DB2Messages.getString("DB2OnlineCapturer.90") + string2);
            }
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    protected String getFKConstrQuery(CaptureContext captureContext) {
        String string = captureContext.applyToSQLString("${schema}");
        String string2 = captureContext.applyToSQLString("${table}");
        StringBuffer stringBuffer = new StringBuffer(this.GET_FK_CONSTRAINTS_QUERY);
        String string3 = MessageFormat.format(stringBuffer.toString(), string2, string);
        return string3;
    }

    private void captureConstraints(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        this.capturePrimaryKeyConstraints(captureContext, migrationObjectFilter);
        this.captureForeignKeyConstraints(captureContext, migrationObjectFilter);
        this.captureCheckConstraints(captureContext, migrationObjectFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureCheckConstraints(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        CloseableResultSet closeableResultSet = null;
        StringBuffer stringBuffer = new StringBuffer(this.GET_CHECK_CONSTRAINTS_QUERY);
        try {
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            ResultSet resultSet = closeableResultSet.getResultSet();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                string = string.trim();
                PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
                MdConstraint mdConstraint = new MdConstraint((DBObjectId)captureContext.getContextVariable("TABLEID"), DB2_LANGUAGE_ID);
                String string2 = "CHECK";
                mdConstraint.setConstraintType(string2);
                mdConstraint.setName(string);
                String string3 = resultSet.getString(2);
                mdConstraint.setConstraintText(string3);
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint.getName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureTriggers(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        CloseableResultSet closeableResultSet = null;
        try {
            Object object;
            Serializable serializable;
            StringBuffer stringBuffer = this.getTriggerQuery(captureContext, migrationObjectFilter);
            if (stringBuffer == null) {
                return;
            }
            if (migrationObjectFilter != null) {
                serializable = new StringBuffer();
                ((StringBuffer)serializable).append(migrationObjectFilter.toWhereClause("TRIGNAME "));
                object = ((StringBuffer)serializable).toString().replaceAll("WHERE", "AND");
                stringBuffer.append((String)object);
            }
            serializable = new HashSet();
            this.processFilter(migrationObjectFilter, stringBuffer, (Set<String>)((Object)serializable), "MD_TRIGGERS");
            object = this.getStorer().getPersistenceUtility();
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            ResultSet resultSet = closeableResultSet.getResultSet();
            while (resultSet.next() && !captureContext.shouldCancel()) {
                String string = resultSet.getString("TRIGNAME");
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !serializable.contains(string)) continue;
                DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("TABLEID");
                MdTrigger mdTrigger = new MdTrigger(dBObjectId, resultSet.getString("TRIGEVENT"), DB2_LANGUAGE_ID);
                mdTrigger.setTriggerName(string);
                mdTrigger.setComments(resultSet.getString("REMARKS"));
                mdTrigger.setTriggerEvent(resultSet.getString("TRIGEVENT"));
                ClobHelper clobHelper = new ClobHelper(resultSet.getClob("TEXT"));
                mdTrigger.setNativeSql(clobHelper);
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_TRIGGERS"), string);
                captureContext.getAudience().fireListeners(captureEvent);
                this.getStorer().storeObject((PersistableObject)mdTrigger);
                try {
                    Reader reader = clobHelper.getReader();
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                }
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    protected StringBuffer getTriggerQuery(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) {
        String string = captureContext.applyToSQLString("${schema}");
        String string2 = null;
        try {
            string2 = captureContext.applyToSQLString("${table}");
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(GET_TRIGGERS_QUERY);
        stringBuffer.append(" where TRIGSCHEMA='").append(string).append("' ");
        if (string2 != null) {
            stringBuffer.append(" and TABNAME='").append(string2).append("' ");
        }
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureIndexes(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        CloseableResultSet closeableResultSet = null;
        try {
            Object object;
            Serializable serializable;
            StringBuffer stringBuffer = this.getIndexQuery(captureContext);
            if (migrationObjectFilter != null) {
                serializable = new StringBuffer();
                ((StringBuffer)serializable).append(migrationObjectFilter.toWhereClause("INDNAME "));
                object = ((StringBuffer)serializable).toString().replaceAll("WHERE", "AND");
                stringBuffer.append((String)object);
            }
            serializable = new HashSet();
            this.processFilter(migrationObjectFilter, stringBuffer, (Set<String>)((Object)serializable), "MD_INDEXES");
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            object = closeableResultSet.getResultSet();
            while (object.next() && !captureContext.shouldCancel()) {
                String string = object.getString("INDNAME");
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !serializable.contains(string)) continue;
                DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("TABLEID");
                MdIndexe mdIndexe = new MdIndexe(dBObjectId);
                mdIndexe.setIndexName(string);
                String string2 = object.getString("UNIQUERULE");
                string2 = "U".equals(string2) ? "UNIQUE" : ("D".equals(string2) ? "NON_UNIQUE" : "PRIMARY");
                mdIndexe.setIndexType(string2);
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_INDEXES"), mdIndexe.getIndexName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdIndexe = (MdIndexe)this.getStorer().storeObject((PersistableObject)mdIndexe);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
                this.captureIndexDetails(mdIndexe, captureContext);
            }
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    protected StringBuffer getIndexQuery(CaptureContext captureContext) {
        String string = captureContext.applyToSQLString("${schema}");
        String string2 = captureContext.applyToSQLString("${table}");
        StringBuffer stringBuffer = new StringBuffer(GET_INDEXES_QUERY);
        stringBuffer.append(" INDSCHEMA='").append(string);
        stringBuffer.append("' AND UNIQUERULE <> 'P' AND TABNAME='").append(string2).append("'");
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureIndexDetails(MdIndexe mdIndexe, CaptureContext captureContext) throws SQLException, PersistenceException {
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        String string = this.getIndexDetailsQuery(mdIndexe, captureContext);
        CloseableResultSet closeableResultSet = QueryCapture.issueSQL((String)string, (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
        ResultSet resultSet = closeableResultSet.getResultSet();
        try {
            while (resultSet.next()) {
                String string2 = resultSet.getString("COLNAME");
                int n = resultSet.getInt("COLSEQ");
                DBObjectId dBObjectId = persistenceUtility.getIdForColumn(mdIndexe.getTableId(), string2);
                MdIndexDetail mdIndexDetail = new MdIndexDetail(mdIndexe.getKey(), dBObjectId, Integer.valueOf(n));
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_INDEX_DETAILS"), mdIndexe.getIndexName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdIndexDetail = (MdIndexDetail)this.getStorer().storeObject((PersistableObject)mdIndexDetail);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    protected String getIndexDetailsQuery(MdIndexe mdIndexe, CaptureContext captureContext) {
        String string = captureContext.applyToSQLString("${schema}");
        String string2 = "select COLNAME, COLSEQ from SYSCAT.INDEXCOLUSE WHERE INDNAME='" + mdIndexe.getIndexName() + "' and INDSCHEMA='" + string + "'";
        return string2;
    }

    protected void processFilter(MigrationObjectFilter migrationObjectFilter, StringBuffer stringBuffer, Set<String> set, String string) {
        if (migrationObjectFilter != null && !migrationObjectFilter.getObjectType().equals(string)) {
            throw new IllegalArgumentException(DB2Messages.getString("DB2OnlineCapturer.8") + migrationObjectFilter.getObjectType());
        }
        if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 2) {
            stringBuffer.append(" ").append(migrationObjectFilter.getWhereClause());
        }
        if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1) {
            for (String string2 : migrationObjectFilter.getObjectNames()) {
                set.add(string2);
            }
        }
    }

    private void captureColumns(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        HashSet<String> hashSet = new HashSet<String>();
        StringBuffer stringBuffer = this.getColumnQuery(captureContext);
        this.processFilter(migrationObjectFilter, stringBuffer, hashSet, "MD_COLUMNS");
        this.doColumnCapture(stringBuffer.toString(), "MD_COLUMNSDEFAULTS", this.m_sourceConnection, this.getStorer(), captureContext);
    }

    protected StringBuffer getColumnQuery(CaptureContext captureContext) {
        String string = (String)captureContext.getContextVariable("TABLE");
        String string2 = captureContext.applyToSQLString("${schema}");
        String string3 = MessageFormat.format(GET_COLUMN_QUERY, " WHERE TABNAME='" + string + "' AND TABSCHEMA='" + string2 + "'");
        StringBuffer stringBuffer = new StringBuffer(string3);
        return stringBuffer;
    }

    public void doColumnCapture(String string, String string2, Connection connection, MigrationStorer migrationStorer, CaptureContext captureContext) throws PersistenceException, SQLException {
        CloseableResultSet closeableResultSet = DB2OnlineCapturer.issueSQL(string, connection, captureContext);
        ResultSet resultSet = closeableResultSet.getResultSet();
        int n = 1;
        while (resultSet.next()) {
            if (captureContext.shouldCancel()) {
                closeableResultSet.close();
                CaptureEvent captureEvent = new CaptureEvent(-1, string2, "");
                captureContext.getAudience().fireListeners(captureEvent);
                return;
            }
            if (string2.equals("MD_COLUMNSDEFAULTS")) {
                this.processColumnRowWithDefaults(resultSet, migrationStorer, captureContext, n++);
                continue;
            }
            throw new PersistenceException(MessageFormat.format(Messages.getString((String)"QueryCapture.13"), string2));
        }
        closeableResultSet.close();
    }

    public static CloseableResultSet issueSQL(String string, Connection connection, CaptureContext captureContext) throws SQLException {
        String string2 = captureContext.applyToSQLString(string);
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        return new CloseableResultSet(statement, resultSet);
    }

    private void processColumnRowWithDefaults(ResultSet resultSet, MigrationStorer migrationStorer, CaptureContext captureContext, int n) throws PersistenceException, SQLException {
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("TABLEID");
        String string = resultSet.getString(1);
        String string2 = resultSet.getString(7);
        MdColumn mdColumn = null;
        mdColumn = string2.toUpperCase().equals("Y") ? this.processIdentityColumn(string, captureContext, n) : new MdColumn(dBObjectId, string, Integer.valueOf(n));
        CaptureAudience captureAudience = captureContext.getAudience();
        mdColumn.setColumnType(resultSet.getString(2));
        mdColumn.setPrecision(Integer.valueOf(resultSet.getInt(3)));
        mdColumn.setScale(Integer.valueOf(resultSet.getInt(4)));
        String string3 = resultSet.getString(5);
        string3 = string3.toUpperCase().equals("Y") || string3.equals("1") ? "Y" : "N";
        mdColumn.setNullable(string3);
        mdColumn.setDefaultValue(resultSet.getString(6));
        CaptureEvent captureEvent = new CaptureEvent(3, "COLUMN", mdColumn.getColumnName());
        captureAudience.fireListeners(captureEvent);
        migrationStorer.storeObject((PersistableObject)mdColumn);
        captureEvent.setEventId(4);
        captureAudience.fireListeners(captureEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MdColumn processIdentityColumn(String string, CaptureContext captureContext, int n) {
        MdIdentityColumn mdIdentityColumn;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block8: {
            String string2 = this.getIdentitySQLString(string, captureContext);
            DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
            DBObjectId dBObjectId2 = (DBObjectId)captureContext.getContextVariable("TABLEID");
            preparedStatement = null;
            resultSet = null;
            long l = 0L;
            boolean bl = false;
            long l2 = 0L;
            boolean bl2 = false;
            long l3 = 0L;
            boolean bl3 = false;
            String string3 = null;
            boolean bl4 = false;
            Integer n2 = new Integer(n);
            mdIdentityColumn = null;
            try {
                preparedStatement = this.m_sourceConnection.prepareStatement(string2);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    l = resultSet.getLong(1);
                    bl = resultSet.wasNull();
                    l2 = resultSet.getLong(2);
                    bl2 = resultSet.wasNull();
                    l3 = resultSet.getLong(3);
                    bl3 = resultSet.wasNull();
                    string3 = resultSet.getString(4);
                }
                if (!(bl || bl2 || bl3)) {
                    mdIdentityColumn = new MdIdentityColumn(dBObjectId2, string, n2, l, l2, l3, dBObjectId);
                    break block8;
                }
                if (!bl && !bl2) {
                    mdIdentityColumn = new MdIdentityColumn(dBObjectId2, string, n2, l, l2, dBObjectId);
                    break block8;
                }
                if (bl) {
                    // empty if block
                }
                mdIdentityColumn = new MdIdentityColumn(dBObjectId2, string, n2, l, dBObjectId);
            }
            catch (SQLException sQLException) {
                try {
                    MigrationLogUtil.logThrowable((String)sQLException.getLocalizedMessage(), (String)"Capture", (Throwable)sQLException);
                }
                catch (Throwable throwable) {
                    CloseableResultSet.close((Statement)preparedStatement, resultSet);
                    throw throwable;
                }
                CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
            }
        }
        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
        return mdIdentityColumn;
    }

    private void captureCatalog(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws PersistenceException {
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
        MdCatalog mdCatalog = new MdCatalog(dBObjectId);
        mdCatalog.setDummyFlag("Y");
        mdCatalog.setCatalogName("DB2");
        CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CATALOGS"), "db2");
        captureContext.getAudience().fireListeners(captureEvent);
        this.getStorer().storeObject((PersistableObject)mdCatalog);
        captureEvent.setEventId(4);
        captureContext.getAudience().fireListeners(captureEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureSchemas(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        HashSet<String> hashSet = new HashSet<String>();
        CloseableResultSet closeableResultSet = null;
        StringBuffer stringBuffer = new StringBuffer(this.getSchemaQuery());
        this.processFilter(migrationObjectFilter, stringBuffer, hashSet, "MD_SCHEMAS");
        try {
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            ResultSet resultSet = closeableResultSet.getResultSet();
            while (resultSet.next() && !captureContext.shouldCancel()) {
                String string;
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !hashSet.contains(string = resultSet.getString(1))) continue;
                QueryCapture.processSchemaRow((ResultSet)resultSet, (MigrationStorer)this.getStorer(), (CaptureContext)captureContext);
            }
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    protected String getSchemaQuery() {
        return GET_SCHEMA_QUERY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureViews(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        CloseableResultSet closeableResultSet = null;
        try {
            Object object;
            StringBuffer stringBuffer;
            StringBuffer stringBuffer2 = this.getViewQuery(captureContext);
            if (migrationObjectFilter != null) {
                stringBuffer = new StringBuffer();
                stringBuffer.append(migrationObjectFilter.toWhereClause("VIEWNAME "));
                object = stringBuffer.toString().replaceAll("WHERE", "AND");
                stringBuffer2.append((String)object);
            }
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer2.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            stringBuffer = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
            object = closeableResultSet.getResultSet();
            while (object.next() && !captureContext.shouldCancel()) {
                MdView mdView = new MdView((DBObjectId)stringBuffer, DB2_LANGUAGE_ID);
                mdView.setViewName(object.getString("VIEWNAME"));
                mdView.setNativeSql(object.getString("TEXT"));
                mdView.setCreatedBy(object.getString("OWNER"));
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_VIEWS"), mdView.getViewName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdView = (MdView)this.getStorer().storeObject((PersistableObject)mdView);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    protected StringBuffer getViewQuery(CaptureContext captureContext) {
        String string = captureContext.applyToSQLString("${schema}");
        StringBuffer stringBuffer = new StringBuffer(GET_VIEW_QUERY);
        stringBuffer.append(" WHERE VIEWSCHEMA='").append(string).append("' ");
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureTables(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        HashSet<String> hashSet = new HashSet<String>();
        CloseableResultSet closeableResultSet = null;
        StringBuffer stringBuffer = new StringBuffer(this.getTableQuery(captureContext));
        this.processFilter(migrationObjectFilter, stringBuffer, hashSet, "MD_TABLES");
        try {
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            ResultSet resultSet = closeableResultSet.getResultSet();
            while (resultSet.next() && !captureContext.shouldCancel()) {
                String string;
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !hashSet.contains(string = resultSet.getString(1))) continue;
                QueryCapture.processTableRow((ResultSet)resultSet, (MigrationStorer)this.getStorer(), (CaptureContext)captureContext);
            }
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    protected String getTableQuery(CaptureContext captureContext) {
        StringBuffer stringBuffer = new StringBuffer(GET_TABLE_QUERY);
        String string = captureContext.applyToSQLString("${schema}");
        stringBuffer.append(" WHERE TABSCHEMA='").append(string).append("' and TYPE = 'T'");
        return stringBuffer.toString();
    }
}

