/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.versiontree;

import java.util.LinkedHashMap;
import java.util.Map;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNLogMessageCache {
    Map<String, ISVNLogMessage[]> _cache = new LinkedHashMap<String, ISVNLogMessage[]>();

    public void put(SVNUrl svnUrl, SVNRevision peg, SVNRevision fromRevision, SVNRevision toRevision, ISVNLogMessage[] log) {
        String key = SVNLogMessageCache.getKey(svnUrl, peg, fromRevision, toRevision);
        this._cache.put(key, log);
    }

    public void put(String key, ISVNLogMessage[] log) {
        this._cache.put(key, log);
    }

    public ISVNLogMessage[] get(SVNUrl svnUrl, SVNRevision peg, SVNRevision fromRevision, SVNRevision toRevision) {
        String key = SVNLogMessageCache.getKey(svnUrl, peg, fromRevision, toRevision);
        return this._cache.get(key);
    }

    public ISVNLogMessage[] get(String key) {
        return this._cache.get(key);
    }

    public void clearCache() {
        this._cache.clear();
    }

    public boolean containsKey(SVNUrl svnUrl, SVNRevision peg, SVNRevision fromRevision, SVNRevision toRevision) {
        String key = SVNLogMessageCache.getKey(svnUrl, peg, fromRevision, toRevision);
        return this._cache.containsKey(key);
    }

    public boolean containsKey(String key) {
        return this._cache.containsKey(key);
    }

    public boolean containsValue(ISVNLogMessage[] log) {
        return this._cache.containsValue(log);
    }

    public int size() {
        return this._cache.size();
    }

    public void remove(SVNUrl svnUrl, SVNRevision peg, SVNRevision fromRevision, SVNRevision toRevision) {
        String key = SVNLogMessageCache.getKey(svnUrl, peg, fromRevision, toRevision);
        this._cache.remove(key);
    }

    public static String getKey(SVNUrl svnUrl, SVNRevision peg, SVNRevision fromRevision, SVNRevision toRevision) {
        return svnUrl.toString() + "@" + peg + "_" + fromRevision.toString() + "-" + toRevision.toString();
    }
}

