/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.merge.MergeUtil;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNMergeDirectoryNode;
import oracle.jdevimpl.vcs.svn.merge.SVNDirectoryMergeEditor;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNStatus;

public class SVNOperationResolveTreeConflicts
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.resolve-tree-conflicts";

    public SVNOperationResolveTreeConflicts() {
        super(COMMAND_ID);
    }

    @Override
    protected int doitImpl() throws Exception {
        Context context = ChangeListWindow.handleContext((Context)this.getContext());
        Locatable[] locs = VCSContextUtils.getContextLocatables((Context)context);
        if (locs.length == 0) {
            return 1;
        }
        URL wcroot = SVNUtil.resolveWorkingCopy(locs[0].getURL());
        if (wcroot != null && URLFileSystem.exists((URL)wcroot)) {
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            SVNRepositoryInfo reposInfo = SVNUtil.getFirstAssociatedRepository(wcroot);
            SVNClientInteraction.getInstance().beginInteraction(client, reposInfo);
            ISVNStatus[] statuses = client.getStatus(SVNUtil.toFile(wcroot), true, false, false);
            ArrayList<ISVNStatus> treeconflictStatus = new ArrayList<ISVNStatus>();
            for (ISVNStatus status : statuses) {
                if (!status.hasTreeConflict()) continue;
                treeconflictStatus.add(status);
            }
            SVNClientInteraction.getInstance().endInteraction();
            if (!treeconflictStatus.isEmpty()) {
                MergeUtil.reopenMergeEditor((Node)new SVNMergeDirectoryNode(locs[0].getURL()), locs[0] instanceof Node ? (Node)locs[0] : null, SVNDirectoryMergeEditor.class);
                return 0;
            }
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)Resource.get("ACTION_RESOLVE_TREE_CONFLICTS_NO_CONFLICT_DIALOG_MESSAGE"), (String)Resource.get("ACTION_RESOLVE_TREE_CONFLICTS_NO_CONFLICT_DIALOG_TITLE"), null);
        }
        return 1;
    }
}

