/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.view.View;
import oracle.jdeveloper.merge.MergeUtil;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdevimpl.vcs.svn.SVNMergeDirectoryNode;
import oracle.jdevimpl.vcs.svn.SVNMergeNode;
import oracle.jdevimpl.vcs.svn.SVNMergePropertyNode;
import oracle.jdevimpl.vcs.svn.merge.SVNDirectoryMergeEditor;
import oracle.jdevimpl.vcs.svn.merge.SVNMergeEditor;
import oracle.jdevimpl.vcs.svn.merge.SVNPropertyMergeEditor;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;

public final class SVNOperationResolveConflicts
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.resolve-conflicts";

    protected boolean isAvailableImpl(VCSProfile profile) throws Exception {
        View view;
        Locatable[] locs = VCSContextUtils.getContextLocatables((Context)this.getContext());
        if (locs != null && locs.length == 1 && (view = this.getContext().getView()) instanceof SVNMergeEditor) {
            return false;
        }
        return super.isAvailableImpl(profile);
    }

    public static final boolean isEditorAvailable(URL url) throws Exception {
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion");
        if (profile != null && "oracle.jdeveloper.subversion".equals(profile.getID())) {
            URLFilter wcf = profile.getURLFilter("oracle.jdeveloper.subversion.filters.url.WORKING_COPY");
            if (SVNOperationResolveConflicts.getLocalFilter().accept(url) && URLFileSystem.exists((URL)url) && wcf.accept(url)) {
                return profile.getPolicyStatusCache().get(url) == profile.getStatusInstance("CONFLICTS") && !SVNOperationResolveConflicts.isTreeConflictEditorAvailable(url) && !SVNOperationResolveConflicts.isPropertyConflictEditorAvailable(url);
            }
        }
        return false;
    }

    public static final boolean isTreeConflictEditorAvailable(URL url) throws Exception {
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion");
        if (profile != null && "oracle.jdeveloper.subversion".equals(profile.getID())) {
            return SVNUtil.isTreeConflicted(url);
        }
        return false;
    }

    public static final boolean isPropertyConflictEditorAvailable(URL url) throws Exception {
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion");
        if (profile != null && "oracle.jdeveloper.subversion".equals(profile.getID())) {
            return SVNUtil.isPropertiesConflicted(url);
        }
        return false;
    }

    public SVNOperationResolveConflicts() {
        super(COMMAND_ID);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int doitImpl() throws Exception {
        int ans = 1;
        Context context = ChangeListWindow.handleContext((Context)this.getContext());
        Locatable[] locs = VCSContextUtils.getContextLocatables((Context)context);
        if (locs.length == 0) {
            return 1;
        }
        for (Locatable loc : locs) {
            void var8_8;
            if (!(loc instanceof Node)) continue;
            Node node = (Node)loc;
            if (SVNUtil.isPropertiesConflicted(loc.getURL())) {
                MergeUtil.reopenMergeEditor((Node)new SVNMergePropertyNode(var8_8.getURL()), (Node)var8_8, SVNPropertyMergeEditor.class);
            }
            if (SVNUtil.isTreeConflicted(loc.getURL())) {
                MergeUtil.reopenMergeEditor((Node)new SVNMergeDirectoryNode(var8_8.getURL()), (Node)var8_8, SVNDirectoryMergeEditor.class);
                ans = 0;
            }
            if (!SVNUtil.isTextConflicted(var8_8.getURL())) continue;
            MergeUtil.reopenMergeEditor((Node)new SVNMergeNode(var8_8.getURL()), (Node)var8_8, SVNMergeEditor.class);
            ans = 0;
        }
        return ans;
    }
}

