/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.nav;

import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.util.FastStringBuffer;
import oracle.jdeveloper.vcs.spi.VCSExplorer;
import oracle.jdevimpl.vcs.svn.model.SVNAuthInfo;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.res.Resource;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNRepositoryExplorer
extends VCSExplorer {
    public void setContext(Context context) {
        Node n = context.getNode();
        if (n != null && n.getData() instanceof SVNRepositoryInfo) {
            this.setNode(n);
            this.clearTree();
        }
    }

    protected DefaultMutableTreeNode createTreeNodes() {
        SVNRepositoryInfo reposInfo = this.getNode() != null ? (SVNRepositoryInfo)this.getNode().getData() : null;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        if (reposInfo != null) {
            String user;
            String host;
            SVNUrl url;
            String protocol;
            String name = reposInfo.getAlias();
            if (name != null && name.length() > 0) {
                root.add(new DefaultMutableTreeNode(Resource.format("NAV_REPOS_EXPLORER_NAME", name)));
            }
            if ((protocol = (url = reposInfo.getURL()).getProtocol()) != null) {
                root.add(new DefaultMutableTreeNode(Resource.format("NAV_REPOS_EXPLORER_PROTOCOL", protocol)));
            }
            if ((host = url.getHost()) == null || host.trim().equals("")) {
                host = "localhost";
            }
            root.add(new DefaultMutableTreeNode(Resource.format("NAV_REPOS_EXPLORER_HOST", host)));
            int port = url.getPort();
            if (port > 0) {
                root.add(new DefaultMutableTreeNode(Resource.format("NAV_REPOS_EXPLORER_PORT", String.valueOf(port))));
            }
            String resource = this.getResource(url);
            root.add(new DefaultMutableTreeNode(Resource.format("NAV_REPOS_EXPLORER_RESOURCE", resource)));
            SVNAuthInfo authInfo = reposInfo.getAuthInfo();
            String string = user = authInfo != null ? authInfo.getUserName() : null;
            if (user != null && user.length() > 0) {
                root.add(new DefaultMutableTreeNode(Resource.format("NAV_REPOS_EXPLORER_USER", user)));
            }
        }
        return root;
    }

    private String getResource(SVNUrl url) {
        String[] segs = url.getPathSegments();
        FastStringBuffer buff = new FastStringBuffer(segs.length * 10);
        for (int i = 0; i < segs.length; ++i) {
            buff.append(segs[i]);
            if (i + 1 >= segs.length) continue;
            buff.append('/');
        }
        String res = buff.toString();
        if (!res.startsWith("/")) {
            res = "/" + res;
        }
        return res;
    }
}

