/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.model;

import oracle.jdevimpl.vcs.svn.model.SVNAuthInfo;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tmatesoft.svn.core.SVNURL;

public final class SVNRepositoryInfo {
    private SVNUrl _url;
    private String _alias;
    private SVNAuthInfo _authInfo;

    public SVNRepositoryInfo(SVNUrl url, String alias, SVNAuthInfo authInfo) {
        if (url == null) {
            throw new NullPointerException();
        }
        this._url = url;
        this._alias = alias;
        this._authInfo = authInfo;
    }

    public SVNUrl getURL() {
        return this._url;
    }

    public SVNURL getSVNURL() {
        return SVNUtil.toSVNURL(this._url);
    }

    public String getAlias() {
        return this._alias == null || this._alias.isEmpty() ? this.getURL().toString() : this._alias;
    }

    public SVNAuthInfo getAuthInfo() {
        return this._authInfo;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof SVNRepositoryInfo) {
            SVNRepositoryInfo repos = (SVNRepositoryInfo)obj;
            return this._url.equals((Object)repos._url) && (this._alias != null ? this._alias.equals(repos._alias) : repos._alias == null) && (this._authInfo != null ? this._authInfo.equals(repos._authInfo) : repos._authInfo == null);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this._url.hashCode();
        if (this._alias != null) {
            hashCode += this._alias.hashCode();
        }
        if (this._authInfo != null) {
            hashCode *= this._authInfo.hashCode();
        }
        return hashCode;
    }
}

