/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.changelist;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ideri.util.Product;
import oracle.jdeveloper.vcs.cache.StatusCache;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListEvent;
import oracle.jdeveloper.vcs.changelist.ChangeListEventQueue;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.util.MergeTempFileFilter;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import oracle.jdevimpl.vcs.svn.util.WorkingCopyURLFilter;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;

public final class SVNCandidatesEventQueue
extends ChangeListEventQueue {
    private VCSProfile _profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion");
    private final URLFilter _workingCopyFilter = new WorkingCopyURLFilter();
    private final MergeTempFileFilter _mergeTempFileFilter = new MergeTempFileFilter();
    private VCSStatusFilter _ignoredFilter = this._profile.getStatusFilter("oracle.jdeveloper.subversion.filter.status.IGNORED");
    private StatusCache<VCSStatus> statusCache = this._profile.getPolicyStatusCache();

    public SVNCandidatesEventQueue(ChangeList changeList) {
        super(changeList);
        changeList.setExcludeDirectories(true);
    }

    protected void filterByStatus(Collection<VCSHashURL> urls, boolean applyScope) throws Exception {
        Iterator<VCSHashURL> it = urls.iterator();
        while (it.hasNext()) {
            VCSHashURL url = it.next();
            if (this._workingCopyFilter.accept(url.getURL()) && !this._mergeTempFileFilter.accept(url.getURL()) && !this.isAncesterFolderIgnored(url.getURL())) continue;
            it.remove();
        }
        super.filterByStatus(urls, applyScope);
    }

    protected boolean useVCSStatusURLS() {
        return !Product.isJDeveloper();
    }

    protected Collection<? extends VCSHashURL> getVCSStatusURLS(ChangeListEvent cle) {
        if (Ide.getActiveWorkspace() == null) {
            return Collections.emptyList();
        }
        URL[] roots = SVNUtil.getSVNRootUrls();
        HashSet<VCSHashURL> urls = new HashSet<VCSHashURL>();
        for (URL root : roots) {
            urls.addAll(this.getFileUrls(root));
        }
        return urls;
    }

    private Collection<VCSHashURL> getFileUrls(URL root) {
        SVNStatusClient client = SVNUtil.getStatusClient();
        final HashSet<VCSHashURL> urls = new HashSet<VCSHashURL>();
        ISVNStatusHandler handler = new ISVNStatusHandler(){

            public void handleStatus(SVNStatus status) {
                if (!status.isVersioned() && status.getKind() != SVNNodeKind.DIR) {
                    urls.add(new VCSHashURL(URLFactory.newFileURL((File)status.getFile())));
                }
            }
        };
        ArrayList changelist = new ArrayList();
        try {
            client.doStatus(SVNUtil.toFile(root), null, SVNDepth.INFINITY, false, true, true, false, handler, changelist);
        }
        catch (SVNException e) {
            SVNProfile.getQualifiedLogger(SVNCandidatesEventQueue.class.getName()).log(Level.WARNING, e.getMessage());
        }
        return urls;
    }

    private boolean isAncesterFolderIgnored(URL url) throws Exception {
        boolean gotAdmin = false;
        URL parent;
        while ((parent = URLFileSystem.getParent((URL)url)) != null) {
            boolean isWorkingCopy = SVNUtil.isWorkingCopy(parent);
            if (gotAdmin && !isWorkingCopy) {
                return false;
            }
            if (this._ignoredFilter.accept((VCSStatus)this.statusCache.get(parent))) {
                return true;
            }
            gotAdmin = isWorkingCopy;
            url = parent;
        }
        return false;
    }
}

