/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.net.URLFactory;
import oracle.jdeveloper.vcs.generic.RemovedEntryLister;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.model.SVNURLInfo;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNRemovedEntryLister
extends RemovedEntryLister {
    public URL[] listRemovedEntries(URL directoryUrl) throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (!SVNUtil.insideWorkingCopy(directoryUrl)) {
            return new URL[0];
        }
        try {
            Map<VCSHashURL, SVNURLInfo> results = SVNURLInfoCache.getInstance().getDirectoryURLInfo(directoryUrl, false);
            for (Map.Entry<VCSHashURL, SVNURLInfo> entry : results.entrySet()) {
                URL url = entry.getKey().getURL();
                if (this.isRemovedURL(url, entry.getValue().getNodeStatus())) {
                    urls.add(url);
                    continue;
                }
                if (this.isMissingURL(url, entry.getValue().getNodeStatus())) {
                    urls.add(url);
                    continue;
                }
                if (!this.isConflictURL(url, entry.getValue().getNodeStatus())) continue;
                urls.add(url);
            }
        }
        catch (UnsupportedOperationException uoe) {
            Collection<SVNStatus> statuses = SVNUtil.getSVNStatus(SVNUtil.getStatusClient(), directoryUrl);
            for (SVNStatus status : statuses) {
                URL url = URLFactory.newFileURL((File)status.getFile());
                if (!this.isRemovedURL(url, status.getContentsStatus())) continue;
                urls.add(url);
            }
        }
        return urls.toArray(new URL[0]);
    }

    private final boolean isRemovedURL(URL url, SVNStatusType status) {
        return status == SVNStatusType.STATUS_DELETED && !GlobalIgnoreList.isGloballyIgnored((URL)url);
    }

    private boolean isMissingURL(URL url, SVNStatusType status) {
        return status == SVNStatusType.MISSING && !GlobalIgnoreList.isGloballyIgnored((URL)url);
    }

    private boolean isConflictURL(URL url, SVNStatusType status) {
        return status == SVNStatusType.STATUS_CONFLICTED && !GlobalIgnoreList.isGloballyIgnored((URL)url);
    }
}

