/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.list.CompareListItem;
import oracle.jdeveloper.merge.BaseMergeNode;
import oracle.jdeveloper.vcs.spi.VCSFileEventSender;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.compare.SVNComparableProperty;
import oracle.jdevimpl.vcs.svn.compare.SVNPropertiesCompareContributor;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tmatesoft.svn.core.SVNException;

public class SVNMergePropertyNode
extends BaseMergeNode<CompareModel> {
    public SVNMergePropertyNode(URL url) {
        super(url);
    }

    protected void saveResultToURL(CompareModel compareModel, URL url) {
        SVNPropertiesCompareContributor first = (SVNPropertiesCompareContributor)compareModel.getContributor(ContributorKind.FIRST);
        File file = SVNUtil.toFile(url);
        try {
            ISVNClientAdapter client = SVNUtil.getClientAdapter(SVNProfile.IDE_CLIENT_CONTEXT_ID, SVNProfile.CACHE_ADAPTER_CONTEXT_ID);
            SVNClientInteraction.getInstance().beginInteraction(client, SVNUtil.getFirstAssociatedRepository(url));
            CompareListItem[] compareItems = first.getCompareList().getItems();
            ArrayList<ISVNProperty> properties = new ArrayList<ISVNProperty>();
            properties.addAll(Arrays.asList(client.getProperties(file)));
            for (ISVNProperty property : properties) {
                client.propertyDel(file, property.getName(), false);
            }
            for (CompareListItem item : compareItems) {
                client.propertySet(file, ((SVNComparableProperty)item).getName(), ((SVNComparableProperty)item).getValue(), false);
            }
            SVNClientInteraction.getInstance().endInteraction();
            SVNOperationLogger.getInstance().beginOperation(client, SVNUtil.getFirstAssociatedRepository(url));
            client.resolved(file);
            SVNOperationLogger.getInstance().endOperation();
            VCSFileEventSender.fireFileStructureChanged((URL[])new URL[]{url, URLFileSystem.getParent((URL)url)});
            VCSFileEventSender.fireFilesModified((URL[])new URL[]{url, URLFileSystem.getParent((URL)url)});
            return;
        }
        catch (SVNClientException e) {
            e.printStackTrace();
        }
        catch (SVNException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        VCSFileEventSender.fireFileStructureChanged((URL[])new URL[]{url, URLFileSystem.getParent((URL)url)});
        VCSFileEventSender.fireFilesModified((URL[])new URL[]{url, URLFileSystem.getParent((URL)url)});
    }
}

