/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.awt.Component;
import java.util.logging.Level;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.spi.VCSCancelException;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNVCSException;
import oracle.jdevimpl.vcs.svn.nav.cmd.EditConnectionCommand;

public class SVNExceptionHandler
extends VCSExceptionHandler {
    public static final String AUTHENTICATION_ERROR_EDIT = "authenication-edit";

    public final void handleExceptionWithOption(Exception ex) {
        String msg;
        String title;
        if (ex instanceof VCSCancelException) {
            return;
        }
        if (!(ex instanceof VCSException)) {
            super.handleException(ex);
        }
        if ((title = ((VCSException)ex).getTitle()) == null) {
            title = IdeUtil.getProgramName();
        }
        if ((msg = ex.getMessage()) != null && !msg.equals("")) {
            MessageDialog.optionalInformation((String)title, null, (Object)msg, (String)title, null);
            return;
        }
        MessageDialog.error(null, (Object)msg, (String)title, null);
    }

    protected void handleExceptionImpl(Exception e, Component parent) {
        if ((e = SVNExceptionWrapper.wrapException(e)).getMessage().contains("E200015") && e instanceof SVNVCSException) {
            boolean ans;
            if (!Ide.getIdeArgs().getCreateUI()) {
                e.printStackTrace();
                return;
            }
            String title = ((SVNVCSException)((Object)e)).getTitle();
            if (title == null) {
                title = IdeUtil.getProgramName();
            }
            if (ans = MessageDialog.confirm((Component)parent, (Object)e.getMessage(), (String)title, null)) {
                EditConnectionCommand cmd = new EditConnectionCommand();
                cmd.setContext(((SVNVCSException)((Object)e)).getContext());
                ((SVNVCSException)((Object)e)).getContext().setProperty(AUTHENTICATION_ERROR_EDIT, (Object)Boolean.TRUE);
                try {
                    CommandProcessor.getInstance().invoke((Command)cmd);
                }
                catch (Exception f) {
                    SVNProfile.getQualifiedLogger(SVNExceptionHandler.class.getName()).log(Level.WARNING, "Invoke Edit connection " + f.getMessage());
                }
            }
            return;
        }
        super.handleExceptionImpl(e, parent);
    }
}

