/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.ExtensionRegistry;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNAuthenticationManager {
    private URL _configUrl;
    private ISVNOptions _options;
    private File _defaultConfigDir;
    private Map<SVNRepositoryInfo, SVNClientManager> _clientManagers = Collections.synchronizedMap(new HashMap());
    private static final SVNAuthenticationManager _instance = new SVNAuthenticationManager();

    private SVNAuthenticationManager() {
    }

    public static SVNAuthenticationManager getInstance() {
        return _instance;
    }

    public URL getConfigUrl() {
        if (this._configUrl == null && System.getProperty("jdev.svn.default-config-dir") == null) {
            this._configUrl = ExtensionRegistry.getExtensionRegistry().getSystemDirectory("oracle.jdeveloper.subversion");
        }
        return this._configUrl;
    }

    public SVNClientManager getSVNClientManager(SVNRepositoryInfo svnInfo) {
        SVNClientManager manager = this._clientManagers.get(svnInfo);
        if (manager == null) {
            manager = SVNClientManager.newInstance((ISVNOptions)this.getOptions(), (ISVNAuthenticationManager)this.getAuthenticationManager(svnInfo));
            this._clientManagers.put(svnInfo, manager);
        }
        return manager;
    }

    public void remove(SVNRepositoryInfo svnInfo) {
        SVNClientManager manager = this._clientManagers.get(svnInfo);
        if (manager != null) {
            this._clientManagers.remove(svnInfo);
            manager.dispose();
        }
    }

    private ISVNOptions getOptions() {
        if (this._options == null) {
            this._options = this.getConfigDir() == null ? SVNWCUtil.createDefaultOptions((boolean)true) : SVNWCUtil.createDefaultOptions((File)this.getConfigDir(), (boolean)true);
        }
        return this._options;
    }

    private ISVNAuthenticationManager getAuthenticationManager(SVNRepositoryInfo svnInfo) {
        if (this.getConfigDir() == null) {
            return SVNWCUtil.createDefaultAuthenticationManager((String)svnInfo.getAuthInfo().getUserName(), (String)new String(svnInfo.getAuthInfo().getPassword()));
        }
        return SVNWCUtil.createDefaultAuthenticationManager((File)this.getConfigDir(), (String)svnInfo.getAuthInfo().getUserName(), (String)new String(svnInfo.getAuthInfo().getPassword()));
    }

    private File getConfigDir() {
        if (this._defaultConfigDir == null) {
            if (this.getConfigUrl() == null) {
                return null;
            }
            this._defaultConfigDir = new File(this.getConfigUrl().getPath());
        }
        return this._defaultConfigDir;
    }
}

