/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.boot;

import java.util.LinkedList;

public class ShellIntegration {
    private static final boolean ENABLED = System.getProperty("ide.shell.enableFileTypeAssociation") != null;
    private static final LinkedList<String> queue = ENABLED ? new LinkedList() : null;
    private static Handler handler;

    public static synchronized void runCommand(String command) {
        if (ENABLED) {
            if (handler != null) {
                handler.runCommand(command);
            } else {
                queue.add(command);
            }
        }
    }

    public static synchronized void setHandler(Handler handler) {
        if (ENABLED && handler != null) {
            ShellIntegration.handler = handler;
            for (String command : queue) {
                handler.runCommand(command);
            }
            queue.clear();
        }
    }

    public static interface Handler {
        public void runCommand(String var1);
    }
}

