/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.services;

import java.beans.Beans;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.codesharing.audit.annotation.CodeSharingSafe;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.common.rc.util.impl.URLUtil;
import oracle.adf.share.services.ServiceRef;
import oracle.adf.share.services.Services;
import oracle.adf.share.services.impl.ADFServicesImpl;
import oracle.adf.share.services.impl.ServicesEnumeration;
import oracle.adf.share.services.impl.URLStreamProvider;
import oracle.adf.share.services.impl.URLStreamProviderFactory;

public class ServicesFactory {
    private static final String SERVICES_DIR = "META-INF/";
    private static final String SERVICES_EXT = ".sva";
    private static final String RESOURCE_SERVICE_NAME = "META-INF/oracle.adf.common.services.ResourceService.sva";
    private static final Logger logger = Logger.getLogger(ServicesFactory.class.getName());
    @CodeSharingSafe(value="MutableStaticField")
    private static final boolean logging = !Beans.isDesignTime() && logger.isLoggable(Level.FINE);

    public static List<ServiceRef> findServiceRefs(String serviceName, ClassLoader loader) throws IOException {
        ArrayList<ServiceRef> results = new ArrayList<ServiceRef>();
        if (loader == null) {
            loader = ClassUtils.getClassLoader(ServicesFactory.class);
        }
        URLStreamProvider strmProv = URLStreamProviderFactory.getProvider();
        if ("oracle.adf.common.services.ResourceService".equalsIgnoreCase(serviceName)) {
            Enumeration<URL> resources = loader.getResources(RESOURCE_SERVICE_NAME);
            while (resources.hasMoreElements()) {
                results.add(new ADFJarServiceRef(resources.nextElement(), strmProv));
            }
        } else {
            if (serviceName == null || serviceName.length() == 0) {
                serviceName = Services.class.getName();
            }
            Enumeration<URL> resources = loader.getResources(ServicesFactory.getServiceFileName(serviceName));
            while (resources.hasMoreElements()) {
                results.add(new ServiceRefImpl(resources.nextElement(), strmProv));
            }
        }
        return results;
    }

    public static String getServiceFileName(String serviceName) {
        return "oracle.adf.common.services.ResourceService".equals(serviceName) ? RESOURCE_SERVICE_NAME : SERVICES_DIR + serviceName + SERVICES_EXT;
    }

    private static class ServiceRefImpl
    implements ServiceRef {
        private static final Class[] SERVICE_CONSTRUCTOR_PARAM_TYPES = new Class[]{URL.class, Enumeration.class};
        URL url;
        URLStreamProvider strmProv;

        public ServiceRefImpl(URL url, URLStreamProvider strmProv) {
            this.strmProv = strmProv;
            try {
                this.url = URLUtil.getURLForPath(url, false);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(String.valueOf(url), e);
            }
            if (logging) {
                logger.fine("ServiceRef created for: " + url);
            }
        }

        @Override
        public URL getServiceURL() {
            return this.url;
        }

        @Override
        public Services getService() {
            ServicesEnumeration svcs = null;
            Class svcClass = null;
            Services svc = null;
            String svcImplClassName = null;
            InputStream ins = null;
            try {
                if (logging) {
                    logger.fine("Getting enum for: " + this.url);
                }
                if ((svcs = new ServicesEnumeration(new InputStreamReader(ins = this.strmProv.openStream(this.url), "UTF-8"))).hasMoreElements()) {
                    svcImplClassName = svcs.nextElement();
                }
                if (svcImplClassName != null) {
                    if (logging) {
                        logger.fine("ServicesFactory init: " + svcImplClassName + " for " + this.url);
                    }
                    svcClass = ClassUtils.forName(svcImplClassName, ServicesFactory.class);
                    Constructor ctor = svcClass.getConstructor(SERVICE_CONSTRUCTOR_PARAM_TYPES);
                    svc = (Services)ctor.newInstance(this.url, svcs);
                    if (logging) {
                        logger.fine("ServicesFactory init done: " + svcImplClassName);
                    }
                } else if (logging) {
                    logger.fine("No services found in: " + this.url);
                }
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            finally {
                if (svcs != null) {
                    if (logging) {
                        logger.fine("closing enumeration for: " + this.url);
                    }
                    svcs.close();
                } else if (ins != null) {
                    try {
                        if (logging) {
                            logger.fine("closing 'ins' in enumeration");
                        }
                        ins.close();
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, this.url + " input stream close failed", e);
                    }
                }
            }
            return svc;
        }
    }

    private static class ADFJarServiceRef
    implements ServiceRef {
        URL url;
        URLStreamProvider strmProv;

        public ADFJarServiceRef(URL url, URLStreamProvider strmProv) {
            this.strmProv = strmProv;
            try {
                this.url = URLUtil.getURLForPath(url, false);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(String.valueOf(url), e);
            }
            if (logging) {
                logger.fine("ServiceRef created for: " + url);
            }
        }

        @Override
        public URL getServiceURL() {
            return this.url;
        }

        @Override
        public Services getService() {
            ServicesEnumeration svcs = null;
            ADFServicesImpl svc = null;
            InputStream ins = null;
            try {
                if (logging) {
                    logger.fine("Getting enum for: " + this.url);
                }
                ins = this.strmProv.openStream(this.url);
                svcs = new ServicesEnumeration(new InputStreamReader(ins, "UTF-8"));
                svc = new ADFServicesImpl(this.url, svcs);
                if (logging) {
                    logger.fine("ServicesFactory init done");
                }
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            finally {
                if (svcs != null) {
                    if (logging) {
                        logger.fine("closing enumeration for: " + this.url);
                    }
                    svcs.close();
                } else if (ins != null) {
                    try {
                        if (logging) {
                            logger.fine("closing 'ins' in enumeration");
                        }
                        ins.close();
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, this.url + " input stream close failed", e);
                    }
                }
            }
            return svc;
        }
    }
}

