/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.platform;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.ResourceBundle;
import oracle.adf.share.platform.resources.ADFPlatformMessageBundle;
import oracle.adfinternal.share.util.GetPropertyAction;

public class AdfServerPlatformUtil {
    public static boolean isWebLogic() {
        return AdfServerPlatformUtil.internalGetSystemProperty("weblogic.Name") != null;
    }

    public static boolean isWebSphere() {
        return AdfServerPlatformUtil.internalGetSystemProperty("was.install.root") != null || AdfServerPlatformUtil.internalGetSystemProperty("server.root") != null;
    }

    public static boolean isWebSphereND() {
        if (AdfServerPlatformUtil.isWebSphere()) {
            try {
                Class<?> clazz = Class.forName("oracle.jrf.was.WasServerPlatformSupport");
                Method method = clazz.getMethod("isND", new Class[0]);
                Boolean ret = (Boolean)method.invoke(null, new Object[0]);
                return ret;
            }
            catch (Throwable e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isWebSphereAS() {
        if (AdfServerPlatformUtil.isWebSphere()) {
            try {
                return !AdfServerPlatformUtil.isWebSphereND();
            }
            catch (Throwable e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isJBoss() {
        return AdfServerPlatformUtil.internalGetSystemProperty("jboss.home.dir") != null;
    }

    public static boolean isJEE() {
        boolean isjee = false;
        isjee = AdfServerPlatformUtil.isWebLogic() || AdfServerPlatformUtil.isWebSphere() || AdfServerPlatformUtil.isTomcat() || AdfServerPlatformUtil.isJBoss() || AdfServerPlatformUtil.isGlassFish();
        return isjee;
    }

    public static boolean isGlassFish() {
        return AdfServerPlatformUtil.internalGetSystemProperty("glassfish.version") != null;
    }

    public static boolean isTomcat() {
        return (AdfServerPlatformUtil.internalGetSystemProperty("catalina.home") != null || AdfServerPlatformUtil.internalGetSystemProperty("catalina.base") != null) && AdfServerPlatformUtil.internalGetSystemProperty("glassfish.version") == null;
    }

    private static Class loadOracleChecksum(ClassLoader cl) throws Exception {
        Class<?> clazz = null;
        try {
            if (cl != null) {
                clazz = Class.forName("oracle.security.misc.Checksum", true, cl);
                return clazz;
            }
        }
        catch (ClassNotFoundException e) {
            clazz = AdfServerPlatformUtil.loadOracleChecksum(cl.getParent());
        }
        return clazz;
    }

    public static byte[] getCheckSum(String algorithm, byte[] data) throws Exception {
        Class clazz;
        if (data == null) {
            return new byte[0];
        }
        if (algorithm == null) {
            algorithm = "MD5";
        }
        if ((clazz = AdfServerPlatformUtil.loadOracleChecksum(AdfServerPlatformUtil.getThreadContextClassLoader())) == null) {
            return new byte[0];
        }
        Method checkSumMethod = null;
        if (algorithm.toUpperCase().equals("MD5")) {
            checkSumMethod = clazz.getMethod("MD5", byte[].class, byte[].class);
            if (checkSumMethod != null) {
                return (byte[])checkSumMethod.invoke(null, new Object[]{data, null});
            }
        } else if (algorithm.toUpperCase().equals("SHA")) {
            checkSumMethod = clazz.getMethod("SHA", byte[].class, byte[].class);
            if (checkSumMethod != null) {
                return (byte[])checkSumMethod.invoke(null, new Object[]{data, null});
            }
        } else if (algorithm.toUpperCase().equals("MD2")) {
            checkSumMethod = clazz.getMethod("MD2", byte[].class, byte[].class, byte[].class);
            if (checkSumMethod != null) {
                return (byte[])checkSumMethod.invoke(null, data, null, null);
            }
        } else if (algorithm.toUpperCase().equals("MD4")) {
            checkSumMethod = clazz.getMethod("MD4", byte[].class, byte[].class, byte[].class);
            if (checkSumMethod != null) {
                return (byte[])checkSumMethod.invoke(null, data, null, null);
            }
        } else {
            ResourceBundle platformRes = ResourceBundle.getBundle(ADFPlatformMessageBundle.class.getName());
            throw new NoSuchAlgorithmException(algorithm + " " + platformRes.getString("CHECKSUM_ALGORITHM_NOT_SUPPORTED"));
        }
        return new byte[0];
    }

    public static String getSystemProperty(final String name) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(name);
            }
        });
    }

    public static String setSystemProperty(final String name, final String value) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.setProperty(name, value);
            }
        });
    }

    public static String clearSystemProperty(final String name) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.clearProperty(name);
            }
        });
    }

    private static final String internalGetSystemProperty(String propertyName) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(propertyName);
        }
        return AccessController.doPrivileged(new GetPropertyAction(propertyName));
    }

    private static final ClassLoader getThreadContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

