/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.mt.util;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.platform.mt.MTHelper;
import oracle.adf.share.platform.mt.Tenant;
import oracle.adf.share.platform.mt.TenantContext;
import oracle.adf.share.platform.mt.TenantContextFactory;

public class MultiTenantStorage<T> {
    private static final Logger logger = Logger.getLogger(MultiTenantStorage.class.getName());
    private final ValueStorage<T> valueStorage = MTHelper.getMultitenancyEnabled() ? new MultiValueStorage() : new SingleValueStorage();

    public T get() {
        return this.valueStorage.getValue(this);
    }

    public T set(T newValue) {
        return this.valueStorage.setValue(newValue, this);
    }

    public T remove() {
        return this.valueStorage.removeValue();
    }

    protected T initialValue() {
        return null;
    }

    private Holder<T> newHolder(T value) {
        return logger.isLoggable(Level.FINEST) ? new DiagnosticHolder<T>(value, this) : new Holder<T>(value, this);
    }

    private static class DiagnosticHolder<T>
    extends Holder<T> {
        private Throwable createdBy = new Throwable("Created By");

        public DiagnosticHolder(T value, MultiTenantStorage<T> mts) {
            super(value, mts);
        }

        @Override
        public T getValue() {
            return (T)this.value;
        }
    }

    private static class Holder<T> {
        protected T value;

        public Holder(T value, MultiTenantStorage<T> mts) {
            this.value = value != null ? value : mts.initialValue();
        }

        public T getValue() {
            return this.value;
        }
    }

    private static final class MultiValueStorage<T>
    implements ValueStorage<T> {
        private static final int INITIAL_HOLDERS_SIZE = 4;
        private ConcurrentHashMap<Object, Holder<T>> mtHolders = new ConcurrentHashMap(4);

        private MultiValueStorage() {
        }

        @Override
        public T getValue(MultiTenantStorage<T> mts) {
            Holder beatBy;
            Object key = this.getStripingKey();
            Holder h = this.mtHolders.get(key);
            if (h == null && (beatBy = this.mtHolders.putIfAbsent(key, h = ((MultiTenantStorage)mts).newHolder(null))) != null) {
                h = beatBy;
            }
            return h.getValue();
        }

        @Override
        public T setValue(T newValue, MultiTenantStorage<T> mts) {
            Holder h = this.mtHolders.put(this.getStripingKey(), ((MultiTenantStorage)mts).newHolder(newValue));
            return h != null ? (T)h.getValue() : null;
        }

        @Override
        public T removeValue() {
            Holder<T> h = this.mtHolders.remove(this.getStripingKey());
            return h != null ? (T)h.getValue() : null;
        }

        private Object getStripingKey() {
            TenantContext tc = TenantContextFactory.getInstance().getTenantContext();
            if (tc != null) {
                UUID uuid = tc.getServiceUUID();
                if (uuid != null) {
                    return uuid;
                }
                Tenant t = tc.getCurrentTenant();
                String tid = t.getTenantId();
                if (tid != null) {
                    return tid;
                }
            }
            MTHelper.throwTenantInvalidException();
            return null;
        }
    }

    private static final class SingleValueStorage<T>
    implements ValueStorage<T> {
        private volatile Holder<T> holder;
        private static AtomicReferenceFieldUpdater<SingleValueStorage, Holder> holderUpdater = AtomicReferenceFieldUpdater.newUpdater(SingleValueStorage.class, Holder.class, "holder");

        private SingleValueStorage() {
        }

        @Override
        public T getValue(MultiTenantStorage<T> mts) {
            if (this.holder == null) {
                holderUpdater.compareAndSet(this, null, ((MultiTenantStorage)mts).newHolder(null));
            }
            return this.holder != null ? (T)this.holder.getValue() : null;
        }

        @Override
        public T setValue(T newValue, MultiTenantStorage<T> mts) {
            Holder prev = holderUpdater.getAndSet(this, ((MultiTenantStorage)mts).newHolder(newValue));
            return prev != null ? (T)prev.getValue() : null;
        }

        @Override
        public T removeValue() {
            Holder prev = holderUpdater.getAndSet(this, null);
            return prev != null ? (T)prev.getValue() : null;
        }
    }

    static interface ValueStorage<T> {
        public T getValue(MultiTenantStorage<T> var1);

        public T setValue(T var1, MultiTenantStorage<T> var2);

        public T removeValue();
    }
}

