/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging.internal.perf;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.adf.share.codesharing.audit.annotation.CodeSharingSafe;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.logging.internal.perf.ADFPerfSensor;
import oracle.adf.share.mt.util.MultiTenantStorage;

public class SensorTable {
    private static final ADFLogger mLogger = ADFLogger.createADFLogger(SensorTable.class);
    private static final MultiTenantStorage<ConcurrentHashMap<ClassLoader, ConcurrentHashMap<String, ADFPerfSensor>>> sSensors = new MultiTenantStorage<ConcurrentHashMap<ClassLoader, ConcurrentHashMap<String, ADFPerfSensor>>>(){

        @Override
        protected ConcurrentHashMap<ClassLoader, ConcurrentHashMap<String, ADFPerfSensor>> initialValue() {
            return new ConcurrentHashMap<ClassLoader, ConcurrentHashMap<String, ADFPerfSensor>>();
        }
    };
    @CodeSharingSafe(value="MutableStaticField")
    private static Object mAdfShareUtilsClz = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, ADFPerfSensor> getSensors(int flags, ClassLoader clsLoader, String sensorName) {
        ConcurrentHashMap<String, ADFPerfSensor> sensors = null;
        if (mAdfShareUtilsClz == null || mAdfShareUtilsClz instanceof Class) {
            if (mAdfShareUtilsClz == null) {
                try {
                    mAdfShareUtilsClz = ClassUtils.forName("oracle.adf.share.util.AdfShareUtils");
                }
                catch (Exception e) {
                    if (mLogger.isFinest() && sensorName != null) {
                        mLogger.finest("ADFSensor:  " + sensorName + " was created in an invalid ADFContext.  Please ensure that ADF is conifgured on the classpath.");
                    }
                    mAdfShareUtilsClz = new Object();
                }
            }
            if (mAdfShareUtilsClz instanceof Class) {
                try {
                    sensors = (ConcurrentHashMap<String, ADFPerfSensor>)((Class)mAdfShareUtilsClz).getMethod("getSensorTable", Integer.TYPE).invoke(null, flags);
                }
                catch (Exception e) {
                    if (mLogger.isFinest()) {
                        StringBuilder sb = new StringBuilder("An exception occurred while invoking AdfShareUtils.getSensorTable.\n");
                        sb.append(e.getMessage());
                        mLogger.finest(sb.toString());
                    }
                    mAdfShareUtilsClz = new Object();
                }
                if (sensors == null && (flags & 1) > 0 && mLogger.isFinest()) {
                    mLogger.finest("ADFSensor:  " + sensorName + " was created in an invalid ADFContext.  Please initialize a valid ADFContext before creating ADFSensors.");
                }
            }
        }
        if (sensors == null) {
            if (clsLoader == null) {
                clsLoader = ClassUtils.getClassLoader();
            }
            if (sSensors.get() != null) {
                sensors = (flags & 2) > 0 ? sSensors.get().remove(clsLoader) : sSensors.get().get(clsLoader);
            }
            if (sensors != null || (flags & 1) <= 0) return sensors;
            Class<SensorTable> e = SensorTable.class;
            synchronized (SensorTable.class) {
                sensors = (flags & 2) > 0 ? sSensors.get().remove(clsLoader) : sSensors.get().get(clsLoader);
                if (sensors != null) return sensors;
                sensors = new ConcurrentHashMap();
                sSensors.get().put(clsLoader, sensors);
                // ** MonitorExit[e] (shouldn't be in output)
                return sensors;
            }
        }
        if (sSensors == null) return sensors;
        if (clsLoader == null) {
            clsLoader = ClassUtils.getClassLoader();
        }
        Map clSensors = null;
        Class<SensorTable> clazz = SensorTable.class;
        synchronized (SensorTable.class) {
            clSensors = sSensors.get().remove(clsLoader);
            // ** MonitorExit[var5_7] (shouldn't be in output)
            if (clSensors == null) return sensors;
            sensors.putAll(clSensors);
            if (!mLogger.isWarning()) return sensors;
            mLogger.warning("Detected that sensors created in an invalid ADFContext were later visible in a valid ADFContext.  The sensors should be created in a valid ADFContext.  Please enable finest logging for more information.");
            return sensors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ADFPerfSensor putSensor(String name, ADFPerfSensor sensor) {
        Map<String, ADFPerfSensor> sensors;
        Map<String, ADFPerfSensor> map = sensors = SensorTable.getSensors(1, null, name);
        synchronized (map) {
            ADFPerfSensor s = sensors.get(name);
            if (s == null) {
                sensors.put(name, sensor);
                s = sensor;
            }
            return s;
        }
    }

    public static ADFPerfSensor getSensor(String name) {
        Map<String, ADFPerfSensor> sensors = SensorTable.getSensors(0, null, name);
        if (sensors != null) {
            return sensors.get(name);
        }
        return null;
    }

    public static void cleanupSensors(ClassLoader clsLoader) {
        Map<String, ADFPerfSensor> sensors = SensorTable.getSensors(2, clsLoader, null);
        if (sensors != null) {
            for (ADFPerfSensor s : sensors.values()) {
                s.reset();
            }
        }
    }
}

