/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging.internal.perf;

import java.text.DateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.codesharing.audit.annotation.CodeSharingSafe;
import oracle.adf.share.logging.internal.LoggingConstants;
import oracle.adf.share.logging.internal.LoggingUtils;
import oracle.adf.share.logging.internal.perf.PerfFileHandler;
import oracle.adf.share.logging.internal.perf.PerfLogRecord;
import oracle.adf.share.mt.util.MultiTenantStorage;

public class ADFPerfSensor {
    private static final MultiTenantStorage<AtomicInteger> sIndex = new MultiTenantStorage<AtomicInteger>(){

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger();
        }
    };
    protected String mSensorFullName;
    protected Level mLevel = null;
    protected int mIndex = 0;
    protected boolean mEnablePerfLog = false;
    protected boolean mEnableDms = false;
    private boolean mIsTimerLogged = false;
    private static final String ADF_PERF_LOGGER_IDX = "oracle.adf.perfIdx";
    protected static final Logger sLogger = Logger.getLogger("oracle.adf.perf");
    protected static final Logger sIdxLogger = Logger.getLogger("oracle.adf.perfIdx");
    @CodeSharingSafe(value="MutableStaticField")
    private static Handler sIdxHandler = PerfFileHandler.setupLoggers(sLogger, sIdxLogger);
    private DateFormat format = DateFormat.getDateTimeInstance(0, 1);
    private static final String LOG_LINE_FORMAT = "# Time stamp line format: T long format of date time (timestamp)" + LoggingConstants.LINE_SEPARATOR + "# " + "Sensor index line format: " + "I " + "<sensorIndex> <sensorFullName> <type>" + LoggingConstants.LINE_SEPARATOR + "# " + "Performance entry line format: " + "<ecid> [<sensorIndex> <RID> <timeStamp> <value>]*" + LoggingConstants.LINE_SEPARATOR + "# " + "where <type> can be: " + "t - timer, s - state, c - counter" + LoggingConstants.LINE_SEPARATOR;

    public ADFPerfSensor(Level level, String sensorFullName) {
        sIdxLogger.log(Level.SEVERE, LOG_LINE_FORMAT);
        sIdxLogger.log(Level.SEVERE, "T " + this.format.format(new Date(LoggingConstants.STARTTIME.get())) + " (" + LoggingConstants.STARTTIME.get() + ")" + LoggingConstants.LINE_SEPARATOR);
        this.mLevel = level;
        this.mSensorFullName = sensorFullName;
        this.mIndex = ADFPerfSensor.getIndex();
        this.mEnablePerfLog = sLogger.isLoggable(level);
        this.mEnableDms = LoggingUtils.isDMSLoggingEnabled(level);
    }

    protected ADFPerfSensor() {
        sIdxLogger.log(Level.SEVERE, LOG_LINE_FORMAT);
        sIdxLogger.log(Level.SEVERE, "T " + this.format.format(new Date(LoggingConstants.STARTTIME.get())) + " (" + LoggingConstants.STARTTIME.get() + ")" + LoggingConstants.LINE_SEPARATOR);
    }

    protected void log(long timeStamp, String value, String ecid) {
        this.logIndex();
        PerfLogRecord record = new PerfLogRecord(this.mLevel, value);
        record.setMillis(timeStamp);
        record.setIndex(this.mIndex);
        record.setEcid(ecid);
        sLogger.log(record);
    }

    public boolean isActive() {
        return this.mEnablePerfLog || this.mEnableDms;
    }

    private synchronized void logIndex() {
        if (!this.mIsTimerLogged) {
            StringBuffer sb = new StringBuffer();
            sb.append("I ");
            sb.append(this.mIndex);
            sb.append(" ");
            sb.append(this.mSensorFullName);
            sb.append(LoggingConstants.LINE_SEPARATOR);
            sIdxLogger.log(this.mLevel, sb.toString());
            if (sIdxHandler != null) {
                sIdxHandler.flush();
            }
            this.mIsTimerLogged = true;
        }
    }

    private static int getIndex() {
        return sIndex.get().incrementAndGet();
    }

    public void reset() {
    }
}

