/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging.internal.diagnostic;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.adf.share.codesharing.audit.annotation.CodeSharingSafe;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.logging.ADFLoggerConstants;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.logging.ODLFormatter;
import oracle.core.ojdl.logging.ODLLogRecord;

public class ConsoleFormatter
extends Formatter {
    private static final String messageType = System.getProperty("oracle.adfdiagnostics.ConsoleFormatter.ShowLevel");
    private static final String timeStamp = System.getProperty("oracle.adfdiagnostics.ConsoleFormatter.ShowTimeStamp");
    @CodeSharingSafe(value="MutableStaticField")
    private static final boolean showMessageType = messageType != null && messageType.toUpperCase().equals("TRUE");
    @CodeSharingSafe(value="MutableStaticField")
    private static final boolean showTimeStamp = timeStamp != null && timeStamp.toUpperCase().equals("TRUE");
    @CodeSharingSafe(value="MutableStaticField")
    private static final Object[] compKeys = ADFLoggerConstants.getADFComponents().keySet().toArray();
    @CodeSharingSafe(value="MutableStaticField")
    private static final Map<String, String> comps = ADFLoggerConstants.getADFComponents();
    static final ADFLogger diaglogger = ADFLogger.createADFLogger(ConsoleFormatter.class.getName());
    @CodeSharingSafe(value="MutableStaticField")
    private static final String lineSeparator = ConsoleFormatter.getLineSeparator();

    private String getShortClassName(String clazz) {
        if (clazz == null) {
            return clazz;
        }
        String[] segs = clazz.split("\\.");
        return segs[segs.length - 1];
    }

    @Override
    public synchronized String format(LogRecord rec) {
        String sbr = "";
        sbr = this.formatRecord(rec);
        return sbr;
    }

    private String formatRecord(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        String component = "";
        String adfDetails = "";
        String componentName = "";
        Map supplAttrs = null;
        if (record instanceof ODLLogRecord) {
            supplAttrs = ((ODLLogRecord)record).getSupplAttributes();
            if (supplAttrs != null) {
                if (supplAttrs.containsKey("ADF_MESSAGE_STATUS") && !((String)supplAttrs.get("ADF_MESSAGE_STATUS")).equals("end")) {
                    int compIndex;
                    if (supplAttrs.containsKey("ADF_MESSAGE_CONTEXT_DATA") && (compIndex = (componentName = ((String)supplAttrs.get("ADF_MESSAGE_CONTEXT_DATA")).toString()).indexOf("Component=")) != -1) {
                        if (componentName.indexOf("Component=") == 0) {
                            if (componentName.indexOf(";#;") < 0) {
                                component = this.getADFComponentNameCase1(componentName);
                                adfDetails = "";
                            } else {
                                component = this.getADFComponentNameCase2(componentName);
                                int delimiterIndex = componentName.indexOf(";#;");
                                if (delimiterIndex == componentName.lastIndexOf(";#;")) {
                                    adfDetails = componentName.substring(delimiterIndex + 3, componentName.length() - 1);
                                } else {
                                    Pattern pattern = Pattern.compile(";#;(.*?);#;");
                                    Matcher matcher = pattern.matcher(componentName);
                                    if (matcher.find()) {
                                        adfDetails = matcher.group(1);
                                    }
                                }
                            }
                        } else if (componentName.indexOf("Component=") > 0) {
                            component = componentName.matches(".*;#;Component=.*;#;.*") ? this.getADFComponentNameCase2(componentName) : this.getADFComponentNameCase1(componentName);
                            adfDetails = componentName.substring(0, componentName.indexOf(";#;"));
                        }
                    }
                    if (showTimeStamp) {
                        sb = this.appendLogMessageAttribute(sb, DateFormat.getTimeInstance(1).format(new Date(record.getMillis())).toString());
                    }
                    if (showMessageType) {
                        sb = this.appendLogMessageAttribute(sb, record.getLevel().toString());
                    }
                    if (component != "") {
                        sb = this.appendLogMessageAttribute(sb, component);
                    }
                    sb = this.appendLogMessageAttribute(sb, this.getMessageText(record));
                    if (adfDetails != "") {
                        sb = this.appendLogMessageAttribute(sb, adfDetails);
                    }
                    sb.append(lineSeparator);
                } else if (!supplAttrs.containsKey("ADF_MESSAGE_STATUS") || !((String)supplAttrs.get("ADF_MESSAGE_STATUS")).equals("end")) {
                    sb = this.formatNonSupplAttrLogRecord(record, sb);
                }
            } else {
                sb = this.formatNonSupplAttrLogRecord(record, sb);
            }
        } else {
            sb = this.formatNonSupplAttrLogRecord(record, sb);
        }
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    private StringBuffer formatNonSupplAttrLogRecord(LogRecord record, StringBuffer sbrlr) {
        String compName;
        if (showTimeStamp) {
            sbrlr = this.appendLogMessageAttribute(sbrlr, DateFormat.getTimeInstance(1).format(new Date(record.getMillis())).toString());
        }
        if (showMessageType) {
            sbrlr = this.appendLogMessageAttribute(sbrlr, record.getLevel().toString());
        }
        sbrlr = (compName = this.getADFComponentName(record.getSourceClassName())) != null && compName != "" ? this.appendLogMessageAttribute(sbrlr, compName) : this.appendLogMessageAttribute(sbrlr, record.getSourceClassName());
        sbrlr = this.appendLogMessageAttribute(sbrlr, this.getShortClassName(record.getSourceClassName()));
        sbrlr = this.appendLogMessageAttribute(sbrlr, record.getSourceMethodName());
        sbrlr = this.appendLogMessageAttribute(sbrlr, this.getMessageText(record));
        sbrlr.append(lineSeparator);
        return sbrlr;
    }

    public String formatDateTime(long timeStamp) {
        return DateFormat.getTimeInstance(1).format(new Date(timeStamp)).toString();
    }

    public StringBuffer appendLogMessageAttribute(StringBuffer buffer, String attribute) {
        return buffer.append("<").append(attribute).append("> ");
    }

    public String getADFComponentNameCase1(String contextMapString) {
        Pattern pattern = Pattern.compile("Component=(.*?)$");
        Matcher matcher = pattern.matcher(contextMapString);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public String getADFComponentNameCase2(String contextMapString) {
        Pattern pattern = Pattern.compile("Component=(.*?);#;");
        Matcher matcher = pattern.matcher(contextMapString);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public String getADFComponentName(String className) {
        String ADFComponent = "";
        if (className != null && className != "") {
            for (int i = 0; i < compKeys.length; ++i) {
                if (className.indexOf(compKeys[i].toString()) <= 0) continue;
                ADFComponent = comps.get(compKeys[i]);
                break;
            }
        }
        return ADFComponent;
    }

    private String getMessageText(LogRecord rec) {
        ODLFormatter frmt = new ODLFormatter();
        LogMessage msg = frmt.toLogMessage(rec);
        return msg.getMessageText();
    }

    private static String getLineSeparator() {
        String prop = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return String.valueOf(System.getProperty("line.separator"));
            }
        });
        return prop;
    }
}

