/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging.internal.diagnostic;

import java.io.PrintStream;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class ADFConsoleHandler
extends StreamHandler {
    private PrintStream output;

    public ADFConsoleHandler(PrintStream out, Formatter formatter) {
        super(out, formatter);
        this.output = out;
    }

    @Override
    public synchronized void publish(LogRecord record) {
        String msg;
        if (!this.isLoggable(record)) {
            return;
        }
        try {
            msg = this.getFormatter().format(record);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 5);
            return;
        }
        this.output.print(msg);
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        if (this.output == null) {
            return false;
        }
        return super.isLoggable(record);
    }

    @Override
    public synchronized void flush() {
    }

    @Override
    public synchronized void close() throws SecurityException {
        this.output = null;
    }
}

