/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.common.rc.util.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.adf.share.codesharing.audit.annotation.CodeSharingSafe;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.common.rc.util.CompositeIterator;
import oracle.adf.share.common.rc.util.MetadataRegistry;
import oracle.adf.share.common.rc.util.impl.URLUtil;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MetadataRegistryImpl
extends MetadataRegistry {
    protected static final Logger logger = Logger.getLogger(MetadataRegistryImpl.class.getName());
    private URL _baseURL = null;
    private Integer _mode = null;
    private Boolean _whitespace = null;
    @CodeSharingSafe(value="MutableStaticField")
    private static final DTDSkippingResolver dtdSkippingResolver = new DTDSkippingResolver();
    @CodeSharingSafe(value="MutableStaticField")
    private static EmptyNodeList EMPTY_NODE_LIST = new EmptyNodeList();
    private static final int DCX = 0;
    private static final int CPX = 2;
    private static final int JPX = 4;
    private static final int XCFG = 6;
    private static final String[] elementData = new String[]{".dcx", "DataControlRegistry", ".cpx", "DataBindingRegistry", ".jpx", "BusinessComponentProjectRegistry", ".xcfg", "BusinessComponentServiceRegistry", ".rpx", "DataBindingRegistry"};
    @CodeSharingSafe(value="MutableStaticField")
    private static final Map<String, String> defaultElementXref = MetadataRegistryImpl.createElementXref(elementData);
    @CodeSharingSafe(value="MutableStaticField")
    private static DocumentBuilderFactory builderFactory = null;

    @Override
    public void visitRegistryPaths(ClassLoader loader, String regNS, String regName, MetadataRegistry.PathVisitor visitor) throws IOException, SAXException, ParserConfigurationException, MalformedURLException {
        this.visitRegistryPaths(loader, new String[]{regNS}, new String[]{regName}, visitor);
    }

    @Override
    public void visitRegistryPaths(ClassLoader loader, String[] regNSs, String[] regNames, MetadataRegistry.PathVisitor visitor) throws IOException, SAXException, ParserConfigurationException, MalformedURLException {
        MetadataRegistry.PathVisitor2 visitor2;
        if (regNSs != null && regNSs.length > 0 && regNames.length != regNSs.length) {
            throw new IllegalArgumentException();
        }
        Enumeration<URL> adfmxmls = loader.getResources("META-INF/adfm.xml");
        if (!adfmxmls.hasMoreElements()) {
            return;
        }
        MetadataRegistry.PathVisitor2 pathVisitor2 = visitor2 = visitor instanceof MetadataRegistry.PathVisitor2 ? (MetadataRegistry.PathVisitor2)visitor : null;
        if (logger.isLoggable(Level.FINE) && visitor2 == null) {
            logger.fine(MessageFormat.format("{0} is using the deprecated PathVisitor", visitor.getClass().getName()));
        }
        HashSet<String> visited = new HashSet<String>();
        while (adfmxmls.hasMoreElements()) {
            String adfmStr;
            URL adfmXmlUrl = URLUtil.getURLForPath(adfmxmls.nextElement(), false);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(MessageFormat.format("Visiting {0}", adfmXmlUrl));
            }
            if (visited.contains(adfmStr = adfmXmlUrl.toString())) continue;
            visited.add(adfmStr);
            String adfmXmlBase = adfmStr.substring(0, adfmStr.length() - ADFMXML_SIG_LEN);
            Iterator<String> paths = this.getRegistryPaths(adfmXmlUrl, regNSs, regNames);
            while (paths.hasNext()) {
                String path = paths.next();
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(MessageFormat.format("Sub-visiting {0}", path));
                }
                if (visitor2 != null) {
                    if (visitor2.visit(this, null, new URL(adfmXmlBase + path), path, loader)) continue;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(MessageFormat.format("Stopped visiting {0} on {1}", visitor2.getClass().getName(), adfmXmlUrl));
                    }
                    return;
                }
                visitor.visit(this, new URL(adfmXmlBase + path), path);
            }
        }
    }

    @Override
    public Iterator<String> getAttributeIterator(URL xmlUrl, String elemNS, String elemName, String attrName) throws IOException, SAXException, ParserConfigurationException {
        return new IterateNodeListAttributes(this.getDomDocument(xmlUrl).getElementsByTagNameNS(elemNS, elemName), attrName);
    }

    @Override
    public Collection<Map<String, Object>> getAttributeMaps(URL xmlURL, String elemNS, String elemName) throws IOException, SAXException, ParserConfigurationException {
        boolean logging = logger.isLoggable(Level.FINER);
        StringBuilder debugBuf = new StringBuilder(logging ? 1024 : 1);
        if (elemNS == null) {
            elemNS = "http://xmlns.oracle.com/bc4j/configuration";
        }
        NodeList nl = this.getDomDocument(xmlURL).getElementsByTagNameNS(elemNS, elemName);
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>(nl.getLength());
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.hasAttributes()) {
                if (!logging) continue;
                debugBuf.append("No attributes found for element: " + n + "\n");
                continue;
            }
            NamedNodeMap nnm = n.getAttributes();
            LinkedHashMap<String, String> m = new LinkedHashMap<String, String>(nnm.getLength());
            for (int j = 0; j < nnm.getLength(); ++j) {
                Node nn = nnm.item(j);
                if (logging) {
                    debugBuf.append(n.getNodeName() + ": " + nn.getNodeName() + "=" + nn.getNodeValue() + "\n");
                }
                m.put(nn.getNodeName(), nn.getNodeValue());
            }
            ret.add(m);
        }
        if (logging) {
            logger.finer(debugBuf.toString());
        }
        return ret;
    }

    @Override
    public Iterator<String> getRegistryPaths(URL adfmXmlUrl, String registryNS, String registryName) throws IOException, SAXException, ParserConfigurationException {
        return this.getRegistryPaths(adfmXmlUrl, new String[]{registryNS}, new String[]{registryName});
    }

    @Override
    public Iterator<String> getRegistryPaths(URL adfmXmlUrl, String[] registryNSs, String[] registryNames) throws IOException, SAXException, ParserConfigurationException {
        Iterator[] components = new Iterator[registryNames.length];
        Document doc = this.getDomDocument(adfmXmlUrl);
        for (int i = 0; i < registryNames.length; ++i) {
            String registryNS = "http://xmlns.oracle.com/adfm/metainf";
            if (registryNSs != null && registryNSs[i] != null && registryNSs[i].length() > 0) {
                registryNS = registryNSs[i];
            }
            components[i] = new IterateNodeListAttributes(doc.getElementsByTagNameNS(registryNS, registryNames[i]), "path");
        }
        if (components.length == 1) {
            return components[0];
        }
        return new CompositeIterator<String>(components);
    }

    @Override
    public List<Map<String, Object>> getSubtreeList(Document xmldocument, URL xmlUrl, String elemNS, String elemName, String nvpChildName) throws ParserConfigurationException, SAXException, IOException {
        Document doc = xmldocument;
        if (doc == null) {
            doc = this.getDomDocument(xmlUrl);
        }
        if (elemNS == null || elemNS.length() == 0) {
            elemNS = "http://xmlns.oracle.com/bc4j";
        }
        NodeList nodeList = doc.getElementsByTagNameNS(elemNS, elemName);
        int len = nodeList.getLength();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(len);
        for (int i = 0; i < len; ++i) {
            LinkedHashMap map = new LinkedHashMap(6);
            LinkedHashMap dtMap = new LinkedHashMap(2);
            map.put(nvpChildName, dtMap);
            list.add(map);
            Node node = nodeList.item(i);
            this.fillNodeAttrMap(map, node);
            NodeList nvpList = this.getChildNodeList(node, elemNS, nvpChildName);
            this.fillNvpNodeAttrMap(dtMap, nvpList, "Name", "Value");
        }
        return list;
    }

    private NodeList getChildNodeList(Node node, String elemNS, String nvpChildName) {
        NodeList childList = node.getChildNodes();
        int len = childList.getLength();
        for (int i = 0; i < len; ++i) {
            Node item = childList.item(i);
            if (!nvpChildName.equals(item.getLocalName()) || !"*".equals(elemNS) && !elemNS.equals(item.getNamespaceURI())) continue;
            return item.getChildNodes();
        }
        return EMPTY_NODE_LIST;
    }

    private void fillNodeAttrMap(Map map, Node node) {
        NamedNodeMap nodeMap = node.getAttributes();
        int alen = nodeMap.getLength();
        for (int a = 0; a < alen; ++a) {
            Node anode = nodeMap.item(a);
            String name = anode.getNodeName();
            String valu = anode.getNodeValue();
            if (name == null || valu == null) continue;
            map.put(name, valu);
        }
    }

    private void fillNvpNodeAttrMap(Map map, NodeList list, String nameName, String valueName) {
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = list.item(i);
            NamedNodeMap nodeMap = node.getAttributes();
            String name = null;
            String valu = null;
            int alen = nodeMap == null ? 0 : nodeMap.getLength();
            for (int a = 0; a < alen; ++a) {
                Node anode = nodeMap.item(a);
                String aname = anode.getNodeName();
                String avalu = anode.getNodeValue();
                if (name == null && aname.equalsIgnoreCase(nameName)) {
                    name = avalu;
                    continue;
                }
                if (valu != null || !aname.equalsIgnoreCase(valueName)) continue;
                valu = avalu;
            }
            if (name == null || valu == null) continue;
            map.put(name, valu);
        }
    }

    private static final Map<String, String> createElementXref(String[] data) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(data.length / 2);
        for (int i = 0; i < data.length; i += 2) {
            map.put(data[i], data[i + 1]);
        }
        return map;
    }

    @Override
    public boolean updateElementsInMetadataRegistry(Collection<String> relativePaths, Map<String, String> elementXref, URL adfmXmlUrl) throws IOException, SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException {
        return this.updateElementsInMetadataRegistryEx(relativePaths, null, elementXref, adfmXmlUrl, null);
    }

    @Override
    public boolean updateElementsInMetadataRegistryEx(Collection<String> relativePaths, Collection<String> removalPaths, Map<String, String> elementXref, URL adfmXmlUrl, int[] remaining) throws IOException, SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException {
        Context ctx = new Context(adfmXmlUrl);
        this.getDocumentForWriting(ctx);
        if (removalPaths != null && removalPaths.size() > 0) {
            HashSet<String> removes = new HashSet<String>(removalPaths);
            NodeList list = ctx.doc.getDocumentElement() != null ? ctx.doc.getDocumentElement().getElementsByTagNameNS("*", "*") : ctx.doc.getElementsByTagNameNS("*", "*");
            for (int i = 0; i < list.getLength() && removes.size() > 0; ++i) {
                boolean removed;
                String elemPath = ((Element)list.item(i)).getAttributeNS(null, "path");
                if (elemPath == null || elemPath.length() <= 0 || !(removed = removes.remove(elemPath))) continue;
                list.item(i).getParentNode().removeChild(list.item(i));
                ctx.dirty = true;
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine(elemPath + " removed.");
            }
        }
        if (elementXref == null) {
            elementXref = defaultElementXref;
        } else {
            elementXref = new LinkedHashMap<String, String>(elementXref);
            elementXref.putAll(defaultElementXref);
        }
        for (String relPath : relativePaths) {
            String ext;
            if (!this.updateRegistryElement(relPath, null, elementXref.get(ext = relPath.substring(relPath.lastIndexOf(46))), ctx.doc)) continue;
            ctx.dirty = true;
        }
        if (ctx.dirty) {
            this.saveDomDocument(ctx);
        }
        if (remaining != null && remaining.length > 0) {
            remaining[0] = ctx.doc.getDocumentElement().getElementsByTagNameNS("*", "*").getLength();
        }
        return ctx.dirty;
    }

    @Override
    public boolean updateRegistryElement(String relativePath, String elementNS, String elementName, Document doc) {
        boolean dirty = false;
        if (elementNS == null) {
            elementNS = "http://xmlns.oracle.com/adfm/metainf";
        }
        if (elementName == null) {
            throw new IllegalArgumentException(relativePath);
        }
        Element rootElement = doc.getDocumentElement();
        NodeList list = doc.getElementsByTagNameNS(elementNS, elementName);
        if (list == null || list.getLength() == 0) {
            if (rootElement == null) {
                rootElement = doc.createElementNS("http://xmlns.oracle.com/adfm/metainf", "MetadataDirectory");
                rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://xmlns.oracle.com/adfm/metainf");
                rootElement.setAttributeNS(null, "version", "11.1.1.0.0");
                doc.setXmlVersion("1.0");
                doc.appendChild(rootElement);
            }
            Element registry = doc.createElementNS(elementNS, elementName);
            rootElement.appendChild(registry);
            registry.setAttributeNS(null, "path", relativePath);
            dirty = true;
        } else {
            boolean found = false;
            for (int i = 0; i < list.getLength(); ++i) {
                if (!relativePath.equals(((Element)list.item(i)).getAttributeNS(null, "path"))) continue;
                found = true;
                break;
            }
            if (!found) {
                Element registry = doc.createElementNS(elementNS, elementName);
                registry.setAttributeNS(null, "path", relativePath);
                rootElement.appendChild(registry);
                dirty = true;
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(MessageFormat.format("Document {0}dirty after update of {1} with {2}", !dirty ? "not " : "", elementName, relativePath));
        }
        return dirty;
    }

    private static DocumentBuilderFactory getBuilderFactory() {
        if (builderFactory == null) {
            builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            builderFactory.setIgnoringComments(true);
            builderFactory.setIgnoringElementContentWhitespace(true);
        }
        return builderFactory;
    }

    @Override
    public URL setBaseURL(URL newBaseURL) {
        URL ret = this._baseURL;
        this._baseURL = newBaseURL;
        return ret;
    }

    @Override
    public void setValidationMode(Integer mode) {
        this._mode = mode;
    }

    @Override
    public void setPreserveWhitespace(Boolean preserve) {
        this._whitespace = preserve;
    }

    protected InputStream openStream(URL url) throws IOException {
        try {
            if ("file".equalsIgnoreCase(url.getProtocol())) {
                url = this.preprocessURL(url);
                File f = new File(url.getPath());
                return new BufferedInputStream(new FileInputStream(f));
            }
            return url.openStream();
        }
        catch (IOException e) {
            logger.fine(MessageFormat.format("{0}", url));
            throw e;
        }
    }

    @Override
    public Document getDomDocument(URL url) throws ParserConfigurationException, SAXException, IOException {
        InputStream strm = null;
        try {
            strm = this.openStream(url);
            if (!(strm instanceof BufferedInputStream) && !(strm instanceof ByteArrayInputStream)) {
                strm = new BufferedInputStream(strm);
            }
            DOMParser parser = new DOMParser();
            parser.setEntityResolver((EntityResolver)dtdSkippingResolver);
            if (this._mode != null) {
                parser.setValidationMode(this._mode.intValue());
            } else {
                parser.setValidationMode(0);
            }
            if (this._baseURL != null) {
                parser.setBaseURL(this._baseURL);
            }
            if (MetadataRegistryImpl.isDebugON()) {
                parser.setDebugMode(true);
                parser.showWarnings(true);
            }
            if (this._whitespace != null) {
                parser.setPreserveWhitespace(this._whitespace.booleanValue());
            }
            parser.parse(strm);
            XMLDocument xMLDocument = parser.getDocument();
            return xMLDocument;
        }
        catch (IOException e) {
            logger.fine(MessageFormat.format("{0}", url));
            throw e;
        }
        finally {
            if (strm != null) {
                try {
                    strm.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private URL getCallersBaseURL() {
        try {
            String myPackage = this.getClass().getName();
            myPackage = myPackage.substring(0, myPackage.lastIndexOf(46));
            String callersName = null;
            StackTraceElement[] elems = new Throwable().getStackTrace();
            for (int i = 0; i < elems.length; ++i) {
                String className = elems[i].getClassName();
                if (className == null || className.startsWith(myPackage)) continue;
                callersName = elems[i].getClassName();
                return ClassUtils.forName(callersName, MetadataRegistry.class).getResource("");
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception caught", e);
        }
        return null;
    }

    protected Document newDomDocument(URL url) throws ParserConfigurationException, IOException {
        DocumentBuilder builder = MetadataRegistryImpl.getBuilderFactory().newDocumentBuilder();
        Document doc = builder.newDocument();
        doc.setDocumentURI(this.preprocessURL(url).toString());
        return doc;
    }

    @Override
    public void saveDocumentTo(Document doc, URL saveTo) throws TransformerConfigurationException, TransformerException, IOException {
        Context ctx = new Context(saveTo);
        ctx.doc = doc;
        this.saveDomDocument(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveDomDocument(Context ctx) throws TransformerConfigurationException, TransformerException, IOException {
        TransformerFactory xformFactory = TransformerFactory.newInstance();
        Transformer xform = xformFactory.newTransformer();
        xform.setOutputProperty("indent", "yes");
        xform.setOutputProperty("omit-xml-declaration", "no");
        DOMSource input = new DOMSource(ctx.doc);
        OutputStream os = this.getOutputStream(ctx);
        if (!(os instanceof BufferedOutputStream) && !(os instanceof ByteArrayOutputStream)) {
            os = new BufferedOutputStream(os);
        }
        try {
            StreamResult output = new StreamResult(os);
            xform.transform(input, output);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected URL preprocessURL(URL url) throws IOException {
        if ("file".equalsIgnoreCase(url.getProtocol()) && url.getPath().indexOf(37) != -1) {
            url = new URL(URLDecoder.decode(url.toString(), "UTF8"));
        }
        return url;
    }

    protected OutputStream getOutputStream(Context ctx) throws IOException {
        try {
            if ("file".equalsIgnoreCase(ctx.url.getProtocol())) {
                URL url = this.preprocessURL(ctx.url);
                File f = new File(url.getPath());
                f.getParentFile().mkdirs();
                return new FileOutputStream(f);
            }
            return ctx.url.openConnection().getOutputStream();
        }
        catch (IOException e) {
            logger.log(Level.FINE, String.valueOf(ctx.url), e);
            throw e;
        }
    }

    protected void getDocumentForWriting(Context ctx) throws IOException, SAXException, ParserConfigurationException {
        try {
            ctx.doc = this.getDomDocument(ctx.url);
        }
        catch (IOException e) {
            ctx.dirty = true;
            ctx.doc = this.newDomDocument(ctx.url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public URL[] listFiles(URL url) {
        if (url == null) {
            return null;
        }
        try {
            String urlStr = url.toString();
            if (!urlStr.endsWith("/")) {
                urlStr = urlStr + "/";
            }
            if (urlStr.startsWith("file:")) {
                url = this.preprocessURL(url);
                urlStr = url.toString();
                File file = new File(url.getPath());
                String[] fileNames = file.list();
                if (fileNames == null) {
                    return null;
                }
                URL[] urls = new URL[fileNames.length];
                int i = 0;
                while (i < urls.length) {
                    urls[i] = new URL(urlStr + fileNames[i]);
                    ++i;
                }
                return urls;
            }
            if (!urlStr.startsWith("jar:")) {
                logger.info(MessageFormat.format("Unable to handle URL: {0}", urlStr));
                return null;
            }
            int sep = urlStr.lastIndexOf("!/");
            if (sep < 0) {
                logger.info(MessageFormat.format("Invalid URL: {0}", urlStr));
                return null;
            }
            String jarName = urlStr.substring(4, sep);
            String dirName = urlStr.substring(sep + 2);
            int dirNameLen = dirName.length();
            URL jarNameURL = new URL(jarName);
            if (logger.isLoggable(Level.FINE) && !"file".equalsIgnoreCase(jarNameURL.getProtocol())) {
                logger.fine("Unexpected protocol in: " + jarNameURL);
            }
            File jarNameFile = new File(jarNameURL.getPath());
            JarFile jar = new JarFile(jarNameFile);
            try {
                LinkedList<URL> urls = new LinkedList<URL>();
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String ename = entry.getName();
                    if (!ename.startsWith(dirName) || ename.indexOf(47, dirNameLen) != -1) continue;
                    urls.add(new URL(urlStr + ename.substring(dirNameLen)));
                }
                URL[] uRLArray = urls.toArray(new URL[0]);
                return uRLArray;
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (Exception exception) {}
                    jar = null;
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception caught", e);
        }
        return null;
    }

    private static final boolean isDebugON() {
        try {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return Boolean.getBoolean("adflibrc.debug");
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return false;
        }
    }

    protected static class Context {
        URL url;
        Document doc = null;
        boolean dirty = false;

        public Context(URL adfmXmlUrl) {
            this.url = adfmXmlUrl;
        }
    }

    protected static class IterateNodeListAttributes
    implements Iterator<String> {
        private final NodeList list;
        private final String attrName;
        private final int listLen;
        private int i = 0;
        private String next = "";

        public IterateNodeListAttributes(NodeList list, String attrName) {
            this.list = list;
            this.listLen = list != null ? list.getLength() : 0;
            this.attrName = attrName;
            this.setNext();
        }

        private void setNext() {
            if (this.i == this.listLen) {
                this.next = null;
            } else {
                while (this.i < this.listLen) {
                    this.next = ((Element)this.list.item(this.i)).getAttributeNS(null, this.attrName);
                    ++this.i;
                    if (this.next.length() == 0) continue;
                }
                if (this.next.length() == 0) {
                    this.next = null;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public String next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            String ret = this.next;
            this.setNext();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class EmptyNodeList
    implements NodeList {
        private EmptyNodeList() {
        }

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        public Node item(int index) {
            return null;
        }
    }

    public static class DTDSkippingResolver
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if (systemId != null && systemId.endsWith(".dtd")) {
                return new InputSource(new StringReader("<?xml version=\"1.0\" encoding=\"windows-1252\" ?>"));
            }
            return null;
        }
    }
}

