/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.NotTreeFilter;
import org.eclipse.jgit.treewalk.filter.OrTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.netbeans.libs.git.GitConflictDescriptor;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.libs.git.progress.StatusListener;

public class StatusCommand
extends GitCommand {
    private final LinkedHashMap<File, GitStatus> statuses;
    private final File[] roots;
    private final ProgressMonitor monitor;
    private final StatusListener listener;
    private final String revision;
    private static final Logger LOG = Logger.getLogger(StatusCommand.class.getName());
    private static final Set<File> logged = new HashSet<File>();

    public StatusCommand(Repository repository, String revision, File[] roots, GitClassFactory gitFactory, ProgressMonitor monitor, StatusListener listener) {
        super(repository, gitFactory, monitor);
        this.roots = roots;
        this.monitor = monitor;
        this.listener = listener;
        this.revision = revision;
        this.statuses = new LinkedHashMap();
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git ");
        if ("HEAD".equals(this.revision)) {
            sb.append("status");
        } else {
            sb.append("diff --raw");
        }
        for (File root : this.roots) {
            sb.append(" ").append(root.getAbsolutePath());
        }
        return sb.toString();
    }

    @Override
    protected boolean prepareCommand() throws GitException {
        return this.getRepository().getDirectory().exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        try {
            DirCache cache = repository.readDirCache();
            ObjectReader od = repository.newObjectReader();
            try {
                String workTreePath = repository.getWorkTree().getAbsolutePath();
                Collection<PathFilter> pathFilters = Utils.getPathFilters(repository.getWorkTree(), this.roots);
                ObjectId commitId = Utils.parseObjectId(repository, this.revision);
                Map<String, DiffEntry> renames = this.detectRenames(repository, cache, commitId);
                TreeWalk treeWalk = new TreeWalk(repository);
                if (!pathFilters.isEmpty()) {
                    treeWalk.setFilter(PathFilterGroup.create(pathFilters));
                }
                treeWalk.setRecursive(false);
                treeWalk.reset();
                if (commitId != null) {
                    treeWalk.addTree((AnyObjectId)new RevWalk(repository).parseTree((AnyObjectId)commitId));
                } else {
                    treeWalk.addTree((AbstractTreeIterator)new EmptyTreeIterator());
                }
                treeWalk.addTree((AbstractTreeIterator)new DirCacheIterator(cache));
                treeWalk.addTree((AbstractTreeIterator)new FileTreeIterator(repository));
                boolean T_COMMIT = false;
                boolean T_INDEX = true;
                int T_WORKSPACE = 2;
                String lastPath = null;
                GitStatus[] conflicts = new GitStatus[3];
                LinkedList<GitStatus> symLinks = new LinkedList<GitStatus>();
                boolean checkExecutable = Utils.checkExecutable(repository);
                while (treeWalk.next() && !this.monitor.isCanceled()) {
                    GitStatus.Status statusIndexWC;
                    GitStatus.Status statusHeadWC;
                    boolean isFolder;
                    DirCacheEntry indexEntry;
                    GitStatus.Status statusHeadIndex;
                    boolean tracked;
                    int mHead;
                    File file;
                    boolean symlink;
                    String path;
                    block22: {
                        path = treeWalk.getPathString();
                        symlink = false;
                        file = new File(workTreePath + File.separator + path);
                        if (path.equals(lastPath)) {
                            symlink = this.isKnownSymlink(symLinks, path);
                        } else {
                            block21: {
                                try {
                                    symlink = Files.isSymbolicLink(file.toPath());
                                }
                                catch (InvalidPathException ex) {
                                    if (!logged.add(file)) break block21;
                                    LOG.log(Level.FINE, null, ex);
                                }
                            }
                            this.handleConflict(conflicts, workTreePath);
                            this.handleSymlink(symLinks, workTreePath);
                        }
                        lastPath = path;
                        Logger.getLogger(StatusCommand.class.getName()).log(Level.FINE, "Inspecting file {0} ---- {1}", new Object[]{path, file.getAbsolutePath()});
                        mHead = treeWalk.getRawMode(0);
                        int mIndex = treeWalk.getRawMode(1);
                        int mWorking = treeWalk.getRawMode(2);
                        boolean bl = tracked = mWorking != FileMode.TREE.getBits() && (mHead != FileMode.MISSING.getBits() || mIndex != FileMode.MISSING.getBits());
                        statusHeadIndex = mHead == FileMode.MISSING.getBits() && mIndex != FileMode.MISSING.getBits() ? GitStatus.Status.STATUS_ADDED : (mIndex == FileMode.MISSING.getBits() && mHead != FileMode.MISSING.getBits() ? GitStatus.Status.STATUS_REMOVED : (mHead != mIndex || mIndex != FileMode.TREE.getBits() && !treeWalk.idEqual(0, 1) ? GitStatus.Status.STATUS_MODIFIED : GitStatus.Status.STATUS_NORMAL));
                        FileTreeIterator fti = (FileTreeIterator)treeWalk.getTree(2, FileTreeIterator.class);
                        DirCacheIterator indexIterator = (DirCacheIterator)treeWalk.getTree(1, DirCacheIterator.class);
                        indexEntry = indexIterator != null ? indexIterator.getDirCacheEntry() : null;
                        isFolder = false;
                        if (!symlink && treeWalk.isSubtree()) {
                            if (mWorking == FileMode.TREE.getBits() && fti.isEntryIgnored()) {
                                Collection<TreeFilter> subTreeFilters = StatusCommand.getSubtreeFilters(pathFilters, path);
                                if (!subTreeFilters.isEmpty()) {
                                    treeWalk.setFilter(AndTreeFilter.create((TreeFilter)treeWalk.getFilter(), (TreeFilter)OrTreeFilter.create((TreeFilter)NotTreeFilter.create((TreeFilter)PathFilter.create((String)path)), (TreeFilter)(subTreeFilters.size() > 1 ? OrTreeFilter.create(subTreeFilters) : subTreeFilters.iterator().next()))));
                                    treeWalk.enterSubtree();
                                }
                                if (!StatusCommand.includes(pathFilters, treeWalk)) continue;
                                statusIndexWC = statusHeadWC = GitStatus.Status.STATUS_IGNORED;
                                isFolder = true;
                                break block22;
                            } else {
                                treeWalk.enterSubtree();
                                continue;
                            }
                        }
                        if (mWorking == 57344 || mHead == 57344 || mIndex == 57344) {
                            isFolder = file.isDirectory();
                        }
                        statusIndexWC = mWorking == FileMode.MISSING.getBits() && mIndex != FileMode.MISSING.getBits() ? GitStatus.Status.STATUS_REMOVED : (mIndex == FileMode.MISSING.getBits() && mWorking != FileMode.MISSING.getBits() ? (fti.isEntryIgnored() ? GitStatus.Status.STATUS_IGNORED : GitStatus.Status.STATUS_ADDED) : (!this.isExistingSymlink(mIndex, mWorking) && (this.differ(mIndex, mWorking, checkExecutable) || mWorking != 0 && mWorking != FileMode.TREE.getBits() && fti.isModified(indexEntry, true, od)) || GitStatus.Status.STATUS_MODIFIED == this.getGitlinkStatus(mWorking, treeWalk.getObjectId(2), mIndex, treeWalk.getObjectId(1)) ? GitStatus.Status.STATUS_MODIFIED : GitStatus.Status.STATUS_NORMAL));
                        statusHeadWC = mWorking == FileMode.MISSING.getBits() && mHead != FileMode.MISSING.getBits() ? GitStatus.Status.STATUS_REMOVED : (mHead == FileMode.MISSING.getBits() && mWorking != FileMode.MISSING.getBits() ? GitStatus.Status.STATUS_ADDED : (!this.isExistingSymlink(mIndex, mWorking) && (this.differ(mHead, mWorking, checkExecutable) || mWorking != 0 && mWorking != FileMode.TREE.getBits() && (indexEntry == null || !indexEntry.isAssumeValid()) && (statusIndexWC != GitStatus.Status.STATUS_NORMAL || statusHeadIndex != GitStatus.Status.STATUS_NORMAL) && !treeWalk.getObjectId(0).equals((AnyObjectId)fti.getEntryObjectId())) || GitStatus.Status.STATUS_MODIFIED == this.getGitlinkStatus(mHead, treeWalk.getObjectId(2), mHead, treeWalk.getObjectId(0)) ? GitStatus.Status.STATUS_MODIFIED : GitStatus.Status.STATUS_NORMAL));
                    }
                    int stage = indexEntry == null ? 0 : indexEntry.getStage();
                    long indexTimestamp = indexEntry == null ? -1L : indexEntry.getLastModified();
                    GitStatus status = this.getClassFactory().createStatus(tracked, path, workTreePath, file, statusHeadIndex, statusIndexWC, statusHeadWC, null, isFolder, renames.get(path), indexTimestamp);
                    if (stage == 0) {
                        if (this.isSymlinkFolder(mHead, symlink)) {
                            symLinks.add(status);
                            continue;
                        }
                        this.addStatus(file, status);
                        continue;
                    }
                    conflicts[stage - 1] = status;
                }
                this.handleConflict(conflicts, workTreePath);
                this.handleSymlink(symLinks, workTreePath);
                return;
            }
            finally {
                od.release();
                cache.unlock();
            }
        }
        catch (CorruptObjectException ex) {
            throw new GitException(ex);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }

    public Map<File, GitStatus> getStatuses() {
        return this.statuses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, DiffEntry> detectRenames(Repository repository, DirCache cache, ObjectId commitId) {
        List entries;
        TreeWalk treeWalk = new TreeWalk(repository);
        try {
            treeWalk.setRecursive(true);
            treeWalk.reset();
            if (commitId != null) {
                treeWalk.addTree((AnyObjectId)new RevWalk(repository).parseTree((AnyObjectId)commitId));
            } else {
                treeWalk.addTree((AbstractTreeIterator)new EmptyTreeIterator());
            }
            treeWalk.addTree((AbstractTreeIterator)new DirCacheIterator(cache));
            treeWalk.setFilter(TreeFilter.ANY_DIFF);
            entries = DiffEntry.scan((TreeWalk)treeWalk);
            RenameDetector d = new RenameDetector(repository);
            d.addAll((Collection)entries);
            entries = d.compute();
        }
        catch (IOException ex) {
            entries = Collections.emptyList();
        }
        finally {
            treeWalk.release();
        }
        HashMap<String, DiffEntry> renames = new HashMap<String, DiffEntry>();
        for (DiffEntry e : entries) {
            if (!e.getChangeType().equals((Object)DiffEntry.ChangeType.COPY) && !e.getChangeType().equals((Object)DiffEntry.ChangeType.RENAME)) continue;
            renames.put(e.getNewPath(), e);
        }
        return renames;
    }

    protected final void handleConflict(GitStatus[] conflicts, String workTreePath) {
        if (conflicts[0] != null || conflicts[1] != null || conflicts[2] != null) {
            GitStatus status;
            GitConflictDescriptor.Type type;
            if (conflicts[1] == null && conflicts[2] == null) {
                type = GitConflictDescriptor.Type.BOTH_DELETED;
                status = conflicts[0];
            } else if (conflicts[1] == null && conflicts[2] != null) {
                type = GitConflictDescriptor.Type.DELETED_BY_US;
                status = conflicts[2];
            } else if (conflicts[1] != null && conflicts[2] == null) {
                type = GitConflictDescriptor.Type.DELETED_BY_THEM;
                status = conflicts[1];
            } else if (conflicts[0] == null) {
                type = GitConflictDescriptor.Type.BOTH_ADDED;
                status = conflicts[1];
            } else {
                type = GitConflictDescriptor.Type.BOTH_MODIFIED;
                status = conflicts[1];
            }
            GitConflictDescriptor desc = this.getClassFactory().createConflictDescriptor(type);
            status = this.getClassFactory().createStatus(true, status.getRelativePath(), workTreePath, status.getFile(), GitStatus.Status.STATUS_NORMAL, GitStatus.Status.STATUS_NORMAL, GitStatus.Status.STATUS_NORMAL, desc, status.isFolder(), null, status.getIndexEntryModificationDate());
            this.addStatus(status.getFile(), status);
        }
        Arrays.fill(conflicts, null);
    }

    protected final void addStatus(File file, GitStatus status) {
        GitStatus presentStatus = this.statuses.get(file);
        if (presentStatus == null || !presentStatus.isRenamed()) {
            this.statuses.put(file, status);
        }
        this.listener.notifyStatus(status);
    }

    public static boolean includes(Collection<PathFilter> filters, TreeWalk treeWalk) {
        boolean retval = filters.isEmpty();
        for (PathFilter filter : filters) {
            if (!filter.include(treeWalk) || treeWalk.getPathString().length() < filter.getPath().length()) continue;
            retval = true;
            break;
        }
        return retval;
    }

    private static Collection<TreeFilter> getSubtreeFilters(Collection<PathFilter> filters, String path) {
        LinkedList<TreeFilter> subtreeFilters = new LinkedList<TreeFilter>();
        for (PathFilter filter : filters) {
            if (!filter.getPath().startsWith(path + "/")) continue;
            subtreeFilters.add((TreeFilter)filter);
        }
        return subtreeFilters;
    }

    private boolean differ(int fileMode1, int fileModeWorking, boolean checkFileMode) {
        boolean differ;
        if (this.isExistingSymlink(fileMode1, fileModeWorking)) {
            differ = false;
        } else {
            int difference = fileMode1 ^ fileModeWorking;
            differ = checkFileMode ? difference != 0 : (difference & 0xFFFFFFB6) != 0;
        }
        return differ;
    }

    private boolean isExistingSymlink(int fileMode1, int fileModeWorking) {
        return (fileModeWorking & 0x8000) == 32768 && (fileMode1 & 0xA000) == 40960;
    }

    private boolean isKnownSymlink(List<GitStatus> symLinks, String path) {
        return !symLinks.isEmpty() && path.equals(symLinks.get(0).getRelativePath());
    }

    private boolean isSymlinkFolder(int mHead, boolean isSymlink) {
        return isSymlink || (mHead & 0xA000) == 40960;
    }

    private void handleSymlink(List<GitStatus> symLinks, String workTreePath) {
        if (!symLinks.isEmpty()) {
            GitStatus.Status statusHeadWC;
            GitStatus.Status statusHeadIndex;
            GitStatus.Status statusIndexWC;
            GitStatus status = symLinks.get(0);
            if (symLinks.size() == 1) {
                statusIndexWC = status.getStatusIndexWC();
                if (status.isTracked()) {
                    statusHeadIndex = status.getStatusHeadIndex();
                    statusHeadWC = status.getStatusHeadWC();
                } else {
                    statusHeadIndex = GitStatus.Status.STATUS_NORMAL;
                    statusHeadWC = GitStatus.Status.STATUS_ADDED;
                }
            } else {
                statusHeadIndex = status.getStatusHeadIndex();
                switch (statusHeadIndex) {
                    case STATUS_ADDED: {
                        statusIndexWC = GitStatus.Status.STATUS_NORMAL;
                        statusHeadWC = GitStatus.Status.STATUS_ADDED;
                        break;
                    }
                    case STATUS_REMOVED: {
                        statusIndexWC = GitStatus.Status.STATUS_ADDED;
                        statusHeadWC = GitStatus.Status.STATUS_NORMAL;
                        break;
                    }
                    default: {
                        statusIndexWC = GitStatus.Status.STATUS_NORMAL;
                        statusHeadWC = GitStatus.Status.STATUS_NORMAL;
                    }
                }
            }
            status = this.getClassFactory().createStatus(status.isTracked(), status.getRelativePath(), workTreePath, status.getFile(), statusHeadIndex, statusIndexWC, statusHeadWC, null, status.isFolder(), null, status.getIndexEntryModificationDate());
            this.addStatus(status.getFile(), status);
            symLinks.clear();
        }
    }

    private GitStatus.Status getGitlinkStatus(int mode1, ObjectId id1, int mode2, ObjectId id2) {
        if (mode1 == 57344 || mode2 == 57344) {
            if (mode1 == 0) {
                return GitStatus.Status.STATUS_REMOVED;
            }
            if (mode2 == 0) {
                return GitStatus.Status.STATUS_ADDED;
            }
            if (!id1.equals((AnyObjectId)id2)) {
                return GitStatus.Status.STATUS_MODIFIED;
            }
        }
        return GitStatus.Status.STATUS_NORMAL;
    }
}

