/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git;

import java.net.URISyntaxException;
import org.eclipse.jgit.transport.URIish;

public final class GitURI {
    private URIish uri;

    private GitURI() {
    }

    private GitURI create(URIish uri) {
        GitURI u = new GitURI();
        u.uri = uri;
        return u;
    }

    public GitURI(String uriString) throws URISyntaxException {
        try {
            this.uri = new URIish(uriString);
            String scheme = this.uri.getScheme();
            if (scheme != null && !scheme.startsWith("file:") && this.uri.getHost() == null && !uriString.endsWith("/")) {
                this.uri = new URIish(uriString + "/");
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new URISyntaxException(uriString, "Invalid escape sequence");
        }
    }

    public String toPrivateString() {
        return this.uri.toPrivateString();
    }

    public GitURI setUser(String user) {
        return this.create(this.uri.setUser(user));
    }

    public GitURI setScheme(String scheme) {
        return this.create(this.uri.setScheme(scheme));
    }

    public GitURI setPort(int port) {
        return this.create(this.uri.setPort(port));
    }

    public GitURI setPath(String path) {
        return this.create(this.uri.setPath(path));
    }

    public GitURI setPass(String password) {
        return this.create(this.uri.setPass(password));
    }

    public GitURI setHost(String host) {
        return this.create(this.uri.setHost(host));
    }

    public boolean isRemote() {
        return this.uri.isRemote();
    }

    public String getUser() {
        return this.uri.getUser();
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public int getPort() {
        return this.uri.getPort();
    }

    public String getPath() {
        return this.uri.getPath();
    }

    public String getPass() {
        return this.uri.getPass();
    }

    public String getHost() {
        return this.uri.getHost();
    }

    public String toString() {
        return this.uri.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof GitURI) {
            return this.uri.equals((Object)((GitURI)o).uri);
        }
        return false;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }
}

