/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.extension;

import javax.ide.extension.Extension;
import oracle.ide.ExtensionRegistry;
import oracle.ide.osgi.Platform;
import oracle.ide.osgi.extension.BundleRegistry;
import oracle.ide.osgi.extension.internal.ClassLoaderProxy;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.ExportedPackage;

public class ExtensionCommandProvider
implements CommandProvider {
    private StringBuffer appendLoad(StringBuffer buf) {
        return buf.append("\tload - loads an Oracle extension. Parameters: <extension id> \n");
    }

    private StringBuffer appendCLoad(StringBuffer buf) {
        return buf.append("\tcload - classloads a class. Parameters: <fully qualifed class name> <extension/bundle id> \n");
    }

    private StringBuffer appendPkg(StringBuffer buf) {
        return buf.append("\tpkg - list all bundles that export a given package. Parameters: <fully qualified package name> \n");
    }

    public String getHelp() {
        StringBuffer buffer = new StringBuffer();
        this.appendLoad(buffer);
        this.appendCLoad(buffer);
        this.appendPkg(buffer);
        return buffer.toString();
    }

    private Extension findExtension(String extId) {
        return ExtensionRegistry.getExtensionRegistry().findExtension(extId);
    }

    public void _load(CommandInterpreter ci) {
        String extid = ci.nextArgument();
        if (extid == null) {
            ci.println((Object)("Usage: " + this.appendLoad(new StringBuffer()).toString()));
            return;
        }
        Extension extension = this.findExtension(extid);
        if (extension == null) {
            ci.println((Object)(extid + " is not a valid extension id "));
            return;
        }
        ExtensionRegistry.getExtensionRegistry().fullyLoadExtension(extension);
        ci.println((Object)("Extension " + extid + " is " + (ExtensionRegistry.getExtensionRegistry().isFullyLoaded(extid) ? "" : "not ") + "fully loaded"));
    }

    public void _cload(CommandInterpreter ci) {
        String classid = ci.nextArgument();
        String extid = ci.nextArgument();
        if (classid == null || extid == null) {
            ci.println((Object)("Usage: " + this.appendCLoad(new StringBuffer()).toString()));
            return;
        }
        Extension extension = this.findExtension(extid);
        if (extension == null) {
            BundleRegistry bundleRegistry = Platform.getBundleRegistry();
            Bundle bundle = bundleRegistry.findBundle(extid);
            if (bundle == null) {
                ci.println((Object)("Bundle " + extid + " was not a known OSGi bundle"));
            } else {
                try {
                    Class clazz = bundle.loadClass(classid);
                    ci.println((Object)(clazz + " classloaded by classloader of " + extid));
                }
                catch (ClassNotFoundException e) {
                    ci.println((Object)("Failed to load class " + classid + " using the classloader of " + extid + " -> " + e.getMessage()));
                    ci.printStackTrace((Throwable)e);
                }
            }
            return;
        }
        ClassLoader classLoader = ClassLoaderProxy.findOrCreateLoader(extid);
        try {
            Class<?> clazz = Class.forName(classid, true, classLoader);
            ci.println((Object)(clazz.getName() + " classloaded by classloader of " + extid));
        }
        catch (ClassNotFoundException e) {
            ci.printStackTrace((Throwable)e);
        }
    }

    public void _pkg(CommandInterpreter ci) {
        String packageFQN = ci.nextArgument();
        if (packageFQN == null) {
            ci.println((Object)"Usage: pkg <package id>");
            return;
        }
        ExportedPackage[] exportedPackages = Platform.getPackageAdmin().getExportedPackages(packageFQN);
        if (exportedPackages != null) {
            for (ExportedPackage expPackage : exportedPackages) {
                Bundle bundle = expPackage.getExportingBundle();
                ci.println((Object)(bundle.getSymbolicName() + " " + bundle.getVersion()));
            }
        }
    }
}

