/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.wizzards.datapump.imp;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.imp.SchemaTable;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.imp.SchemaTableComparitor;
import oracle.dbtools.raptor.images.BaseRaptorImages;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.UiResources;

public class ShuttleObjectPanel
extends JPanel
implements ActionListener,
LayoutControl {
    private static final long serialVersionUID = 1L;
    private JScrollPane sourceScrollPane1 = new JScrollPane();
    private JScrollPane selectedScrollPane1 = new JScrollPane();
    private JButton addOne = new JButton();
    private JButton remOne = new JButton();
    private JButton addAll = new JButton();
    private JButton remAll = new JButton();
    private JList _sourceList;
    private JList _selectedList;
    private List<SchemaTable> added = new ArrayList<SchemaTable>();
    private List<SchemaTable> removed = new ArrayList<SchemaTable>();

    public ShuttleObjectPanel(List<SchemaTable> list, List<SchemaTable> list2) {
        this._sourceList = new JList(new DefaultListModel());
        if (list != null) {
            for (SchemaTable schemaTable : list) {
                ((DefaultListModel)this._sourceList.getModel()).addElement(schemaTable);
            }
        }
        this._selectedList = new JList(new DefaultListModel());
        if (list2 != null) {
            for (SchemaTable schemaTable : list2) {
                ((DefaultListModel)this._selectedList.getModel()).addElement(schemaTable);
            }
        }
        this._sourceList.setFixedCellWidth(30);
        this._selectedList.setFixedCellWidth(30);
    }

    public void setLists(List<SchemaTable> list, List<SchemaTable> list2) {
        ((DefaultListModel)this._sourceList.getModel()).removeAllElements();
        if (list != null) {
            for (SchemaTable schemaTable : list) {
                ((DefaultListModel)this._sourceList.getModel()).addElement(schemaTable);
            }
        }
        ((DefaultListModel)this._selectedList.getModel()).removeAllElements();
        if (list2 != null) {
            for (SchemaTable schemaTable : list2) {
                ((DefaultListModel)this._selectedList.getModel()).addElement(schemaTable);
            }
        }
        this.added = new ArrayList<SchemaTable>();
        this.removed = new ArrayList<SchemaTable>();
    }

    public void enableShuttle(boolean bl) {
        this.addOne.setEnabled(bl);
        this.remOne.setEnabled(bl);
        this.addAll.setEnabled(bl);
        this.remAll.setEnabled(bl);
        this._selectedList.setEnabled(bl);
        this._sourceList.setEnabled(bl);
    }

    private void selectSchemaTable(SchemaTable schemaTable) {
        if (this.removed.contains(schemaTable)) {
            this.removed.remove(schemaTable);
        } else if (!this.added.contains(schemaTable)) {
            this.added.add(schemaTable);
        }
    }

    private void removeSchemaTable(SchemaTable schemaTable) {
        if (this.added.contains(schemaTable)) {
            this.added.remove(schemaTable);
        } else if (!this.removed.contains(schemaTable)) {
            this.removed.add(schemaTable);
        }
    }

    public List<SchemaTable> getAdded() {
        return this.added;
    }

    public List<SchemaTable> getRemoved() {
        return this.removed;
    }

    public List<SchemaTable> getSelected() {
        ArrayList<SchemaTable> arrayList = new ArrayList<SchemaTable>();
        DefaultListModel defaultListModel = (DefaultListModel)this._selectedList.getModel();
        if (defaultListModel != null) {
            for (int i = 0; i < defaultListModel.size(); ++i) {
                SchemaTable schemaTable = (SchemaTable)defaultListModel.get(i);
                arrayList.add(schemaTable);
            }
        }
        return arrayList;
    }

    public JPanel getPanel() {
        this._sourceList.setDragEnabled(false);
        this._sourceList.getAccessibleContext().setAccessibleName(ControlsArb.getString((String)"LIST_ACCESS"));
        this._sourceList.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n == 2) {
                    Object[] objectArray = ShuttleObjectPanel.this._sourceList.getSelectedValues();
                    for (int i = 0; i < objectArray.length; ++i) {
                        SchemaTable schemaTable = (SchemaTable)objectArray[i];
                        ((DefaultListModel)ShuttleObjectPanel.this._sourceList.getModel()).removeElement(schemaTable);
                        ((DefaultListModel)ShuttleObjectPanel.this._selectedList.getModel()).addElement(schemaTable);
                        ShuttleObjectPanel.this.sortList(ShuttleObjectPanel.this._selectedList);
                        ShuttleObjectPanel.this.selectSchemaTable(schemaTable);
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this._selectedList.setDragEnabled(false);
        this._selectedList.getAccessibleContext().setAccessibleName(ControlsArb.getString((String)"LIST_ACCESS"));
        this._selectedList.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n == 2) {
                    Object[] objectArray = ShuttleObjectPanel.this._selectedList.getSelectedValues();
                    for (int i = 0; i < objectArray.length; ++i) {
                        SchemaTable schemaTable = (SchemaTable)objectArray[i];
                        ((DefaultListModel)ShuttleObjectPanel.this._selectedList.getModel()).removeElement(schemaTable);
                        ((DefaultListModel)ShuttleObjectPanel.this._sourceList.getModel()).addElement(schemaTable);
                        ShuttleObjectPanel.this.sortList(ShuttleObjectPanel.this._sourceList);
                        ShuttleObjectPanel.this.removeSchemaTable(schemaTable);
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.addAll.setActionCommand(">>");
        this.addAll.getAccessibleContext().setAccessibleName(UiResources.getString((String)"ADD_ALL"));
        this.addAll.setName(UiResources.getString((String)"ADD_ALL"));
        this.addAll.setIcon(BaseRaptorImages.getIcon((String)"LAST_ENA"));
        this.addAll.addActionListener(this);
        this.addOne.setActionCommand(">");
        this.addOne.getAccessibleContext().setAccessibleName(UiResources.getString((String)"ADD_SELECTED"));
        this.addOne.setName(UiResources.getString((String)"ADD_SELECTED"));
        this.addOne.setIcon(BaseRaptorImages.getIcon((String)"NEXT_ENA"));
        this.addOne.addActionListener(this);
        this.remAll.setActionCommand("<<");
        this.remAll.getAccessibleContext().setAccessibleName(UiResources.getString((String)"REMOVE_ALL"));
        this.remAll.setName(UiResources.getString((String)"REMOVE_ALL"));
        this.remAll.setIcon(BaseRaptorImages.getIcon((String)"FIRST_ENA"));
        this.remAll.addActionListener(this);
        this.remOne.setActionCommand("<");
        this.remOne.getAccessibleContext().setAccessibleName(UiResources.getString((String)"REMOVE_SELECTED"));
        this.remOne.setName(UiResources.getString((String)"REMOVE_SELECTED"));
        this.remOne.setIcon(BaseRaptorImages.getIcon((String)"PREV_ENA"));
        this.remOne.addActionListener(this);
        this.sourceScrollPane1.setViewportView(this._sourceList);
        this.selectedScrollPane1.setViewportView(this._selectedList);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.sourceScrollPane1, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)6, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
        this.add((Component)new JPanel(), LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2BUTTON_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.Y));
        this.add((Component)this.addOne, LayoutControl.GBC.gbc((int)1, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP));
        this.add((Component)this.addAll, LayoutControl.GBC.gbc((int)1, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP));
        this.add((Component)this.remOne, LayoutControl.GBC.gbc((int)1, (int)3, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP));
        this.add((Component)this.remAll, LayoutControl.GBC.gbc((int)1, (int)4, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP));
        this.add((Component)new JPanel(), LayoutControl.GBC.gbc((int)1, (int)5, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.Y));
        this.add((Component)this.selectedScrollPane1, LayoutControl.GBC.gbc((int)2, (int)0, (int)1, (int)6, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2BUTTON_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
        return this;
    }

    private void sortList(JList jList) {
        int n = jList.getModel().getSize();
        SchemaTable[] schemaTableArray = new SchemaTable[n];
        for (int i = 0; i < n; ++i) {
            schemaTableArray[i] = (SchemaTable)jList.getModel().getElementAt(i);
        }
        Arrays.sort(schemaTableArray, new SchemaTableComparitor());
        jList.removeAll();
        DefaultListModel<SchemaTable> defaultListModel = new DefaultListModel<SchemaTable>();
        for (int i = 0; i < n; ++i) {
            defaultListModel.addElement(schemaTableArray[i]);
        }
        jList.setModel(defaultListModel);
        jList.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (!actionEvent.getActionCommand().equals(">")) break block4;
                        Object[] objectArray = this._sourceList.getSelectedValues();
                        for (int i = 0; i < objectArray.length; ++i) {
                            SchemaTable schemaTable = (SchemaTable)objectArray[i];
                            ((DefaultListModel)this._selectedList.getModel()).addElement(schemaTable);
                            this.sortList(this._selectedList);
                            ((DefaultListModel)this._sourceList.getModel()).removeElement(schemaTable);
                            this.selectSchemaTable(schemaTable);
                        }
                        break block5;
                    }
                    if (!actionEvent.getActionCommand().equals("<")) break block6;
                    Object[] objectArray = this._selectedList.getSelectedValues();
                    for (int i = 0; i < objectArray.length; ++i) {
                        SchemaTable schemaTable = (SchemaTable)objectArray[i];
                        ((DefaultListModel)this._sourceList.getModel()).addElement(schemaTable);
                        this.sortList(this._sourceList);
                        ((DefaultListModel)this._selectedList.getModel()).removeElement(schemaTable);
                        this.removeSchemaTable(schemaTable);
                    }
                    break block5;
                }
                if (!actionEvent.getActionCommand().equals(">>")) break block7;
                Object[] objectArray = ((DefaultListModel)this._sourceList.getModel()).toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    SchemaTable schemaTable = (SchemaTable)objectArray[i];
                    ((DefaultListModel)this._selectedList.getModel()).addElement(schemaTable);
                    this.sortList(this._selectedList);
                    ((DefaultListModel)this._sourceList.getModel()).removeElement(schemaTable);
                    this.selectSchemaTable(schemaTable);
                }
                break block5;
            }
            if (!actionEvent.getActionCommand().equals("<<")) break block5;
            Object[] objectArray = ((DefaultListModel)this._selectedList.getModel()).toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                SchemaTable schemaTable = (SchemaTable)objectArray[i];
                ((DefaultListModel)this._sourceList.getModel()).addElement(schemaTable);
                this.sortList(this._sourceList);
                ((DefaultListModel)this._selectedList.getModel()).removeElement(schemaTable);
                this.removeSchemaTable(schemaTable);
            }
        }
    }
}

