/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.MouseEvent;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin.NodeMonitorMixin;

class NodeMonitor {
    private Node currentNode = null;

    static void installMixin(Node node, NodeMonitorMixin nodeMonitorMixin) {
        Platform.runLater(() -> {
            List<NodeMonitorMixin> list = NodeMonitor.getMixins(node);
            if (list == null) {
                Parent parent = node.getScene().getRoot();
                NodeMonitor nodeMonitor = (NodeMonitor)parent.getProperties().get(NodeMonitor.class);
                if (nodeMonitor == null) {
                    nodeMonitor = new NodeMonitor();
                    parent.getProperties().put(NodeMonitor.class, (Object)nodeMonitor);
                }
                nodeMonitor.addHandlers(node);
                list = new ArrayList<NodeMonitorMixin>();
                node.getProperties().put(NodeMonitorMixin.class, list);
            }
            list.add(nodeMonitorMixin);
        });
    }

    private static List<NodeMonitorMixin> getMixins(Node node) {
        return (List)node.getProperties().get(NodeMonitorMixin.class);
    }

    private NodeMonitor() {
    }

    private void addHandlers(Node node) {
        node.addEventHandler(MouseEvent.MOUSE_ENTERED, mouseEvent -> this.handleEvent((MouseEvent)mouseEvent, node, true, false));
        node.addEventHandler(MouseEvent.MOUSE_EXITED, mouseEvent -> this.handleEvent((MouseEvent)mouseEvent, node, false, false));
        node.addEventHandler(MouseEvent.MOUSE_MOVED, mouseEvent -> this.handleEvent((MouseEvent)mouseEvent, node, true, false));
        node.addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> this.handleEvent((MouseEvent)mouseEvent, node, true, true));
    }

    private void handleEvent(MouseEvent mouseEvent, Node node, boolean bl, boolean bl2) {
        boolean bl3 = true;
        if (bl) {
            if (this.currentNode != node) {
                Node node2 = this.currentNode;
                this.currentNode = node;
                if (node2 != null) {
                    this.callOnExit(node2, mouseEvent);
                }
                this.callOnEnter(this.currentNode, mouseEvent);
            }
            if (bl2) {
                bl3 = this.callOnClick(this.currentNode, mouseEvent);
            }
        } else if (node != null && this.currentNode == node) {
            Node node3 = this.currentNode;
            this.currentNode = null;
            this.callOnExit(node3, mouseEvent);
        }
        if (bl3) {
            mouseEvent.consume();
        }
    }

    private void callOnEnter(Node node, MouseEvent mouseEvent) {
        List<NodeMonitorMixin> list = NodeMonitor.getMixins(node);
        for (NodeMonitorMixin nodeMonitorMixin : list) {
            try {
                nodeMonitorMixin.onEnter(node, mouseEvent);
            }
            catch (Exception exception) {
                Logger.getLogger(NodeMonitor.class.getName()).log(Level.WARNING, "handler error", exception);
            }
        }
    }

    private void callOnExit(Node node, MouseEvent mouseEvent) {
        List<NodeMonitorMixin> list = NodeMonitor.getMixins(node);
        for (NodeMonitorMixin nodeMonitorMixin : list) {
            try {
                nodeMonitorMixin.onExit(node, mouseEvent);
            }
            catch (Exception exception) {
                Logger.getLogger(NodeMonitor.class.getName()).log(Level.WARNING, "handler error", exception);
            }
        }
    }

    private boolean callOnClick(Node node, MouseEvent mouseEvent) {
        boolean bl = false;
        List<NodeMonitorMixin> list = NodeMonitor.getMixins(node);
        for (NodeMonitorMixin nodeMonitorMixin : list) {
            try {
                if (!nodeMonitorMixin.onClick(node, mouseEvent)) continue;
                bl = true;
            }
            catch (Exception exception) {
                Logger.getLogger(NodeMonitor.class.getName()).log(Level.WARNING, "handler error", exception);
            }
        }
        return bl;
    }
}

