/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.displays.dbinstance;

import java.net.URI;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.binding.NumericBindings;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.control.CylinderGauge;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.control.LabelledPanel;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.control.TimeSeriesItem;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.control.TimeSeriesLineChart;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.dbinstance.PanelStyle;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin.BorderMixin;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin.InitializingBlurMixin;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin.TransitionBlurMixin;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin.XMLViewerDrilldownMixin;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.panel.PanelContext;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.panel.PanelObject;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.util.CSSHelper;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.util.FXMLHelper;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.util.GraphHelper;
import oracle.dbtools.raptor.metrics.engine.DXChannel;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.value.DXDouble;
import oracle.dbtools.raptor.metrics.value.DXValues;

public class StorageFilesPanel
extends LabelledPanel
implements PanelObject {
    @FXML
    private LabelledPanel physicalIOPanel;
    @FXML
    private TimeSeriesLineChart physicalIOChart;
    @FXML
    private CylinderGauge dataGauge;
    @FXML
    private CylinderGauge tempGauge;
    @FXML
    private CylinderGauge undoGauge;
    @FXML
    private Label dataTitle;
    @FXML
    private Label dataPercent;
    @FXML
    private Label dataMax;
    @FXML
    private Label tempTitle;
    @FXML
    private Label tempPercent;
    @FXML
    private Label tempMax;
    @FXML
    private Label undoTitle;
    @FXML
    private Label undoPercent;
    @FXML
    private Label undoMax;

    public StorageFilesPanel() {
        FXMLHelper.load((Parent)this);
        CSSHelper.addStyleClass((Node)this, new Object[]{PanelStyle.CONTENT});
        CSSHelper.addStyleClass((Node)this.dataTitle, "storage-panel-subtitle");
        CSSHelper.addStyleClass((Node)this.tempTitle, "storage-panel-subtitle");
        CSSHelper.addStyleClass((Node)this.undoTitle, "storage-panel-subtitle");
    }

    @Override
    public void bind(PanelContext panelContext) {
        String string = panelContext.getConnectionName();
        String string2 = panelContext.getUserName();
        DXChannel dXChannel = panelContext.getChannel();
        final DXDouble dXDouble = DXValues.listenDerivative((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/PhysicalIO/MegaBytesRead"));
        final DXDouble dXDouble2 = DXValues.listenDerivative((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/PhysicalIO/MegaBytesWritten"));
        Object object = dXDouble.isAvailable().and((ObservableBooleanValue)dXDouble2.isAvailable());
        Object object2 = new SimpleListProperty(FXCollections.observableArrayList());
        object2.add((Object)new TimeSeriesItem("Read Total", (ObservableValue<Number>)dXDouble));
        object2.add((Object)new TimeSeriesItem("Write Total", (ObservableValue<Number>)dXDouble2));
        GraphHelper.setTimeAxis(this.physicalIOChart.getMonitor());
        this.physicalIOChart.getMonitor().enabledProperty().bind((ObservableValue)object);
        this.physicalIOChart.getMonitor().timeSeriesItemsProperty().bind((ObservableValue)object2);
        InitializingBlurMixin.install((Node)this.physicalIOChart, (ObservableValue<Boolean>)object);
        dXDouble = DXValues.listenDouble((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/DataFiles/Used"));
        dXDouble2 = DXValues.listenDouble((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/DataFiles/Max"));
        object = Bindings.divide((ObservableNumberValue)dXDouble, (ObservableNumberValue)dXDouble2);
        this.bindGauge(this.dataGauge, this.dataPercent, this.dataMax, (ObservableNumberValue)object, (ObservableStringValue)Bindings.format((String)"%.1f %%", (Object[])new Object[]{Bindings.multiply((ObservableNumberValue)object, (double)100.0)}), (ObservableNumberValue)dXDouble2, (ObservableBooleanValue)dXDouble.isAvailable().and((ObservableBooleanValue)dXDouble2.isAvailable()));
        dXDouble = DXValues.listenDouble((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/TempFiles/Used"));
        dXDouble2 = DXValues.listenDouble((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/TempFiles/Max"));
        object = Bindings.divide((ObservableNumberValue)dXDouble, (ObservableNumberValue)dXDouble2);
        this.bindGauge(this.tempGauge, this.tempPercent, this.tempMax, (ObservableNumberValue)object, (ObservableStringValue)Bindings.format((String)"%.1f %%", (Object[])new Object[]{Bindings.multiply((ObservableNumberValue)object, (double)100.0)}), (ObservableNumberValue)dXDouble2, (ObservableBooleanValue)dXDouble.isAvailable().and((ObservableBooleanValue)dXDouble2.isAvailable()));
        dXDouble = DXValues.listenDouble((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/UndoFiles/Used"));
        dXDouble2 = DXValues.listenDouble((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/UndoFiles/Max"));
        object = new DoubleBinding(){
            {
                super.bind(new Observable[]{dXDouble, dXDouble2});
            }

            protected double computeValue() {
                double d = dXDouble.get();
                double d2 = dXDouble2.get();
                return d > 0.0 && d2 > 0.0 ? d / d2 : 0.0;
            }
        };
        object2 = new StringBinding((DoubleBinding)object, dXDouble2){
            final /* synthetic */ DoubleBinding val$value;
            final /* synthetic */ DXDouble val$undoMaximumItem;
            {
                this.val$value = doubleBinding;
                this.val$undoMaximumItem = dXDouble;
                super.bind(new Observable[]{this.val$value, this.val$undoMaximumItem});
            }

            protected String computeValue() {
                double d = this.val$value.get();
                double d2 = this.val$undoMaximumItem.get();
                return d2 > 0.0 ? String.format("%.1f %%", d * 100.0) : "";
            }
        };
        this.bindGauge(this.undoGauge, this.undoPercent, this.undoMax, (ObservableNumberValue)object, (ObservableStringValue)object2, (ObservableNumberValue)dXDouble2, (ObservableBooleanValue)dXDouble.isAvailable().and((ObservableBooleanValue)dXDouble2.isAvailable()));
        BorderMixin.install((Node)this, true, BorderMixin.DRILLDOWN_COLOR);
        XMLViewerDrilldownMixin.install((Node)this, string, string2, "DATAFILE");
    }

    private void bindGauge(CylinderGauge cylinderGauge, Label label, Label label2, ObservableNumberValue observableNumberValue, ObservableStringValue observableStringValue, ObservableNumberValue observableNumberValue2, ObservableBooleanValue observableBooleanValue) {
        label.textProperty().bind((ObservableValue)observableStringValue);
        label2.textProperty().bind((ObservableValue)NumericBindings.toPrefixForm(observableNumberValue2, "B"));
        cylinderGauge.valueProperty().bind((ObservableValue)observableNumberValue);
        InitializingBlurMixin.install((Node)label, (ObservableValue<Boolean>)observableBooleanValue);
        TransitionBlurMixin.install((Node)label, label.textProperty());
        InitializingBlurMixin.install((Node)label2, (ObservableValue<Boolean>)observableBooleanValue);
        TransitionBlurMixin.install((Node)label2, label2.textProperty());
        InitializingBlurMixin.install((Node)cylinderGauge, (ObservableValue<Boolean>)observableBooleanValue);
        TransitionBlurMixin.install((Node)cylinderGauge, label.textProperty());
    }
}

