/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.displays.dbinstance;

import java.net.URI;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableMapValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.control.Label;
import javafx.util.StringConverter;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.binding.NumericBindings;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.binding.PointSeriesBindings;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.control.CylinderGauge;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.control.LabelledPanel;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.dbinstance.PanelStyle;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin.BorderMixin;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin.InitializingBlurMixin;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin.TransitionBlurMixin;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin.XMLViewerDrilldownMixin;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.panel.PanelContext;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.panel.PanelObject;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.util.CSSHelper;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.util.FXMLHelper;
import oracle.dbtools.raptor.metrics.engine.DXChannel;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.value.DXDouble;
import oracle.dbtools.raptor.metrics.value.DXLong;
import oracle.dbtools.raptor.metrics.value.DXRow;
import oracle.dbtools.raptor.metrics.value.DXValues;

public class RedoLogPanel
extends LabelledPanel
implements PanelObject {
    @FXML
    private LineChart<Long, Number> switchIntervalChart;
    @FXML
    private BarChart statusBarChart;
    @FXML
    private CylinderGauge redoGauge;
    @FXML
    private Label redoTitle;
    @FXML
    private Label redoPercent;
    @FXML
    private Label redoMax;
    @FXML
    private Label logFileCountsTitle;
    @FXML
    private Label logFileCurrent;
    @FXML
    private Label logFileActive;
    @FXML
    private Label logFileInactive;
    @FXML
    private Label logFileClearing;
    @FXML
    private Label logFileCurrentClearing;
    @FXML
    private Label logFileUnused;

    public RedoLogPanel() {
        FXMLHelper.load((Parent)this);
        CSSHelper.addStyleClass((Node)this, new Object[]{PanelStyle.CONTENT});
        CSSHelper.addStyleClass((Node)this.redoTitle, "storage-panel-subtitle");
        CSSHelper.addStyleClass((Node)this.logFileCountsTitle, "storage-panel-subtitle");
    }

    @Override
    public void bind(PanelContext panelContext) {
        String string = panelContext.getConnectionName();
        String string2 = panelContext.getUserName();
        DXChannel dXChannel = panelContext.getChannel();
        DXDouble dXDouble = DXValues.listenDouble((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/RedoLog/LogSize"));
        DXDouble dXDouble2 = DXValues.listenDouble((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/RedoLog/PercentFull"));
        DXLong dXLong = DXValues.listenLong((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/RedoLog/SequenceNumber"));
        DoubleBinding doubleBinding = Bindings.divide((ObservableNumberValue)dXDouble2, (double)100.0);
        this.redoTitle.textProperty().bind((ObservableValue)Bindings.format((String)"#%d", (Object[])new Object[]{dXLong}));
        this.redoPercent.textProperty().bind((ObservableValue)Bindings.format((String)"%.1f %%", (Object[])new Object[]{dXDouble2}));
        this.redoMax.textProperty().bind((ObservableValue)NumericBindings.toPrefixForm((ObservableNumberValue)dXDouble, "B"));
        this.redoGauge.valueProperty().bind((ObservableValue)doubleBinding);
        BooleanBinding booleanBinding = dXDouble.isAvailable().and((ObservableBooleanValue)dXDouble2.isAvailable()).and((ObservableBooleanValue)dXLong.isAvailable());
        InitializingBlurMixin.install((Node)this.redoPercent, (ObservableValue<Boolean>)booleanBinding);
        TransitionBlurMixin.install((Node)this.redoPercent, this.redoPercent.textProperty());
        InitializingBlurMixin.install((Node)this.redoMax, (ObservableValue<Boolean>)booleanBinding);
        TransitionBlurMixin.install((Node)this.redoMax, this.redoMax.textProperty());
        InitializingBlurMixin.install((Node)this.redoGauge, (ObservableValue<Boolean>)booleanBinding);
        TransitionBlurMixin.install((Node)this.redoGauge, this.redoPercent.textProperty());
        dXDouble = DXValues.listenMap((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/RedoLogSwitchInterval"));
        dXDouble2 = (NumberAxis)this.switchIntervalChart.getYAxis();
        dXDouble2.setTickLabelFormatter((StringConverter)new StringConverter<Number>(){

            public String toString(Number number) {
                double d = number.doubleValue();
                long l = (long)d;
                long l2 = (long)((d - (double)l) * 60.0);
                String string = String.format("%d:%02d", l, l2);
                return string;
            }

            public Number fromString(String string) {
                return Double.parseDouble(string);
            }
        });
        dXLong = PointSeriesBindings.transform((ObservableMapValue<Long, DXRow<Long>>)dXDouble, "SequenceNo", "IntervalHours");
        this.switchIntervalChart.dataProperty().bind(dXLong);
        dXDouble = DXValues.listenLong((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/RedoLogFileCount/Current"));
        this.logFileCurrent.textProperty().bind((ObservableValue)Bindings.format((String)"%s", (Object[])new Object[]{dXDouble}));
        dXDouble2 = DXValues.listenLong((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/RedoLogFileCount/Active"));
        this.logFileActive.textProperty().bind((ObservableValue)Bindings.format((String)"%s", (Object[])new Object[]{dXDouble2}));
        dXLong = DXValues.listenLong((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/RedoLogFileCount/Inactive"));
        this.logFileInactive.textProperty().bind((ObservableValue)Bindings.format((String)"%s", (Object[])new Object[]{dXLong}));
        doubleBinding = DXValues.listenLong((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/RedoLogFileCount/Clearing"));
        this.logFileClearing.textProperty().bind((ObservableValue)Bindings.format((String)"%s", (Object[])new Object[]{doubleBinding}));
        booleanBinding = DXValues.listenLong((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/RedoLogFileCount/CurrentClearing"));
        this.logFileCurrentClearing.textProperty().bind((ObservableValue)Bindings.format((String)"%s", (Object[])new Object[]{booleanBinding}));
        DXLong dXLong2 = DXValues.listenLong((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/RedoLogFileCount/Unused"));
        this.logFileUnused.textProperty().bind((ObservableValue)Bindings.format((String)"%s", (Object[])new Object[]{dXLong2}));
        BorderMixin.install((Node)this, true, BorderMixin.DRILLDOWN_COLOR);
        XMLViewerDrilldownMixin.install((Node)this, string, string2, "REDOLOGGROUP");
    }
}

