/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.displays.dbinstance;

import java.net.URI;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.control.LabelledPanel;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.control.TimeSeriesItem;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.control.TimeSeriesLineChart;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.dbinstance.PanelStyle;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin.BorderMixin;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin.InitializingBlurMixin;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin.ReportDrilldownMixin;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.panel.PanelContext;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.panel.PanelObject;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.util.CSSHelper;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.util.FXMLHelper;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.util.GraphHelper;
import oracle.dbtools.raptor.metrics.engine.DXChannel;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.value.DXLong;
import oracle.dbtools.raptor.metrics.value.DXValues;

public class ProcessPanel
extends LabelledPanel
implements PanelObject {
    @FXML
    private LabelledPanel countsPanel;
    @FXML
    private LabelledPanel executionRatePanel;
    @FXML
    private LabelledPanel parseRatePanel;
    @FXML
    private LabelledPanel openCursorsPanel;
    @FXML
    private LabelledPanel commitRatePanel;
    @FXML
    private Label dispatcher;
    @FXML
    private Label sharedServer;
    @FXML
    private Label dedicatedServer;
    @FXML
    private Label parallelServer;
    @FXML
    private Label busyParallelServer;
    @FXML
    private Label jobServer;
    @FXML
    private TimeSeriesLineChart executionRateChart;
    @FXML
    private TimeSeriesLineChart parseRateChart;
    @FXML
    private TimeSeriesLineChart openCursorsChart;
    @FXML
    private TimeSeriesLineChart commitRateChart;

    public ProcessPanel() {
        FXMLHelper.load((Parent)this);
        CSSHelper.addStyleClass((Node)this, new Object[]{PanelStyle.CONTAINER});
        CSSHelper.addStyleClass((Node)this.countsPanel, new Object[]{PanelStyle.CONTENT});
        CSSHelper.addStyleClass((Node)this.executionRatePanel, new Object[]{PanelStyle.CONTENT});
        CSSHelper.addStyleClass((Node)this.parseRatePanel, new Object[]{PanelStyle.CONTENT});
        CSSHelper.addStyleClass((Node)this.openCursorsPanel, new Object[]{PanelStyle.CONTENT});
        CSSHelper.addStyleClass((Node)this.commitRatePanel, new Object[]{PanelStyle.CONTENT});
    }

    @Override
    public void bind(PanelContext panelContext) {
        String string = panelContext.getConnectionName();
        DXChannel dXChannel = panelContext.getChannel();
        DXLong dXLong = DXValues.listenLong((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/ProcessCount/Dispatcher"));
        this.dispatcher.textProperty().bind((ObservableValue)Bindings.format((String)"%,d", (Object[])new Object[]{dXLong}));
        InitializingBlurMixin.install((Node)this.dispatcher, (ObservableValue<Boolean>)dXLong.isAvailable());
        dXLong = DXValues.listenLong((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/ProcessCount/SharedServer"));
        this.sharedServer.textProperty().bind((ObservableValue)Bindings.format((String)"%,d", (Object[])new Object[]{dXLong}));
        InitializingBlurMixin.install((Node)this.sharedServer, (ObservableValue<Boolean>)dXLong.isAvailable());
        dXLong = DXValues.listenLong((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/ProcessCount/DedicatedServer"));
        this.dedicatedServer.textProperty().bind((ObservableValue)Bindings.format((String)"%,d", (Object[])new Object[]{dXLong}));
        InitializingBlurMixin.install((Node)this.dedicatedServer, (ObservableValue<Boolean>)dXLong.isAvailable());
        dXLong = DXValues.listenLong((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/ProcessCount/ParallelServer"));
        this.parallelServer.textProperty().bind((ObservableValue)Bindings.format((String)"%,d", (Object[])new Object[]{dXLong}));
        InitializingBlurMixin.install((Node)this.parallelServer, (ObservableValue<Boolean>)dXLong.isAvailable());
        dXLong = DXValues.listenLong((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/ProcessCount/BusyParallelServer"));
        this.busyParallelServer.textProperty().bind((ObservableValue)Bindings.format((String)"%,d", (Object[])new Object[]{dXLong}));
        InitializingBlurMixin.install((Node)this.busyParallelServer, (ObservableValue<Boolean>)dXLong.isAvailable());
        dXLong = DXValues.listenLong((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/ProcessCount/JobServer"));
        this.jobServer.textProperty().bind((ObservableValue)Bindings.format((String)"%,d", (Object[])new Object[]{dXLong}));
        InitializingBlurMixin.install((Node)this.jobServer, (ObservableValue<Boolean>)dXLong.isAvailable());
        dXLong = DXValues.listenDouble((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/Indicator/ExecutionsPerSecond"));
        SimpleListProperty simpleListProperty = new SimpleListProperty(FXCollections.observableArrayList());
        simpleListProperty.add((Object)new TimeSeriesItem("Execution Rate", (ObservableValue<Number>)dXLong));
        GraphHelper.setTimeAxis(this.executionRateChart.getMonitor());
        this.executionRateChart.getMonitor().enabledProperty().bind((ObservableValue)dXLong.isAvailable());
        this.executionRateChart.getMonitor().timeSeriesItemsProperty().bind((ObservableValue)simpleListProperty);
        InitializingBlurMixin.install((Node)this.executionRateChart, (ObservableValue<Boolean>)dXLong.isAvailable());
        dXLong = DXValues.listenDouble((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/Indicator/ParsesPerSecond"));
        simpleListProperty = new SimpleListProperty(FXCollections.observableArrayList());
        simpleListProperty.add((Object)new TimeSeriesItem("Execution Rate", (ObservableValue<Number>)dXLong));
        GraphHelper.setTimeAxis(this.parseRateChart.getMonitor());
        this.parseRateChart.getMonitor().enabledProperty().bind((ObservableValue)dXLong.isAvailable());
        this.parseRateChart.getMonitor().timeSeriesItemsProperty().bind((ObservableValue)simpleListProperty);
        InitializingBlurMixin.install((Node)this.parseRateChart, (ObservableValue<Boolean>)dXLong.isAvailable());
        dXLong = DXValues.listenDouble((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/Indicator/OpenCursorsPerSecond"));
        simpleListProperty = new SimpleListProperty(FXCollections.observableArrayList());
        simpleListProperty.add((Object)new TimeSeriesItem("Execution Rate", (ObservableValue<Number>)dXLong));
        GraphHelper.setTimeAxis(this.openCursorsChart.getMonitor());
        this.openCursorsChart.getMonitor().enabledProperty().bind((ObservableValue)dXLong.isAvailable());
        this.openCursorsChart.getMonitor().timeSeriesItemsProperty().bind((ObservableValue)simpleListProperty);
        InitializingBlurMixin.install((Node)this.openCursorsChart, (ObservableValue<Boolean>)dXLong.isAvailable());
        dXLong = DXValues.listenDouble((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/Indicator/UserCommitsPerSecond"));
        simpleListProperty = new SimpleListProperty(FXCollections.observableArrayList());
        simpleListProperty.add((Object)new TimeSeriesItem("Execution Rate", (ObservableValue<Number>)dXLong));
        GraphHelper.setTimeAxis(this.commitRateChart.getMonitor());
        this.commitRateChart.getMonitor().enabledProperty().bind((ObservableValue)dXLong.isAvailable());
        this.commitRateChart.getMonitor().timeSeriesItemsProperty().bind((ObservableValue)simpleListProperty);
        InitializingBlurMixin.install((Node)this.commitRateChart, (ObservableValue<Boolean>)dXLong.isAvailable());
        BorderMixin.install((Node)this, true, BorderMixin.DRILLDOWN_COLOR);
        ReportDrilldownMixin.install((Node)this, string, "All Reports/Data Dictionary Reports/Database Administration/Top SQL/Top SQL by CPU");
    }
}

