/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.displays.dbinstance;

import java.net.URI;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.binding.NumericBindings;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.control.LabelledPanel;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.control.TimeSeriesItem;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.control.TimeSeriesLineChart;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.dbinstance.PanelStyle;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin.BorderMixin;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin.InitializingBlurMixin;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin.ReportDrilldownMixin;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin.TransitionBlurMixin;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.panel.PanelContext;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.panel.PanelObject;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.util.CSSHelper;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.util.FXMLHelper;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.util.GraphHelper;
import oracle.dbtools.raptor.metrics.engine.DXChannel;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.value.DXLong;
import oracle.dbtools.raptor.metrics.value.DXValues;

public class MemoryPanel
extends LabelledPanel
implements PanelObject {
    @FXML
    private LabelledPanel dbBlockRatePanel;
    @FXML
    private TimeSeriesLineChart dbBlockRateChart;
    @FXML
    private LabelledPanel logicalReadsPanel;
    @FXML
    private TimeSeriesLineChart logicalReadsChart;
    @FXML
    private LabelledPanel countsPanel;
    @FXML
    private LabelledPanel redoGeneratedPanel;
    @FXML
    private TimeSeriesLineChart redoGeneratedChart;
    @FXML
    private Label sgaUsed;
    @FXML
    private Label sgaMaximum;
    @FXML
    private Label bufferCache;
    @FXML
    private Label redoBuffers;
    @FXML
    private Label sharedPool;
    @FXML
    private Label largePool;

    public MemoryPanel() {
        FXMLHelper.load((Parent)this);
        CSSHelper.addStyleClass((Node)this, new Object[]{PanelStyle.CONTAINER});
        CSSHelper.addStyleClass((Node)this.dbBlockRatePanel, new Object[]{PanelStyle.CONTENT});
        CSSHelper.addStyleClass((Node)this.logicalReadsPanel, new Object[]{PanelStyle.CONTENT});
        CSSHelper.addStyleClass((Node)this.countsPanel, new Object[]{PanelStyle.CONTENT});
        CSSHelper.addStyleClass((Node)this.redoGeneratedPanel, new Object[]{PanelStyle.CONTENT});
    }

    @Override
    public void bind(PanelContext panelContext) {
        String string = panelContext.getConnectionName();
        DXChannel dXChannel = panelContext.getChannel();
        DXLong dXLong = DXValues.listenLong((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/SGA/Maximum"));
        this.sgaMaximum.textProperty().bind((ObservableValue)Bindings.format((String)"%s", (Object[])new Object[]{NumericBindings.toPrefixForm((ObservableNumberValue)dXLong, "B")}));
        InitializingBlurMixin.install((Node)this.sgaMaximum, (ObservableValue<Boolean>)dXLong.isAvailable());
        TransitionBlurMixin.install((Node)this.sgaMaximum, this.sgaMaximum.textProperty());
        dXLong = DXValues.listenLong((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/SGA/Used"));
        this.sgaUsed.textProperty().bind((ObservableValue)Bindings.format((String)"%s", (Object[])new Object[]{NumericBindings.toPrefixForm((ObservableNumberValue)dXLong, "B")}));
        InitializingBlurMixin.install((Node)this.sgaUsed, (ObservableValue<Boolean>)dXLong.isAvailable());
        TransitionBlurMixin.install((Node)this.sgaUsed, this.sgaUsed.textProperty());
        dXLong = DXValues.listenLong((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/SGA/BufferCache"));
        this.bufferCache.textProperty().bind((ObservableValue)Bindings.format((String)"%s", (Object[])new Object[]{NumericBindings.toPrefixForm((ObservableNumberValue)dXLong, "B")}));
        InitializingBlurMixin.install((Node)this.bufferCache, (ObservableValue<Boolean>)dXLong.isAvailable());
        TransitionBlurMixin.install((Node)this.bufferCache, this.bufferCache.textProperty());
        dXLong = DXValues.listenLong((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/SGA/RedoBuffers"));
        this.redoBuffers.textProperty().bind((ObservableValue)Bindings.format((String)"%s", (Object[])new Object[]{NumericBindings.toPrefixForm((ObservableNumberValue)dXLong, "B")}));
        InitializingBlurMixin.install((Node)this.redoBuffers, (ObservableValue<Boolean>)dXLong.isAvailable());
        TransitionBlurMixin.install((Node)this.redoBuffers, this.redoBuffers.textProperty());
        dXLong = DXValues.listenLong((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/SGA/SharedPool"));
        this.sharedPool.textProperty().bind((ObservableValue)Bindings.format((String)"%s", (Object[])new Object[]{NumericBindings.toPrefixForm((ObservableNumberValue)dXLong, "B")}));
        InitializingBlurMixin.install((Node)this.sharedPool, (ObservableValue<Boolean>)dXLong.isAvailable());
        TransitionBlurMixin.install((Node)this.sharedPool, this.sharedPool.textProperty());
        dXLong = DXValues.listenLong((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/SGA/LargePool"));
        this.largePool.textProperty().bind((ObservableValue)Bindings.format((String)"%s", (Object[])new Object[]{NumericBindings.toPrefixForm((ObservableNumberValue)dXLong, "B")}));
        InitializingBlurMixin.install((Node)this.largePool, (ObservableValue<Boolean>)dXLong.isAvailable());
        TransitionBlurMixin.install((Node)this.largePool, this.largePool.textProperty());
        dXLong = DXValues.listenDouble((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/Indicator/DBBlockChangesPerSecond"));
        SimpleListProperty simpleListProperty = new SimpleListProperty(FXCollections.observableArrayList());
        simpleListProperty.add((Object)new TimeSeriesItem("DB Block Rate", (ObservableValue<Number>)dXLong));
        GraphHelper.setTimeAxis(this.dbBlockRateChart.getMonitor());
        this.dbBlockRateChart.getMonitor().enabledProperty().bind((ObservableValue)dXLong.isAvailable());
        this.dbBlockRateChart.getMonitor().timeSeriesItemsProperty().bind((ObservableValue)simpleListProperty);
        InitializingBlurMixin.install((Node)this.dbBlockRatePanel, (ObservableValue<Boolean>)dXLong.isAvailable());
        dXLong = DXValues.listenDouble((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/Indicator/LogicalReadsPerSecond"));
        simpleListProperty = new SimpleListProperty(FXCollections.observableArrayList());
        simpleListProperty.add((Object)new TimeSeriesItem("Logical Reads", (ObservableValue<Number>)dXLong));
        GraphHelper.setTimeAxis(this.logicalReadsChart.getMonitor());
        this.logicalReadsChart.getMonitor().enabledProperty().bind((ObservableValue)dXLong.isAvailable());
        this.logicalReadsChart.getMonitor().timeSeriesItemsProperty().bind((ObservableValue)simpleListProperty);
        InitializingBlurMixin.install((Node)this.logicalReadsPanel, (ObservableValue<Boolean>)dXLong.isAvailable());
        dXLong = DXValues.listenDouble((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/Indicator/RedoGeneratedPerSecond"));
        simpleListProperty = new SimpleListProperty(FXCollections.observableArrayList());
        simpleListProperty.add((Object)new TimeSeriesItem("Logical Reads", (ObservableValue<Number>)dXLong));
        GraphHelper.setTimeAxis(this.redoGeneratedChart.getMonitor());
        this.redoGeneratedChart.getMonitor().enabledProperty().bind((ObservableValue)dXLong.isAvailable());
        this.redoGeneratedChart.getMonitor().timeSeriesItemsProperty().bind((ObservableValue)simpleListProperty);
        InitializingBlurMixin.install((Node)this.redoGeneratedPanel, (ObservableValue<Boolean>)dXLong.isAvailable());
        BorderMixin.install((Node)this, true, BorderMixin.DRILLDOWN_COLOR);
        ReportDrilldownMixin.install((Node)this, string, "All Reports/Data Dictionary Reports/Database Administration/Memory/SGA Statistics");
    }
}

