/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.displays.control;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;

public class LabelledPanel
extends Region {
    private final ObjectProperty<Region> contentProperty = new SimpleObjectProperty((Object)this, "content");
    private final DoubleProperty contentMarginProperty;
    private final DoubleProperty titleLabelStartInsetProperty;
    private final DoubleProperty titleLabelHeadInsetProperty;
    private final DoubleProperty titleLabelTailInsetProperty;
    private final BooleanProperty titleVerticalProperty;
    private final ReadOnlyObjectProperty<Rectangle> rectangleProperty;
    private final ReadOnlyObjectProperty<Label> titleLabelProperty;

    public LabelledPanel() {
        this.contentProperty.addListener((observableValue, region, region2) -> {
            if (region != null) {
                this.getChildren().remove(2);
            }
            if (region2 != null) {
                this.getChildren().add(region2);
            }
        });
        this.contentMarginProperty = new SimpleDoubleProperty((Object)this, "contentMargin", 3.0){

            protected void invalidated() {
                LabelledPanel.this.requestLayout();
            }
        };
        this.titleLabelStartInsetProperty = new SimpleDoubleProperty((Object)this, "titleLabelStartInset", 3.0){

            protected void invalidated() {
                LabelledPanel.this.requestLayout();
            }
        };
        this.titleLabelHeadInsetProperty = new SimpleDoubleProperty((Object)this, "titleLabelHeadInset", 1.0){

            protected void invalidated() {
                LabelledPanel.this.requestLayout();
            }
        };
        this.titleLabelTailInsetProperty = new SimpleDoubleProperty((Object)this, "titleLabelTailInset", 1.0){

            protected void invalidated() {
                LabelledPanel.this.requestLayout();
            }
        };
        this.titleVerticalProperty = new SimpleBooleanProperty((Object)this, "titleVertical", false){

            protected void invalidated() {
                LabelledPanel.this.requestLayout();
            }
        };
        this.rectangleProperty = new SimpleObjectProperty((Object)new Rectangle());
        this.titleLabelProperty = new SimpleObjectProperty((Object)new Label());
        Rectangle rectangle = (Rectangle)this.rectangleProperty.get();
        Label label = (Label)this.titleLabelProperty.get();
        rectangle.setStroke((Paint)Color.BLACK);
        rectangle.setStrokeType(StrokeType.INSIDE);
        rectangle.setStrokeWidth(0.5);
        rectangle.arcHeightProperty().addListener((observableValue, number, number2) -> rectangle.setArcWidth(number2.doubleValue()));
        label.getStyleClass().add((Object)"title-label");
        rectangle.getStyleClass().add((Object)"rectangle");
        this.getStyleClass().add((Object)"labelled-panel");
        this.getChildren().setAll((Object[])new Node[]{rectangle, label});
    }

    public final void setContent(Region region) {
        this.contentProperty.set((Object)region);
    }

    public final Region getContent() {
        return (Region)this.contentProperty.get();
    }

    public final ObjectProperty<Region> contentProperty() {
        return this.contentProperty;
    }

    public final void setContentMargin(double d) {
        this.contentMarginProperty.setValue((Number)d);
    }

    public final double getContentMargin() {
        return this.contentMarginProperty.getValue();
    }

    public final DoubleProperty contentMarginProperty() {
        return this.contentMarginProperty;
    }

    public final void setTitleLabelStartInset(double d) {
        this.titleLabelStartInsetProperty.setValue((Number)d);
    }

    public final double getTitleLabelStartInset() {
        return this.titleLabelStartInsetProperty.getValue();
    }

    public final DoubleProperty titleLabelStartInsetProperty() {
        return this.titleLabelStartInsetProperty;
    }

    public final void setTitleLabelHeadInset(double d) {
        this.titleLabelHeadInsetProperty.setValue((Number)d);
    }

    public final double getTitleLabelHeadInset() {
        return this.titleLabelHeadInsetProperty.getValue();
    }

    public final DoubleProperty titleLabelHeadInsetProperty() {
        return this.titleLabelHeadInsetProperty;
    }

    public final void setTitleLabelTailInset(double d) {
        this.titleLabelTailInsetProperty.setValue((Number)d);
    }

    public final double getTitleLabelTailInset() {
        return this.titleLabelTailInsetProperty.getValue();
    }

    public final DoubleProperty titleLabelTailInsetProperty() {
        return this.titleLabelTailInsetProperty;
    }

    public final void setTitleVertical(boolean bl) {
        this.titleVerticalProperty.setValue(Boolean.valueOf(bl));
    }

    public final boolean isTitleVertical() {
        return this.titleVerticalProperty.getValue();
    }

    public final BooleanProperty titleVerticalProperty() {
        return this.titleVerticalProperty;
    }

    public Rectangle getRectangle() {
        return (Rectangle)this.rectangleProperty.get();
    }

    public ReadOnlyObjectProperty<Rectangle> rectangleProperty() {
        return this.rectangleProperty;
    }

    public Label getTitleLabel() {
        return (Label)this.titleLabelProperty.get();
    }

    public ReadOnlyObjectProperty<Label> titleLabelProperty() {
        return this.titleLabelProperty;
    }

    protected double computeMinWidth(double d) {
        double d2;
        double d3 = 0.0;
        double d4 = this.getContentMargin();
        double d5 = this.getTitleLabelStartInset();
        double d6 = this.getTitleLabelHeadInset();
        double d7 = this.getTitleLabelTailInset();
        boolean bl = this.isLabelPresent();
        double d8 = bl ? this.labelMinWidth() : 0.0;
        boolean bl2 = this.isContentPresent();
        double d9 = d2 = bl ? this.contentMinWidth() : 0.0;
        if (this.isTitleVertical()) {
            if (bl && bl2) {
                d3 = d8 + d2 + d6 + d7 + d4;
            } else if (bl || bl2) {
                d3 = bl ? d8 + d6 + d7 : d2 + 2.0 * d4;
            }
        } else if (bl2) {
            d3 = d2 + 2.0 * d4;
        } else if (bl) {
            d3 = d8 + 2.0 * d5;
        }
        return d3;
    }

    protected double computePrefWidth(double d) {
        double d2;
        double d3 = 0.0;
        double d4 = this.getContentMargin();
        double d5 = this.getTitleLabelStartInset();
        double d6 = this.getTitleLabelHeadInset();
        double d7 = this.getTitleLabelTailInset();
        boolean bl = this.isLabelPresent();
        double d8 = bl ? this.labelPrefWidth() : 0.0;
        boolean bl2 = this.isContentPresent();
        double d9 = d2 = bl ? this.contentPrefWidth() : 0.0;
        if (this.isTitleVertical()) {
            if (bl && bl2) {
                d3 = d8 + d2 + d6 + d7 + d4;
            } else if (bl || bl2) {
                d3 = bl ? d8 + d6 + d7 : d2 + 2.0 * d4;
            }
        } else if (bl2) {
            d3 = d2 + 2.0 * d4;
        } else if (bl) {
            d3 = d8 + 2.0 * d5;
        }
        return d3;
    }

    protected double computeMinHeight(double d) {
        double d2;
        double d3 = 0.0;
        double d4 = this.getContentMargin();
        double d5 = this.getTitleLabelStartInset();
        double d6 = this.getTitleLabelHeadInset();
        double d7 = this.getTitleLabelTailInset();
        boolean bl = this.isLabelPresent();
        double d8 = bl ? this.labelMinHeight() : 0.0;
        boolean bl2 = this.isContentPresent();
        double d9 = d2 = bl ? this.contentMinHeight() : 0.0;
        if (!this.isTitleVertical()) {
            if (bl && bl2) {
                d3 = d8 + d2 + d5 + d7 + d4;
            } else if (bl || bl2) {
                d3 = bl ? d8 + d5 + d7 : d2 + 2.0 * d4;
            }
        } else if (bl2) {
            d3 = d2 + 2.0 * d4;
        } else if (bl) {
            d3 = d8 + 2.0 * d6;
        }
        return d3;
    }

    protected double computePrefHeight(double d) {
        double d2;
        double d3 = 0.0;
        double d4 = this.getContentMargin();
        double d5 = this.getTitleLabelStartInset();
        double d6 = this.getTitleLabelHeadInset();
        double d7 = this.getTitleLabelTailInset();
        boolean bl = this.isLabelPresent();
        double d8 = bl ? this.labelPrefHeight() : 0.0;
        boolean bl2 = this.isContentPresent();
        double d9 = d2 = bl ? this.contentPrefHeight() : 0.0;
        if (!this.isTitleVertical()) {
            if (bl && bl2) {
                d3 = d8 + d2 + d5 + d7 + d4;
            } else if (bl || bl2) {
                d3 = bl ? d8 + d5 + d7 : d2 + 2.0 * d4;
            }
        } else if (bl2) {
            d3 = d2 + 2.0 * d4;
        } else if (bl) {
            d3 = d8 + 2.0 * d6;
        }
        return d3;
    }

    protected void layoutChildren() {
        Region region;
        double d = this.getWidth();
        double d2 = this.getHeight();
        Rectangle rectangle = (Rectangle)this.rectangleProperty.get();
        Label label = (Label)this.titleLabelProperty.get();
        rectangle.setWidth(d);
        rectangle.setHeight(d2);
        double d3 = this.getContentMargin();
        double d4 = this.getTitleLabelStartInset();
        double d5 = this.getTitleLabelHeadInset();
        double d6 = this.getTitleLabelTailInset();
        boolean bl = this.isLabelPresent();
        label.setVisible(bl);
        double d7 = bl ? this.labelPrefWidth() : 0.0;
        double d8 = bl ? this.labelPrefHeight() : 0.0;
        boolean bl2 = this.isTitleVertical();
        if (bl) {
            double d9;
            double d10 = bl2 ? d5 : d4;
            double d11 = d9 = bl2 ? d4 : d5;
            if (bl2) {
                label.setRotate(-90.0);
                this.layoutInArea((Node)label, d10 += (d7 - d8) / 2.0, d9 += (d8 - d7) / 2.0, d8, d7, 0.0, HPos.LEFT, VPos.TOP);
            } else {
                label.setRotate(0.0);
                this.layoutInArea((Node)label, d10, d9, d7, d8, 0.0, HPos.LEFT, VPos.TOP);
            }
        }
        if ((region = this.getContent()) != null) {
            double d12;
            double d13;
            if (bl) {
                d13 = bl2 ? d7 + d5 + d6 : d3;
                d12 = bl2 ? d3 : d8 + d5 + d6;
            } else {
                d13 = d3;
                d12 = d3;
            }
            double d14 = d - d13 - d3;
            double d15 = d2 - d12 - d3;
            this.layoutInArea((Node)region, d13, d12, d14, d15, 0.0, HPos.LEFT, VPos.TOP);
        }
    }

    private boolean isLabelPresent() {
        Label label = (Label)this.titleLabelProperty.get();
        return label.getText() != null && !label.getText().equals("");
    }

    private double labelPrefHeight() {
        Label label = (Label)this.titleLabelProperty.get();
        return this.isTitleVertical() ? label.prefWidth(-1.0) : label.prefHeight(-1.0);
    }

    private double labelPrefWidth() {
        Label label = (Label)this.titleLabelProperty.get();
        return this.isTitleVertical() ? label.prefHeight(-1.0) : label.prefWidth(-1.0);
    }

    private double labelMinHeight() {
        Label label = (Label)this.titleLabelProperty.get();
        return this.isTitleVertical() ? label.minWidth(-1.0) : label.minHeight(-1.0);
    }

    private double labelMinWidth() {
        Label label = (Label)this.titleLabelProperty.get();
        return this.isTitleVertical() ? label.minHeight(-1.0) : label.minWidth(-1.0);
    }

    private boolean isContentPresent() {
        return this.getContent() != null;
    }

    private double contentPrefHeight() {
        Region region = this.getContent();
        return region != null ? region.prefHeight(-1.0) : 0.0;
    }

    private double contentPrefWidth() {
        Region region = this.getContent();
        return region != null ? region.prefWidth(-1.0) : 0.0;
    }

    private double contentMinHeight() {
        Region region = this.getContent();
        return region != null ? region.minHeight(-1.0) : 0.0;
    }

    private double contentMinWidth() {
        Region region = this.getContent();
        return region != null ? region.minWidth(-1.0) : 0.0;
    }
}

