/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.displays.control;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.util.CSSHelper;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.util.ColorHelper;

public class CylindricalGauge
extends Region {
    private static final double TOP_HEIGHT = 0.08;
    private final Ellipse top = new Ellipse();
    private final Ellipse bottom = new Ellipse();
    private final Path tube = new Path();
    private final Ellipse fillTop = new Ellipse();
    private final Ellipse fillBottom = new Ellipse();
    private final Path fillTube = new Path();
    private final AnchorPane anchorPane = new AnchorPane();
    private final VBox vbox = new VBox();
    private final SimpleObjectProperty<Color> errorColor = new SimpleObjectProperty<Color>((Object)this, "errorColor", Color.hsb((double)10.0, (double)0.9, (double)0.8)){

        protected void invalidated() {
            CylindricalGauge.this.requestLayout();
        }
    };
    private final SimpleObjectProperty<Color> warningColor = new SimpleObjectProperty<Color>((Object)this, "warningColor", Color.hsb((double)35.0, (double)0.9, (double)0.8)){

        protected void invalidated() {
            CylindricalGauge.this.requestLayout();
        }
    };
    private final SimpleObjectProperty<Color> normalColor = new SimpleObjectProperty<Color>((Object)this, "normalColor", Color.hsb((double)90.0, (double)0.9, (double)0.8)){

        protected void invalidated() {
            CylindricalGauge.this.requestLayout();
        }
    };
    private final SimpleDoubleProperty warningLevel = new SimpleDoubleProperty((Object)this, "warningLevel", 0.4){

        protected void invalidated() {
            CylindricalGauge.this.requestLayout();
        }
    };
    private final SimpleDoubleProperty errorLevel = new SimpleDoubleProperty((Object)this, "errorLevel", 0.7){

        protected void invalidated() {
            CylindricalGauge.this.requestLayout();
        }
    };
    private final SimpleDoubleProperty value = new SimpleDoubleProperty((Object)this, "value", 0.5){

        protected void invalidated() {
            CylindricalGauge.this.requestLayout();
        }
    };
    private final SimpleObjectProperty<Label> titleLabelProperty = new SimpleObjectProperty((Object)this, "titleLabel", (Object)new Label());
    private final SimpleObjectProperty<Label> maximumLabelProperty = new SimpleObjectProperty((Object)this, "maximumLabel", (Object)new Label());
    private final SimpleObjectProperty<Label> usedLabelProperty = new SimpleObjectProperty((Object)this, "usedLabel", (Object)new Label());

    public CylindricalGauge() {
        CSSHelper.load((Parent)this);
        this.getStyleClass().add((Object)"cylindrical-gauge");
        this.tube.getStyleClass().add((Object)"tube");
        this.top.getStyleClass().add((Object)"tube-top");
        this.bottom.getStyleClass().add((Object)"tube-bottom");
        this.fillTube.getStyleClass().add((Object)"fill-tube");
        this.fillTop.getStyleClass().add((Object)"fill-tube-top");
        this.fillBottom.getStyleClass().add((Object)"fill-tube-bottom");
        Label label = (Label)this.titleLabelProperty.get();
        Label label2 = (Label)this.maximumLabelProperty.get();
        Label label3 = (Label)this.usedLabelProperty.get();
        label.getStyleClass().add((Object)"title-label");
        label2.getStyleClass().add((Object)"maximum-label");
        label3.getStyleClass().add((Object)"used-label");
        label.setAlignment(Pos.CENTER);
        label2.setAlignment(Pos.CENTER);
        label3.setAlignment(Pos.CENTER);
        this.anchorPane.getChildren().addAll((Object[])new Node[]{this.tube, this.bottom, this.fillTube, this.fillTop, this.fillBottom, this.top, label2, label3});
        this.vbox.getChildren().addAll((Object[])new Node[]{this.anchorPane, label});
        this.getChildren().addAll((Object[])new Node[]{this.vbox});
    }

    public Color getErrorColor() {
        return (Color)this.errorColor.get();
    }

    public SimpleObjectProperty<Color> errorColorProperty() {
        return this.errorColor;
    }

    public void setErrorColor(Color color) {
        this.errorColor.set((Object)color);
    }

    public Color getWarningColor() {
        return (Color)this.warningColor.get();
    }

    public SimpleObjectProperty<Color> warningColorProperty() {
        return this.warningColor;
    }

    public void setWarningColor(Color color) {
        this.warningColor.set((Object)color);
    }

    public void setNormalColor(Color color) {
        this.normalColor.set((Object)color);
    }

    public Color getNormalColor() {
        return (Color)this.normalColor.get();
    }

    public SimpleObjectProperty<Color> normalColorProperty() {
        return this.normalColor;
    }

    public void setWarningLevel(double d) {
        this.warningLevel.set(d);
    }

    public double getWarningLevel() {
        return this.warningLevel.get();
    }

    public SimpleDoubleProperty warningLevelProperty() {
        return this.warningLevel;
    }

    public void setErrorLevel(double d) {
        this.errorLevel.set(d);
    }

    public double getErrorLevel() {
        return this.errorLevel.get();
    }

    public SimpleDoubleProperty errorLevelProperty() {
        return this.errorLevel;
    }

    public void setValue(double d) {
        this.value.set(d);
    }

    public double getValue() {
        return this.value.get();
    }

    public DoubleProperty valueProperty() {
        return this.value;
    }

    public Label getTitleLabel() {
        return (Label)this.titleLabelProperty.get();
    }

    public ReadOnlyObjectProperty<Label> titleLabelProperty() {
        return this.titleLabelProperty;
    }

    public Label getMaximumLabel() {
        return (Label)this.maximumLabelProperty.get();
    }

    public ReadOnlyObjectProperty<Label> maximumLabelProperty() {
        return this.maximumLabelProperty;
    }

    public Label getUsedLabel() {
        return (Label)this.usedLabelProperty.get();
    }

    public ReadOnlyObjectProperty<Label> usedLabelProperty() {
        return this.usedLabelProperty;
    }

    public String getTitleText() {
        return ((Label)this.titleLabelProperty.get()).getText();
    }

    public void setTitleText(String string) {
        ((Label)this.titleLabelProperty.get()).setText(string);
    }

    public StringProperty titleTextProperty() {
        return ((Label)this.titleLabelProperty.get()).textProperty();
    }

    public String getMaximumText() {
        return ((Label)this.maximumLabelProperty.get()).getText();
    }

    public void setMaximumText(String string) {
        ((Label)this.maximumLabelProperty.get()).setText(string);
    }

    public StringProperty maximumTextProperty() {
        return ((Label)this.maximumLabelProperty.get()).textProperty();
    }

    public String getUsedText() {
        return ((Label)this.usedLabelProperty.get()).getText();
    }

    public void setUsedText(String string) {
        ((Label)this.usedLabelProperty.get()).setText(string);
    }

    public StringProperty usedTextProperty() {
        return ((Label)this.usedLabelProperty.get()).textProperty();
    }

    protected void layoutChildren() {
        Label label = (Label)this.titleLabelProperty.get();
        Label label2 = (Label)this.maximumLabelProperty.get();
        Label label3 = (Label)this.usedLabelProperty.get();
        int n = (int)this.getWidth();
        int n2 = (int)this.getHeight();
        int n3 = (int)label.prefHeight(-1.0);
        int n4 = n;
        int n5 = n2 - n3;
        int n6 = n4 / 2;
        int n7 = (int)((double)n5 * 0.08);
        int n8 = (int)((double)n7 / 2.0);
        int n9 = (int)((double)(n5 - n7) * (1.0 - this.value.get()));
        this.top.setCenterX((double)n6);
        this.top.setCenterY((double)n8);
        this.top.setRadiusX((double)n6);
        this.top.setRadiusY((double)n8);
        this.bottom.setCenterX((double)n6);
        this.bottom.setCenterY((double)(n5 - n8));
        this.bottom.setRadiusX((double)n6);
        this.bottom.setRadiusY((double)n8);
        this.tube.getElements().setAll((Object[])new PathElement[]{new MoveTo(0.0, (double)n8), new ArcTo((double)n6, (double)n8, 180.0, (double)n4, (double)n8, false, true), new LineTo((double)n4, (double)(n5 - n8)), new ArcTo((double)n6, (double)n8, 180.0, 0.0, (double)(n5 - n8), false, true), new ClosePath()});
        this.fillTop.setCenterX((double)n6);
        this.fillTop.setCenterY((double)(n9 + n8));
        this.fillTop.setRadiusX((double)n6);
        this.fillTop.setRadiusY((double)n8);
        this.fillBottom.setCenterX((double)n6);
        this.fillBottom.setCenterY((double)(n5 - n8));
        this.fillBottom.setRadiusX((double)n6);
        this.fillBottom.setRadiusY((double)n8);
        this.fillTube.getElements().setAll((Object[])new PathElement[]{new MoveTo(0.0, (double)(n9 + n8)), new ArcTo((double)n6, (double)n8, 180.0, (double)n4, (double)(n9 + n8), false, true), new LineTo((double)n4, (double)(n5 - n8)), new ArcTo((double)n6, (double)n8, 180.0, 0.0, (double)(n5 - n8), false, true), new ClosePath()});
        label.setPrefWidth((double)n);
        label.setMinWidth((double)n);
        label.setMaxWidth((double)n);
        if (this.value.get() == 0.0) {
            this.fillTube.setVisible(false);
            this.fillBottom.setVisible(false);
            this.fillTop.setVisible(false);
        } else {
            double d;
            Color color;
            this.fillTube.setVisible(true);
            this.fillBottom.setVisible(true);
            this.fillTop.setVisible(true);
            Color color2 = (Color)this.errorColor.get();
            Color color3 = (Color)this.warningColor.get();
            Color color4 = color = (Color)this.normalColor.get();
            if (this.value.get() > this.errorLevel.get() + 0.05) {
                color4 = color2;
            } else if (this.value.get() > this.errorLevel.get() - 0.05) {
                d = (this.value.get() - (this.errorLevel.get() - 0.05)) / 0.05;
                color4 = color3.interpolate(color2, d);
            } else if (this.value.get() > this.warningLevel.get() + 0.05) {
                color4 = color3;
            } else if (this.value.get() > this.warningLevel.get() - 0.05) {
                d = (this.value.get() - (this.warningLevel.get() - 0.05)) / 0.05;
                color4 = color.interpolate(color3, d);
            }
            String string = ColorHelper.getWebColor(color4);
            this.fillTube.setStyle("-fx-base:" + string + ";");
            this.fillBottom.setStyle("-fx-base:" + string + ";");
            this.fillTop.setStyle("-fx-base:" + string + ";");
        }
        double d = label2.prefWidth(-1.0);
        double d2 = label2.prefHeight(-1.0);
        double d3 = label3.prefWidth(-1.0);
        double d4 = label3.prefHeight(-1.0);
        Bounds bounds = this.top.getLayoutBounds();
        double d5 = bounds.getMaxY();
        Bounds bounds2 = this.fillTop.getLayoutBounds();
        double d6 = bounds2.getMaxY();
        Bounds bounds3 = this.bottom.getLayoutBounds();
        double d7 = bounds3.getMaxY();
        double d8 = ((double)n - d) / 2.0;
        double d9 = d5;
        double d10 = ((double)n - d3) / 2.0;
        double d11 = d6 + d4 > d7 ? d7 - d4 : (d6 < d9 + d2 ? d9 + d2 : d6);
        this.layoutInArea((Node)label2, d8, d9, d, d2, 0.0, HPos.LEFT, VPos.TOP);
        this.layoutInArea((Node)label3, d10, d11, d3, d4, 0.0, HPos.LEFT, VPos.TOP);
    }
}

