/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.displays.control;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.control.ManagedShape;

public class Arrowhead
extends ManagedShape {
    private final Polygon triangle = new Polygon();
    private final DoubleProperty headLengthProperty = new SimpleDoubleProperty((Object)this, "headLength", 20.0){

        protected void invalidated() {
            Arrowhead.this.requestLayout();
        }
    };
    private final DoubleProperty headWidthProperty = new SimpleDoubleProperty((Object)this, "headWidth", 10.0){

        protected void invalidated() {
            Arrowhead.this.requestLayout();
        }
    };
    private final ObservableList<Point2D> points = FXCollections.observableArrayList();

    public Arrowhead() {
        this.getStyleClass().setAll((Object[])new String[]{"arrowhead"});
        this.triangle.getStyleClass().setAll((Object[])new String[]{"triangle"});
        this.points.addListener(change -> this.requestLayout());
    }

    public final void setHeadWidth(double d) {
        this.headWidthProperty.setValue((Number)d);
    }

    public final double getHeadWidth() {
        return this.headWidthProperty.getValue();
    }

    public final DoubleProperty headWidthProperty() {
        return this.headWidthProperty;
    }

    public final void setHeadLength(double d) {
        this.headLengthProperty.setValue((Number)d);
    }

    public final double getHeadLength() {
        return this.headLengthProperty.getValue();
    }

    public final DoubleProperty headLengthProperty() {
        return this.headLengthProperty;
    }

    public ObservableList<Point2D> getPoints() {
        return this.points;
    }

    @Override
    protected Shape getManagedShape() {
        return this.triangle;
    }

    @Override
    protected void layoutWithinRegion(double d, double d2) {
        Point2D point2D;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 1.0;
        double d6 = 1.0;
        if (this.points.size() > 0) {
            point2D = (Point2D)this.points.get(0);
            d3 = point2D.getX() * d;
            d4 = point2D.getY() * d2;
        }
        if (this.points.size() > 1) {
            point2D = (Point2D)this.points.get(1);
            d5 = point2D.getX() * d;
            d6 = point2D.getY() * d2;
        }
        double d7 = d5 - d3;
        double d8 = d6 - d4;
        double d9 = Math.sqrt(d7 * d7 + d8 * d8);
        double d10 = d8 / d9;
        double d11 = d7 / d9;
        double d12 = this.getHeadLength();
        double d13 = this.getHeadWidth() / 2.0;
        double d14 = d3;
        double d15 = d4;
        double d16 = d3 + d12 * d11 - d13 * d10;
        double d17 = d4 + d12 * d10 + d13 * d11;
        double d18 = d3 + d12 * d11 + d13 * d10;
        double d19 = d4 + d12 * d10 - d13 * d11;
        this.triangle.getPoints().setAll((Object[])new Double[]{d14, d15, d16, d17, d18, d19});
    }
}

