/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.resourcemanagerplans;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.util.DbaUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class CreateEditAction
extends ActionDialog {
    private static final String PLAN_NAME = "PlanName";
    private static final String DESCRIPTION = "Description";
    private static final String MGMT_METHOD = "ManagementMethod";
    private static final String COPY_DIRECTIVES = "CopyDirectives";
    private boolean isPDB;
    private boolean is11gOrLater;
    private ArrayList<Directive> directives;

    protected String getTitle() {
        String string = null;
        Operation operation = this.getOperation();
        string = operation == Operation.EDIT ? DbaNavigatorResources.getString("EDIT_PLAN_TITLE") : DbaNavigatorResources.getString("CREATE_PLAN_TITLE");
        return string;
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        BooleanCheckBoxActionControl booleanCheckBoxActionControl;
        String[] stringArray;
        DBUtil dBUtil;
        TextBoxActionControl textBoxActionControl;
        Object object;
        this.isPDB = DbaUtil.isPDB(connection);
        boolean bl = false;
        try {
            bl = connection.getMetaData().getDatabaseMajorVersion() == 9;
            this.is11gOrLater = connection.getMetaData().getDatabaseMajorVersion() >= 11;
        }
        catch (SQLException sQLException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        Operation operation = this.getOperation();
        String string = this.getObjectName();
        String string2 = DbaNavigatorResources.getString("ENTER_VALUE_PROMPT");
        String string3 = "";
        String string4 = "EMPHASIS";
        if (operation != Operation.CREATE_NEW && Connections.getInstance().lock(connection)) {
            object = null;
            try {
                textBoxActionControl = new HashMap();
                textBoxActionControl.put("PLANNAME", string);
                dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                object = dBUtil.executeOracleQuery(this.getQuery(connection, "getPlan"), (Map)textBoxActionControl);
                if (object != null) {
                    while (object.next()) {
                        string3 = object.getString("COMMENTS");
                        string4 = object.getString("MGMT_METHOD");
                        if (operation != Operation.EDIT) continue;
                        string2 = string;
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                DBUtil.closeResultSet((ResultSet)object);
                Connections.getInstance().unlock(connection);
            }
        }
        object = new TextBoxActionControl(PLAN_NAME, DbaNavigatorResources.getString("PLAN_NAME_LABEL"), string2);
        textBoxActionControl = new TextBoxActionControl(DESCRIPTION, DbaNavigatorResources.getString("DESCRIPTION_LABEL"), string3);
        String string5 = DbaNavigatorResources.getString("MANAGEMENT_METHOD_LABEL");
        if (bl) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "EMPHASIS";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "EMPHASIS";
            stringArray = stringArray3;
            stringArray3[1] = "RATIO";
        }
        dBUtil = new ComboBoxActionControl(MGMT_METHOD, string5, stringArray, string4);
        BooleanCheckBoxActionControl booleanCheckBoxActionControl2 = booleanCheckBoxActionControl = operation == Operation.CREATE_LIKE ? new BooleanCheckBoxActionControl(COPY_DIRECTIVES, DbaNavigatorResources.getString("COPY_DIRECTIVES_LABEL"), true) : null;
        if (operation == Operation.EDIT) {
            object.setEditable(false);
        }
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)object);
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)dBUtil);
        if (booleanCheckBoxActionControl != null) {
            arrayList.add((ActionControl)booleanCheckBoxActionControl);
            this.loadDirectives(connection);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDirectives(Connection connection) {
        block10: {
            this.directives = new ArrayList();
            if (Connections.getInstance().lock(connection)) {
                ResultSet resultSet = null;
                try {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("PLAN", this.getObjectName());
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    resultSet = dBUtil.executeOracleQuery(this.getQuery(connection, "getDirectivesForCreateLike"), hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            Directive directive = new Directive();
                            directive.isGroup = resultSet.getString("TYPE").equals("CONSUMER_GROUP");
                            directive.groupOrSubPlan = resultSet.getString("GROUP_OR_SUBPLAN");
                            directive.cpuP1 = this.getDirective(resultSet, "CPU_P1");
                            directive.cpuP2 = this.getDirective(resultSet, "CPU_P2");
                            directive.cpuP3 = this.getDirective(resultSet, "CPU_P3");
                            directive.cpuP4 = this.getDirective(resultSet, "CPU_P4");
                            directive.cpuP5 = this.getDirective(resultSet, "CPU_P5");
                            directive.cpuP6 = this.getDirective(resultSet, "CPU_P6");
                            directive.cpuP7 = this.getDirective(resultSet, "CPU_P7");
                            directive.cpuP8 = this.getDirective(resultSet, "CPU_P8");
                            if (directive.isGroup) {
                                directive.activeSessPoolP1 = this.getDirective(resultSet, "ACTIVE_SESS_POOL_P1");
                                directive.queueingP1 = this.getDirective(resultSet, "QUEUEING_P1");
                                directive.parallelDegreeLimitP1 = this.getDirective(resultSet, "PARALLEL_DEGREE_LIMIT_P1");
                                directive.switchGroup = resultSet.getString("SWITCH_GROUP");
                                directive.switchTime = this.getDirective(resultSet, "SWITCH_TIME");
                                directive.maxEstExecTime = this.getDirective(resultSet, "MAX_EST_EXEC_TIME");
                                directive.undoPool = this.getDirective(resultSet, "UNDO_POOL");
                                directive.maxIdleTime = this.getDirective(resultSet, "MAX_IDLE_TIME");
                                directive.maxIdleBlockerTime = this.getDirective(resultSet, "MAX_IDLE_BLOCKER_TIME");
                                if (this.is11gOrLater) {
                                    directive.switchIOMegabytes = this.getDirective(resultSet, "SWITCH_IO_MEGABYTES");
                                    directive.switchIOReqs = this.getDirective(resultSet, "SWITCH_IO_REQS");
                                }
                            }
                            this.directives.add(directive);
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block10;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    private Integer getDirective(ResultSet resultSet, String string) throws SQLException {
        Integer n = null;
        try {
            n = Integer.parseInt(resultSet.getString(string));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    protected boolean allowApplyScript() {
        String string = this.getValues().get(PLAN_NAME);
        String string2 = " \n\r\f\t";
        boolean bl = false;
        for (int i = 0; i < string2.length(); ++i) {
            if (string.indexOf(string2.charAt(i)) < 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.showErrorDialog(DbaNavigatorResources.getString("PLAN_NAME_CONTAINS_SPACE_ERROR"));
            return false;
        }
        return true;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BEGIN\n");
        stringBuffer.append("    DBMS_RESOURCE_MANAGER.CLEAR_PENDING_AREA();\n");
        stringBuffer.append("    DBMS_RESOURCE_MANAGER.CREATE_PENDING_AREA();\n");
        if (this.getOperation() != Operation.EDIT) {
            stringBuffer.append("    DBMS_RESOURCE_MANAGER.CREATE_PLAN(\n");
            stringBuffer.append("        PLAN => '");
            stringBuffer.append(values.get(PLAN_NAME));
            stringBuffer.append("',\n");
            stringBuffer.append("        COMMENT => '");
            stringBuffer.append(values.get(DESCRIPTION));
            stringBuffer.append("',\n");
            if (this.is11gOrLater) {
                stringBuffer.append("        MGMT_MTH => '");
            } else {
                stringBuffer.append("        CPU_MTH => '");
            }
            stringBuffer.append(values.get(MGMT_METHOD));
            stringBuffer.append("');\n");
            if (this.getOperation() != Operation.CREATE_LIKE || !Boolean.parseBoolean(values.get(COPY_DIRECTIVES))) {
                stringBuffer.append("    DBMS_RESOURCE_MANAGER.CREATE_PLAN_DIRECTIVE(\n");
                stringBuffer.append("        PLAN => '");
                stringBuffer.append(values.get(PLAN_NAME));
                stringBuffer.append("',\n");
                stringBuffer.append("        GROUP_OR_SUBPLAN => 'OTHER_GROUPS',\n");
                stringBuffer.append("        COMMENT => '');\n");
            }
        } else {
            stringBuffer.append("    DBMS_RESOURCE_MANAGER.UPDATE_PLAN(\n");
            stringBuffer.append("        PLAN => '");
            stringBuffer.append(values.get(PLAN_NAME));
            stringBuffer.append("',\n");
            stringBuffer.append("        NEW_COMMENT => '");
            stringBuffer.append(values.get(DESCRIPTION));
            stringBuffer.append("',\n");
            if (this.is11gOrLater) {
                stringBuffer.append("        NEW_MGMT_MTH => '");
            } else {
                stringBuffer.append("        NEW_CPU_MTH => '");
            }
            stringBuffer.append(values.get(MGMT_METHOD));
            stringBuffer.append("');\n");
        }
        if (this.getOperation() == Operation.CREATE_LIKE && Boolean.parseBoolean(values.get(COPY_DIRECTIVES))) {
            String string = this.is11gOrLater ? "MGMT" : "CPU";
            for (Directive directive : this.directives) {
                stringBuffer.append("    DBMS_RESOURCE_MANAGER.CREATE_PLAN_DIRECTIVE(\n");
                stringBuffer.append("        PLAN => '");
                stringBuffer.append(values.get(PLAN_NAME));
                stringBuffer.append("',\n");
                stringBuffer.append("        GROUP_OR_SUBPLAN => '");
                stringBuffer.append(directive.groupOrSubPlan);
                stringBuffer.append("',\n");
                stringBuffer.append("        COMMENT => ''");
                stringBuffer.append(",\n");
                stringBuffer.append("        " + string + "_P1 => ");
                stringBuffer.append(this.intStringForPLSQLCall(directive.cpuP1));
                stringBuffer.append(",\n");
                if (!this.isPDB) {
                    stringBuffer.append("        " + string + "_P2 => ");
                    stringBuffer.append(this.intStringForPLSQLCall(directive.cpuP2));
                    stringBuffer.append(",\n");
                    stringBuffer.append("        " + string + "_P3 => ");
                    stringBuffer.append(this.intStringForPLSQLCall(directive.cpuP3));
                    stringBuffer.append(",\n");
                    stringBuffer.append("        " + string + "_P4 => ");
                    stringBuffer.append(this.intStringForPLSQLCall(directive.cpuP4));
                    stringBuffer.append(",\n");
                    stringBuffer.append("        " + string + "_P5 => ");
                    stringBuffer.append(this.intStringForPLSQLCall(directive.cpuP5));
                    stringBuffer.append(",\n");
                    stringBuffer.append("        " + string + "_P6 => ");
                    stringBuffer.append(this.intStringForPLSQLCall(directive.cpuP6));
                    stringBuffer.append(",\n");
                    stringBuffer.append("        " + string + "_P7 => ");
                    stringBuffer.append(this.intStringForPLSQLCall(directive.cpuP7));
                    stringBuffer.append(",\n");
                    stringBuffer.append("        " + string + "_P8 => ");
                    stringBuffer.append(this.intStringForPLSQLCall(directive.cpuP8));
                    stringBuffer.append(",\n");
                }
                if (directive.isGroup) {
                    stringBuffer.append("        ACTIVE_SESS_POOL_P1 => ");
                    stringBuffer.append(this.intStringForPLSQLCall(directive.activeSessPoolP1));
                    stringBuffer.append(",\n");
                    stringBuffer.append("        QUEUEING_P1 => ");
                    stringBuffer.append(this.intStringForPLSQLCall(directive.queueingP1));
                    stringBuffer.append(",\n");
                    stringBuffer.append("        PARALLEL_DEGREE_LIMIT_P1 => ");
                    stringBuffer.append(this.intStringForPLSQLCall(directive.parallelDegreeLimitP1));
                    stringBuffer.append(",\n");
                    stringBuffer.append("        SWITCH_GROUP => '");
                    if (directive.switchGroup != null) {
                        stringBuffer.append(directive.switchGroup);
                    }
                    stringBuffer.append("',\n");
                    stringBuffer.append("        SWITCH_TIME => ");
                    stringBuffer.append(this.intStringForPLSQLCall(directive.switchTime));
                    stringBuffer.append(",\n");
                    stringBuffer.append("        MAX_EST_EXEC_TIME => ");
                    stringBuffer.append(this.intStringForPLSQLCall(directive.maxEstExecTime));
                    stringBuffer.append(",\n");
                    stringBuffer.append("        UNDO_POOL => ");
                    stringBuffer.append(this.intStringForPLSQLCall(directive.undoPool));
                    stringBuffer.append(",\n");
                    stringBuffer.append("        MAX_IDLE_TIME => ");
                    stringBuffer.append(this.intStringForPLSQLCall(directive.maxIdleTime));
                    stringBuffer.append(",\n");
                    stringBuffer.append("        MAX_IDLE_BLOCKER_TIME => ");
                    stringBuffer.append(this.intStringForPLSQLCall(directive.maxIdleBlockerTime));
                    if (this.is11gOrLater) {
                        stringBuffer.append(",\n");
                        stringBuffer.append("        SWITCH_IO_MEGABYTES => ");
                        stringBuffer.append(this.intStringForPLSQLCall(directive.switchIOMegabytes));
                        stringBuffer.append(",\n");
                        stringBuffer.append("        SWITCH_IO_REQS => ");
                        stringBuffer.append(this.intStringForPLSQLCall(directive.switchIOReqs));
                    }
                }
                stringBuffer.append(");\n");
            }
        }
        stringBuffer.append("    DBMS_RESOURCE_MANAGER.SUBMIT_PENDING_AREA();\n");
        stringBuffer.append("END;\n");
        return stringBuffer.toString();
    }

    private String intStringForPLSQLCall(Integer n) {
        if (n == null) {
            return "NULL";
        }
        return n.toString();
    }

    private static enum Operation {
        CREATE_NEW,
        CREATE_LIKE,
        EDIT;

    }

    private class Directive {
        boolean isGroup;
        String groupOrSubPlan;
        Integer cpuP1;
        Integer cpuP2;
        Integer cpuP3;
        Integer cpuP4;
        Integer cpuP5;
        Integer cpuP6;
        Integer cpuP7;
        Integer cpuP8;
        Integer activeSessPoolP1;
        Integer queueingP1;
        Integer parallelDegreeLimitP1;
        String switchGroup;
        Integer switchTime;
        Integer maxEstExecTime;
        Integer undoPool;
        Integer maxIdleTime;
        Integer maxIdleBlockerTime;
        Integer switchIOMegabytes;
        Integer switchIOReqs;

        private Directive() {
        }
    }
}

