/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.recovery;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.recovery.RecoverControlGroup;
import oracle.dbtools.raptor.dba.navigator.actions.recovery.RecoveryScriptGenerator;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessor;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.dba.navigator.util.DbaUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.controls.SelectionActionControl;
import oracle.dbtools.raptor.ui.controls.SeperatorActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class RecoverDatafilesAction
extends ActionDialog {
    public static final String DATAFILES = "DATAFILES";
    private List<RecoveryScriptGenerator.TargetDatafileData> targetDatafilesData;

    protected ScriptProcessor createScriptProcessor() {
        return new RMANScriptProcessor();
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("RECOVER_DATAFILES_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Object object;
        Object object2;
        Object object3;
        this.targetDatafilesData = new ArrayList<RecoveryScriptGenerator.TargetDatafileData>();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (Connections.getInstance().lock(connection)) {
            block6: {
                object3 = null;
                try {
                    object2 = new HashMap();
                    object = DBUtil.getInstance((Connection)connection);
                    object.setRaiseError(true);
                    object3 = object.executeOracleQuery(this.getQuery(connection, "getDatafilesInfo"), object2);
                    if (object3 == null) break block6;
                    while (object3.next()) {
                        String string = object3.getString("NAME");
                        int n = object3.getInt("FILE_NO");
                        arrayList.add(string);
                        this.targetDatafilesData.add(new RecoveryScriptGenerator.TargetDatafileData(string, n));
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(object3);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)object3);
                    Connections.getInstance().unlock(connection);
                }
            }
            DBUtil.closeResultSet((ResultSet)object3);
            Connections.getInstance().unlock(connection);
        }
        object3 = new SelectionActionControl(DATAFILES, DbaNavigatorResources.getString("DATAFILES_LABEL"), new ArrayList(), arrayList);
        object2 = new RecoverControlGroup(connection);
        object = new ArrayList();
        ((ArrayList)object).add(object3);
        ((ArrayList)object).add(object2);
        ((ArrayList)object).add(new SeperatorActionControl());
        ((ArrayList)object).add(new RMANScriptProcessorActionControl(connection, "sqldev.rman", DbaUtil.isArchiveLogMode(connection)));
        return object;
    }

    protected String getScript(ActionDialog.Values values) {
        HashSet hashSet = new HashSet(values.getList(DATAFILES, "SELECTED_ITEMS"));
        ArrayList<RecoveryScriptGenerator.TargetDatafileData> arrayList = new ArrayList<RecoveryScriptGenerator.TargetDatafileData>();
        for (RecoveryScriptGenerator.TargetDatafileData targetDatafileData : this.targetDatafilesData) {
            if (!hashSet.contains(targetDatafileData.datafile)) continue;
            arrayList.add(targetDatafileData);
        }
        RecoveryScriptGenerator recoveryScriptGenerator = new RecoveryScriptGenerator(this, (ActionDialog.Lookup)values, null, arrayList, null);
        return recoveryScriptGenerator.generateScript();
    }
}

