/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.performance;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SpinnerActionControl;
import oracle.dbtools.raptor.ui.controls.TemporalActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;

public class CreateBaselineTemplateAction
extends ActionDialog {
    private static final String TEMPLATE_NAME = "TemplateName";
    private static final String REPEATING = "Repeating";
    private static final String START_TIME = "StartTime";
    private static final String END_TIME = "EndTime";
    private static final String EXPIRATION = "Expiration";
    private static final String DAY_OF_WEEK = "DayOfWeek";
    private static final String HOUR_IN_DAY = "HourInDay";
    private static final String DURATION = "Duration";

    protected String getTitle() {
        return DbaNavigatorResources.getString("CREATE_BASELINE_TEMPLATE_TITLE");
    }

    protected List<ActionControl> createControls(Connection connection) {
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(TEMPLATE_NAME, DbaNavigatorResources.getString("TEMPLATE_NAME_LABEL"), "");
        TemporalActionControl temporalActionControl = new TemporalActionControl(START_TIME, DbaNavigatorResources.getString("START_TIME_LABEL"), (Format)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        TemporalActionControl temporalActionControl2 = new TemporalActionControl(END_TIME, DbaNavigatorResources.getString("END_TIME_LABEL"), (Format)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        SpinnerActionControl spinnerActionControl = new SpinnerActionControl(EXPIRATION, DbaNavigatorResources.getString("EXPIRATION_LABEL"), Integer.valueOf(8), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), Integer.valueOf(1));
        BooleanCheckBoxActionControl booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(REPEATING, DbaNavigatorResources.getString("REPEATING_LABEL"), true);
        ComboBoxActionControl comboBoxActionControl = new ComboBoxActionControl(DAY_OF_WEEK, DbaNavigatorResources.getString("DAY_OF_WEEK_LABEL"), new String[]{DbaNavigatorResources.getString("SUNDAY_ITEM"), DbaNavigatorResources.getString("MONDAY_ITEM"), DbaNavigatorResources.getString("TUESDAY_ITEM"), DbaNavigatorResources.getString("WEDNESDAY_ITEM"), DbaNavigatorResources.getString("THURSDAY_ITEM"), DbaNavigatorResources.getString("FRIDAY_ITEM"), DbaNavigatorResources.getString("SATURDAY_ITEM")}, DbaNavigatorResources.getString("SUNDAY_ITEM"));
        SpinnerActionControl spinnerActionControl2 = new SpinnerActionControl(HOUR_IN_DAY, DbaNavigatorResources.getString("HOUR_IN_DAY_LABEL"), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(23), Integer.valueOf(1));
        SpinnerActionControl spinnerActionControl3 = new SpinnerActionControl(DURATION, DbaNavigatorResources.getString("DURATION_LABEL"), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), Integer.valueOf(1));
        booleanCheckBoxActionControl.addPropertyChangeListener(new PropertyChangeListener((ActionControl)booleanCheckBoxActionControl, (ActionControl)comboBoxActionControl, (ActionControl)spinnerActionControl2, (ActionControl)spinnerActionControl3){
            final /* synthetic */ ActionControl val$repeatingCheckBox;
            final /* synthetic */ ActionControl val$dayOfWeekCtl;
            final /* synthetic */ ActionControl val$hourInDayCtl;
            final /* synthetic */ ActionControl val$durationCtl;
            {
                this.val$repeatingCheckBox = actionControl;
                this.val$dayOfWeekCtl = actionControl2;
                this.val$hourInDayCtl = actionControl3;
                this.val$durationCtl = actionControl4;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = Boolean.parseBoolean(this.val$repeatingCheckBox.getValue().get());
                this.val$dayOfWeekCtl.enableUI(bl);
                this.val$hourInDayCtl.enableUI(bl);
                this.val$durationCtl.enableUI(bl);
            }
        });
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)temporalActionControl);
        arrayList.add((ActionControl)temporalActionControl2);
        arrayList.add((ActionControl)spinnerActionControl);
        arrayList.add((ActionControl)booleanCheckBoxActionControl);
        arrayList.add((ActionControl)comboBoxActionControl);
        arrayList.add((ActionControl)spinnerActionControl2);
        arrayList.add((ActionControl)spinnerActionControl3);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        boolean bl = Boolean.parseBoolean(values.get(REPEATING));
        String string = values.get(TEMPLATE_NAME);
        String string2 = values.get(START_TIME);
        String string3 = values.get(END_TIME);
        int n = Integer.parseInt(values.get(EXPIRATION));
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            String string4 = values.get(DAY_OF_WEEK);
            String string5 = null;
            if (string4.equals(DbaNavigatorResources.getString("SUNDAY_ITEM"))) {
                string5 = "SUNDAY";
            } else if (string4.equals(DbaNavigatorResources.getString("MONDAY_ITEM"))) {
                string5 = "MONDAY";
            } else if (string4.equals(DbaNavigatorResources.getString("TUESDAY_ITEM"))) {
                string5 = "TUESDAY";
            } else if (string4.equals(DbaNavigatorResources.getString("WEDNESDAY_ITEM"))) {
                string5 = "WEDNESDAY";
            } else if (string4.equals(DbaNavigatorResources.getString("THURSDAY_ITEM"))) {
                string5 = "THURSDAY";
            } else if (string4.equals(DbaNavigatorResources.getString("FRIDAY_ITEM"))) {
                string5 = "FRIDAY";
            } else if (string4.equals(DbaNavigatorResources.getString("SATURDAY_ITEM"))) {
                string5 = "SATURDAY";
            }
            int n2 = Integer.parseInt(values.get(HOUR_IN_DAY));
            int n3 = Integer.parseInt(values.get(DURATION));
            stringBuffer.append("BEGIN\n");
            stringBuffer.append("    DBMS_WORKLOAD_REPOSITORY.CREATE_BASELINE_TEMPLATE(\n");
            stringBuffer.append("       day_of_week => '");
            stringBuffer.append(string5);
            stringBuffer.append("',\n");
            stringBuffer.append("       hour_in_day => ");
            stringBuffer.append(n2);
            stringBuffer.append(",\n");
            stringBuffer.append("       duration => ");
            stringBuffer.append(n3);
            stringBuffer.append(",\n");
            stringBuffer.append("       start_time => TO_DATE('");
            stringBuffer.append(string2);
            stringBuffer.append("', 'YYYY-MM-DD HH24-MI:SS'),\n");
            stringBuffer.append("       end_time => TO_DATE('");
            stringBuffer.append(string3);
            stringBuffer.append("', 'YYYY-MM-DD HH24-MI:SS'),\n");
            stringBuffer.append("       baseline_name_prefix => '");
            stringBuffer.append(string);
            stringBuffer.append("',\n");
            stringBuffer.append("       template_name => '");
            stringBuffer.append(string);
            stringBuffer.append("',\n");
            stringBuffer.append("       expiration => ");
            if (n <= 0) {
                stringBuffer.append("NULL");
            } else {
                stringBuffer.append(n);
            }
            stringBuffer.append(");\n");
            stringBuffer.append("END;\n");
        } else {
            stringBuffer.append("BEGIN\n");
            stringBuffer.append("    DBMS_WORKLOAD_REPOSITORY.CREATE_BASELINE_TEMPLATE(\n");
            stringBuffer.append("       start_time => TO_DATE('");
            stringBuffer.append(string2);
            stringBuffer.append("', 'YYYY-MM-DD HH24-MI:SS'),\n");
            stringBuffer.append("       end_time => TO_DATE('");
            stringBuffer.append(string3);
            stringBuffer.append("', 'YYYY-MM-DD HH24-MI:SS'),\n");
            stringBuffer.append("       baseline_name => '");
            stringBuffer.append(string);
            stringBuffer.append("',\n");
            stringBuffer.append("       template_name => '");
            stringBuffer.append(string);
            stringBuffer.append("',\n");
            stringBuffer.append("       expiration => ");
            if (n <= 0) {
                stringBuffer.append("NULL");
            } else {
                stringBuffer.append(n);
            }
            stringBuffer.append(");\n");
            stringBuffer.append("END;\n");
        }
        return stringBuffer.toString();
    }
}

