/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backuptabs;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SeperatorActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class EditTapeDeviceSettingsTab
extends ActionDialogTab {
    public static final String TAPE_PARALLELISM = "DISK_PARALLELISM";
    public static final String TAPE_BACKUP_TYPE = "DISK_BACKUP_TYPE";
    public static final String LIB_PARAMS = "DISK_BACKUP_LOCATION";
    public static final String BACKUP_SET_TYPE = DbaNavigatorResources.getString("BACKUP_SET_TYPE");
    public static final String COMPRESSED_BACKUP_SET_TYPE = DbaNavigatorResources.getString("COMPRESSED_BACKUP_SET_TYPE");
    private boolean _includeProcessorAction;

    public EditTapeDeviceSettingsTab() {
        super(null, null);
        this._includeProcessorAction = true;
    }

    public EditTapeDeviceSettingsTab(String string) {
        super(string, DbaNavigatorResources.getString("TAPE_DEVICE_TAB"));
        this._includeProcessorAction = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ActionControl> createControls(Connection connection) {
        DBUtil dBUtil;
        ComboBoxActionControl comboBoxActionControl;
        Object object;
        int n = 0;
        String string = null;
        String string2 = null;
        if (Connections.getInstance().lock(connection)) {
            object = null;
            try {
                comboBoxActionControl = new HashMap();
                dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                object = dBUtil.executeOracleQuery(this.getQuery(connection, "getTapeDeviceSettings"), comboBoxActionControl);
                if (object != null) {
                    while (object.next()) {
                        n = object.getInt("TAPE_PARALLELISM");
                        string = object.getString("TAPE_BACKUP_TYPE");
                        string2 = object.getString("TAPE_LIBRARY_PARAMS");
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (object != null) {
                    // empty if block
                }
                Connections.getInstance().unlock(connection);
            }
        }
        object = new TextBoxActionControl(TAPE_PARALLELISM, DbaNavigatorResources.getString("PARALLELISM_LABEL"), Integer.toString(n), TextBoxActionControl.getIntegerFormat());
        comboBoxActionControl = new ComboBoxActionControl(TAPE_BACKUP_TYPE, DbaNavigatorResources.getString("BACKUP_TYPE_LABEL"), new String[]{BACKUP_SET_TYPE, COMPRESSED_BACKUP_SET_TYPE}, string);
        dBUtil = new TextBoxActionControl(LIB_PARAMS, DbaNavigatorResources.getString("BACKUP_LIB_PARAMS_LABEL"), string2);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)object);
        arrayList.add((ActionControl)comboBoxActionControl);
        arrayList.add((ActionControl)dBUtil);
        if (this._includeProcessorAction) {
            arrayList.add((ActionControl)new SeperatorActionControl());
            arrayList.add(new RMANScriptProcessorActionControl(connection, "sqldev.rman"));
        }
        return arrayList;
    }

    public static int getTapeParallelism(ActionDialog.Lookup lookup) {
        return Integer.parseInt(lookup.get(TAPE_PARALLELISM));
    }

    public static boolean isBackupSetType(ActionDialog.Lookup lookup) {
        return lookup.get(TAPE_BACKUP_TYPE).equals(BACKUP_SET_TYPE);
    }

    public static boolean isCompressedBackupSetType(ActionDialog.Lookup lookup) {
        return lookup.get(TAPE_BACKUP_TYPE).equals(COMPRESSED_BACKUP_SET_TYPE);
    }

    public static String getLibParams(ActionDialog.Lookup lookup) {
        return lookup.get(LIB_PARAMS);
    }
}

