/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backupactionjobs;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.backupactionjobs.ConfigurationGenerator;
import oracle.dbtools.raptor.dba.navigator.actions.backupactionjobs.NewSelectionControl;
import oracle.dbtools.raptor.dba.navigator.util.DbaUtil;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.SQLScriptProcessor;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.actions.ScriptProcessorContext;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.EditorActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.javatools.dialogs.MessageDialog;

public class ConfigureAction
extends ActionDialog {
    private static final String CREDENTIAL = "CREDENTIAL";
    private static final String UNIX_WINDOWS = "UNIX_WINDOWS";
    private static final String SERVERSIDE_DIRECTORY = "SERVERSIDE_DIRECTORY";
    private static final String CHILD_SCRIPT = "CHILD_SCRIPT";
    private static final String DETACHED_SCRIPT = "DETACHED_SCRIPT";
    private ConfigurationGenerator generator;

    protected ScriptProcessor createScriptProcessor() {
        return new SQLScriptProcessor(){

            public void processScript(ScriptProcessorContext scriptProcessorContext) throws Exception {
                if (!ConfigureAction.this.generator.isSchedulerSupported()) {
                    throw new Exception();
                }
                super.processScript(scriptProcessorContext);
            }

            public String getFailureMessage(Exception exception) {
                String string = null;
                if (ConfigureAction.this.generator.isSchedulerSupported()) {
                    Object object;
                    if (exception instanceof SQLException && ((SQLException)(object = (SQLException)exception)).getErrorCode() == 27369) {
                        string = DbaNavigatorResources.getString("BACKUP_CONFIGURE_JOB_FAILURE");
                    }
                    if (string == null) {
                        string = UiResources.getString((String)"SQL_FAILURE");
                        object = exception.getLocalizedMessage();
                        if (object != null) {
                            string = string + "\n- " + (String)object;
                        }
                    }
                } else {
                    string = DbaNavigatorResources.getString("BACKUP_NO_WINDOWS_EXECUTION");
                }
                return string;
            }

            public boolean isCancellable() {
                return true;
            }
        };
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("CONFIGURE_ACTION_JOBS_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(final Connection connection) {
        Object object;
        EditorActionControl editorActionControl;
        String string;
        DBUtil dBUtil;
        ComboBoxActionControl comboBoxActionControl;
        Object object2;
        String string2;
        String[] stringArray;
        block12: {
            if (!DbaUtil.isSysdbaRole(connection) || DbaUtil.getDatabaseMajorVersion(connection) != 11) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbaNavigatorResources.getString("SCHEDULER_RMAN_NOT_SUPPORTED"), (String)DbaNavigatorResources.getString("ERROR_TITLE"), null);
                throw new RuntimeException("sysdba and 11g is required for configure RMAN action");
            }
            this.generator = new ConfigurationGenerator(connection);
            stringArray = null;
            string2 = null;
            if (Connections.getInstance().lock(connection)) {
                try {
                    block11: {
                        object2 = null;
                        try {
                            comboBoxActionControl = new HashMap();
                            dBUtil = DBUtil.getInstance((Connection)connection);
                            dBUtil.setRaiseError(true);
                            object2 = dBUtil.executeOracleQuery(this.getQuery(connection, "getCredentials"), comboBoxActionControl);
                            if (object2 == null) break block11;
                            string = Preferences.getPreferences().getProperties().getString("DBA.DEFAULT_CREDENTIAL");
                            editorActionControl = new ArrayList();
                            while (object2.next()) {
                                object = object2.getString("CREDENTIAL_NAME");
                                editorActionControl.add(object);
                                if (!((String)object).equals(string)) continue;
                                string2 = string;
                            }
                            if (string2 == null && editorActionControl.size() > 0) {
                                string2 = (String)editorActionControl.get(0);
                            }
                            stringArray = new String[editorActionControl.size()];
                            editorActionControl.toArray(stringArray);
                        }
                        catch (SQLException sQLException) {
                            try {
                                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                            }
                            catch (Throwable throwable) {
                                DBUtil.closeResultSet(object2);
                                throw throwable;
                            }
                            DBUtil.closeResultSet((ResultSet)object2);
                            break block12;
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)object2);
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
            }
        }
        object2 = new NewSelectionControl(CREDENTIAL, DbaNavigatorResources.getString("CREDENTIAL_LABEL"), stringArray, new NewSelectionControl.NewListener(){

            @Override
            public String getButtonLabel() {
                return DbaNavigatorResources.getString("NEW_CREDENTIAL_LABEL");
            }

            @Override
            public String getNewComboItem() {
                return DbaUtil.createNewCredential(connection);
            }
        });
        ((NewSelectionControl)((Object)object2)).set(string2);
        comboBoxActionControl = new ComboBoxActionControl(UNIX_WINDOWS, DbaNavigatorResources.getString("UNIX_WINDOWS_LABEL"), new String[]{"Unix", "Windows"}, this.generator.isUnix() ? "Unix" : "Windows");
        dBUtil = new TextBoxActionControl(SERVERSIDE_DIRECTORY, DbaNavigatorResources.getString("SERVERSIDE_DIRECTORY_LABEL"), this.generator.getServerScriptDir());
        string = new EditorActionControl(CHILD_SCRIPT, DbaNavigatorResources.getString("CHILD_SCRIPT_LABEL"), this.generator.getChildScript(), null);
        editorActionControl = new EditorActionControl(DETACHED_SCRIPT, DbaNavigatorResources.getString("DETACHED_SCRIPT_LABEL"), this.generator.getDetachedScript(), null);
        dBUtil.setEditable(false);
        comboBoxActionControl.addPropertyChangeListener(new PropertyChangeListener((ActionControl)comboBoxActionControl, (EditorActionControl)string, editorActionControl, (TextBoxActionControl)dBUtil){
            final /* synthetic */ ActionControl val$unixWindowsCtl;
            final /* synthetic */ EditorActionControl val$childScriptCtl;
            final /* synthetic */ EditorActionControl val$detachedScriptCtl;
            final /* synthetic */ TextBoxActionControl val$serversideDirectoryCtl;
            {
                this.val$unixWindowsCtl = actionControl;
                this.val$childScriptCtl = editorActionControl;
                this.val$detachedScriptCtl = editorActionControl2;
                this.val$serversideDirectoryCtl = textBoxActionControl;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ConfigureAction.this.generator.setUnix(this.val$unixWindowsCtl.getValue().get().equals("Unix"));
                this.val$childScriptCtl.set(ConfigureAction.this.generator.getChildScript());
                this.val$detachedScriptCtl.set(ConfigureAction.this.generator.getDetachedScript());
                this.val$serversideDirectoryCtl.set(ConfigureAction.this.generator.getServerScriptDir());
            }
        });
        object = new ArrayList();
        ((ArrayList)object).add(object2);
        ((ArrayList)object).add(comboBoxActionControl);
        ((ArrayList)object).add(dBUtil);
        ((ArrayList)object).add(string);
        ((ArrayList)object).add(editorActionControl);
        return object;
    }

    protected String getScript(ActionDialog.Values values) {
        if (this.generator.isUnix()) {
            this.generator.setUnixChildScript(values.get(CHILD_SCRIPT));
            this.generator.setUnixDetachedScript(values.get(DETACHED_SCRIPT));
        } else {
            this.generator.setWindowsChildScript(values.get(CHILD_SCRIPT));
            this.generator.setWindowsDetachedScript(values.get(DETACHED_SCRIPT));
        }
        String string = values.get(CREDENTIAL);
        return this.generator.generateConfigurationScript(string);
    }
}

