/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.headless;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.databasecopy.ObjectsCopy;
import oracle.dbtools.raptor.databasecopy.SchemasCopy;
import oracle.dbtools.raptor.databasecopy.TablespaceCopy;
import oracle.dbtools.raptor.dba.headless.CopyDefinition;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;
import oracle.jdbc.OracleConnection;

public class DatabaseCopier {
    public void process(CopyDefinition copyDefinition) throws TaskException {
        HeadlessCopyAPI headlessCopyAPI = null;
        switch (copyDefinition.copyType()) {
            case OBJECTS: {
                headlessCopyAPI = new HeadlessObjectsCopy(this.selectedOptions(copyDefinition), this.logFileWriter(copyDefinition));
                break;
            }
            case SCHEMAS: {
                headlessCopyAPI = new HeadlessSchemasCopy(this.selectedOptions(copyDefinition), this.logFileWriter(copyDefinition));
                break;
            }
            case TABLESPACE: {
                headlessCopyAPI = new HeadlessTablespaceCopy(this.selectedOptions(copyDefinition), this.logFileWriter(copyDefinition));
                headlessCopyAPI.setDestinationTablespace(copyDefinition.destTablespace());
            }
        }
        ExtractListModel extractListModel = this.createListModel(copyDefinition);
        headlessCopyAPI.setExtractListModel(extractListModel);
        DDLFormat dDLFormat = extractListModel.getDDLFormat();
        dDLFormat.isExtractEnabled(copyDefinition.isCopyDDLEnabled());
        extractListModel.setDDLFormat(dDLFormat);
        extractListModel.isDataEnabled(copyDefinition.isCopyDDLEnabled());
        extractListModel.startProcess();
        extractListModel.reconcileDestFromSource();
        headlessCopyAPI.startDatabaseCopy();
    }

    private HashMap<String, Boolean> selectedOptions(CopyDefinition copyDefinition) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("DATABASE_COPY_OBJECTS_COPY", copyDefinition.copyType() == CopyDefinition.Type.OBJECTS);
        hashMap.put("DATABASE_COPY_SCHEMAS_COPY", copyDefinition.copyType() == CopyDefinition.Type.SCHEMAS);
        hashMap.put("DATABASE_COPY_TABLESPACE", copyDefinition.copyType() == CopyDefinition.Type.TABLESPACE);
        hashMap.put("MAINTAIN_SCHEMAS", !copyDefinition.isConsolidateSchemaEnabled());
        hashMap.put("CONSOLIDATE_SCHEMA", copyDefinition.isConsolidateSchemaEnabled());
        hashMap.put("DATABASE_COPY_DDL_ENABLED", copyDefinition.isCopyDDLEnabled());
        hashMap.put("DATABASE_COPY_DDL_DO_NOT_REPLACE", !copyDefinition.isCopyDDLReplace());
        hashMap.put("DATABASE_COPY_DDL_DO_REPLACE", copyDefinition.isCopyDDLReplace());
        hashMap.put("DATABASE_COPY_DATA_ENABLED", copyDefinition.isCopyDataEnabled());
        hashMap.put("DATABASE_COPY_DATA_TRUNCATE_ENABLED", copyDefinition.isCopyDataTruncateEnabled());
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    private ExtractListModel createListModel(CopyDefinition copyDefinition) throws TaskException {
        URL uRL;
        String string32;
        Object object2;
        ExtractListModel extractListModel = new ExtractListModel();
        switch (copyDefinition.copyType()) {
            case SCHEMAS: {
                extractListModel.setSchemas(copyDefinition.schemas());
                break;
            }
            case TABLESPACE: {
                object2 = copyDefinition.schemas();
                if (object2 != null) {
                    extractListModel.setSchemas(copyDefinition.schemas());
                }
                extractListModel.setTablespaces(new String[]{copyDefinition.sourceTablespace()});
                break;
            }
        }
        extractListModel.isDDLEnabled(copyDefinition.isCopyDDLEnabled());
        extractListModel.isDataEnabled(copyDefinition.isCopyDataEnabled());
        object2 = this.connectionName(copyDefinition.sourceDatabase());
        String string2 = this.connectionName(copyDefinition.destDatabase());
        extractListModel.setSourceConnName((String)object2);
        extractListModel.setDestConnName(string2);
        if (copyDefinition.globalWhere() != null) {
            extractListModel.setGlobalWhere(copyDefinition.globalWhere());
        }
        DDLTypes dDLTypes = new DDLTypes();
        dDLTypes.setEnable(copyDefinition.allDDLTypes());
        boolean bl = !copyDefinition.allDDLTypes();
        List<String> list = copyDefinition.ddlTypeExclusions();
        if (list != null) {
            for (String string32 : list) {
                this.enableDDLType(dDLTypes, string32, bl);
            }
        }
        HashMap hashMap = new HashMap();
        string32 = null;
        if (copyDefinition.schemas() != null) {
            string32 = copyDefinition.schemas()[0];
        }
        for (CopyDefinition.DBO object3 : copyDefinition.objectDefs()) {
            void var13_14;
            String string;
            Object object = object3.objectOwner();
            if (object == null) {
                if (string32 == null) {
                    OracleConnection oracleConnection = (OracleConnection)extractListModel.getSourceConn();
                    try {
                        string32 = oracleConnection.getCurrentSchema();
                    }
                    catch (SQLException sQLException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    }
                }
                object = string32;
            }
            if ((string = object3.objectType()) == null) {
                String string4 = "TABLE";
            }
            this.enableDDLType(dDLTypes, (String)var13_14, true);
            uRL = DBURLFormatHelper.getURL((URL)DBURLFormatHelper.getURL((String)"sqldev.nav", (String)extractListModel.getSourceConnName(), (String)"", (String)object, (String)var13_14), (String)object3.name());
            hashMap.put(object3, uRL);
        }
        extractListModel.setDDLTypes(dDLTypes);
        ArrayList arrayList = new ArrayList(hashMap.values());
        extractListModel.setSelectExtractBoth((List)arrayList);
        ArrayList<ExtractObject> arrayList2 = new ArrayList<ExtractObject>();
        for (CopyDefinition.DBO dBO : copyDefinition.objectDefs()) {
            uRL = (URL)hashMap.get(dBO);
            ExtractObject extractObject = extractListModel.getExtractObject(uRL);
            arrayList2.add(extractObject);
            if (dBO.columns().size() > 0) {
                extractObject.getColumns();
                StringBuilder stringBuilder = null;
                for (String string : dBO.columns()) {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder();
                    } else {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(string);
                }
                extractObject.setColumns(stringBuilder.toString());
            }
            if (dBO.where() == null) continue;
            extractObject.setWhere(dBO.where());
        }
        extractListModel.setSelectExtractData(arrayList2);
        return extractListModel;
    }

    private void enableDDLType(DDLTypes dDLTypes, String string, boolean bl) {
        if (string.equals("VIEW")) {
            dDLTypes.setView(bl);
        } else if (string.equals("TYPE")) {
            dDLTypes.setType(bl);
        } else if (string.equals("TRIGGER")) {
            dDLTypes.setTrigger(bl);
        } else if (string.equals("TABLE")) {
            dDLTypes.setTable(bl);
        } else if (string.equals("SEQUENCE")) {
            dDLTypes.setSequence(bl);
        } else if (string.equals("PROCEDURE")) {
            dDLTypes.setProcedure(bl);
        } else if (string.equals("PACKAGE BODY")) {
            dDLTypes.setPackBody(bl);
        } else if (string.equals("PACKAGE")) {
            dDLTypes.setPackSpec(bl);
        } else if (string.equals("MATERIALIZED VIEW")) {
            dDLTypes.setMatView(bl);
        } else if (string.equals("INDEX")) {
            dDLTypes.setIndex(bl);
        } else if (string.equals("FUNCTION")) {
            dDLTypes.setFunction(bl);
        } else if (string.equals("DATABASE LINK")) {
            dDLTypes.setDbLink(bl);
        } else if (string.equals("CONSTRAINT")) {
            dDLTypes.setConstraint(bl);
        } else if (string.equals("SYNONYM")) {
            dDLTypes.setSynonymn(bl);
        } else if (string.equals("MATERIALIZED VIEW LOG")) {
            dDLTypes.setMatViewLog(bl);
        } else if (string.equals("DIRECTORY")) {
            dDLTypes.setDirectory(bl);
        } else if (string.equals("QUEUE")) {
            dDLTypes.setQueue(bl);
        } else if (string.equals("QUEUE TABLE")) {
            dDLTypes.setQueueTable(bl);
        } else if (string.equals("APEX")) {
            dDLTypes.setApex(bl);
        } else if (string.equals("APEX_PAGE")) {
            dDLTypes.setApexPage(bl);
        }
    }

    private String connectionName(String string) throws TaskException {
        String string2 = null;
        for (String string3 : Connections.getInstance().getConnNames()) {
            String string4 = Connections.getDisplayName((String)string3);
            if (!string4.equals(string)) continue;
            string2 = string3;
            break;
        }
        if (string2 == null) {
            string2 = string;
        }
        try {
            if (Connections.getInstance().getConnection(string2) == null) {
                throw new DBException((Throwable)new Exception("database '" + string + "' not found"));
            }
        }
        catch (DBException dBException) {
            throw new TaskException((Throwable)dBException);
        }
        return string2;
    }

    private OutputStreamWriter logFileWriter(CopyDefinition copyDefinition) {
        OutputStreamWriter outputStreamWriter = null;
        String string = copyDefinition.logFile();
        if (string != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
                outputStreamWriter = new OutputStreamWriter(new BufferedOutputStream(fileOutputStream));
            }
            catch (IOException iOException) {
                System.out.println(iOException.getLocalizedMessage());
            }
        }
        return outputStreamWriter;
    }

    class HeadlessTablespaceCopy
    extends TablespaceCopy
    implements HeadlessCopyAPI {
        HeadlessTablespaceCopy(HashMap<String, Boolean> hashMap, OutputStreamWriter outputStreamWriter) {
            super(hashMap);
            this.m_out = outputStreamWriter;
        }

        protected void openLog() {
        }

        @Override
        public void startDatabaseCopy() {
            super.startDatabaseCopy();
            this.closeLog();
        }
    }

    class HeadlessSchemasCopy
    extends SchemasCopy
    implements HeadlessCopyAPI {
        HeadlessSchemasCopy(HashMap<String, Boolean> hashMap, OutputStreamWriter outputStreamWriter) {
            super(hashMap);
            this.m_out = outputStreamWriter;
        }

        protected void openLog() {
        }

        @Override
        public void startDatabaseCopy() {
            super.startDatabaseCopy();
            this.closeLog();
        }
    }

    class HeadlessObjectsCopy
    extends ObjectsCopy
    implements HeadlessCopyAPI {
        HeadlessObjectsCopy(HashMap<String, Boolean> hashMap, OutputStreamWriter outputStreamWriter) {
            super(hashMap);
            this.m_out = outputStreamWriter;
        }

        protected void openLog() {
        }

        @Override
        public void startDatabaseCopy() {
            super.startDatabaseCopy();
            this.closeLog();
        }
    }

    static interface HeadlessCopyAPI {
        public void startDatabaseCopy();

        public void setExtractListModel(ExtractListModel var1);

        public void initObjectFilters(ArrayList<DatabaseNode> var1, boolean var2);

        public boolean isCopyDDL();

        public void isCopyDDL(boolean var1);

        public boolean isNotReplaceDest();

        public void isNotReplaceDest(boolean var1);

        public boolean isReplaceDest();

        public void isReplaceDest(boolean var1);

        public boolean isCopyData();

        public void isCopyData(boolean var1);

        public boolean isTruncateData();

        public void isTruncateData(boolean var1);

        public void setDestinationTablespace(String var1);

        public String getDestinationTablespaceString();

        public BufferedOutputStream getBufferedOutputStream();

        public OutputStreamWriter getOutputStreamWriter();
    }
}

