/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.transaction.metadataStateManager;

import oracle.olapi.transaction.MetadataContext;
import oracle.olapi.transaction.NotCommittableException;
import oracle.olapi.transaction.PersistentMetadataContext;
import oracle.olapi.transaction.Transaction;
import oracle.olapi.transaction.TransactionInactiveException;
import oracle.olapi.transaction.TransactionTypeUnavailableException;
import oracle.olapi.transaction.TransactionalObject;
import oracle.olapi.transaction.TransactionalObjectInvalidException;
import oracle.olapi.transaction.WriteLockException;
import oracle.olapi.transaction.metadataStateManager.BaseMetadataStateHolder;
import oracle.olapi.transaction.metadataStateManager.IncrementalMetadataState;
import oracle.olapi.transaction.metadataStateManager.IncrementalMetadataStateHolder;
import oracle.olapi.transaction.metadataStateManager.IncrementalMetadataStateProvider;
import oracle.olapi.transaction.metadataStateManager.MetadataState;
import oracle.olapi.transaction.metadataStateManager.MetadataStateHolder;
import oracle.olapi.transaction.metadataStateManager.MetadataStateOwner;

public final class MetadataStateManager
implements TransactionalObject {
    private BaseMetadataStateHolder m_FirstHolder = null;
    private MetadataStateOwner m_Owner = null;
    private MetadataContext m_LockContext = null;
    private long m_NextGenerationNumber = 0L;
    private IncrementalMetadataStateProvider m_IncrementalStateProvider = null;

    MetadataStateOwner getOwner() {
        return this.m_Owner;
    }

    private void setOwner(MetadataStateOwner metadataStateOwner) {
        this.m_Owner = metadataStateOwner;
    }

    public MetadataStateManager(IncrementalMetadataStateProvider incrementalMetadataStateProvider) {
        this.setIncrementalStateProvider(incrementalMetadataStateProvider);
        this.createHolder(PersistentMetadataContext.INSTANCE, null, this.getNextGenerationNumber());
    }

    public MetadataStateManager(IncrementalMetadataStateProvider incrementalMetadataStateProvider, IncrementalMetadataState incrementalMetadataState, MetadataContext metadataContext) {
        this(incrementalMetadataStateProvider, incrementalMetadataState, metadataContext, null);
    }

    public MetadataStateManager(IncrementalMetadataStateProvider incrementalMetadataStateProvider, IncrementalMetadataState incrementalMetadataState, MetadataContext metadataContext, MetadataStateOwner metadataStateOwner) {
        this(incrementalMetadataStateProvider);
        IncrementalMetadataStateHolder incrementalMetadataStateHolder = (IncrementalMetadataStateHolder)this.getHolder(metadataContext, true);
        incrementalMetadataStateHolder.setState(incrementalMetadataState);
        this.setOwner(metadataStateOwner);
    }

    public MetadataStateManager(MetadataState metadataState, MetadataContext metadataContext) {
        this(metadataState, metadataContext, null);
    }

    public MetadataStateManager(MetadataState metadataState, MetadataContext metadataContext, MetadataStateOwner metadataStateOwner) {
        this(null);
        MetadataStateHolder metadataStateHolder = (MetadataStateHolder)this.getHolder(metadataContext, true);
        metadataStateHolder.setState(metadataState);
        this.setOwner(metadataStateOwner);
    }

    BaseMetadataStateHolder getFirstHolder() {
        return this.m_FirstHolder;
    }

    public synchronized Transaction getActiveTransaction() {
        MetadataContext metadataContext = this.getFirstHolder().getMetadataContext();
        if (metadataContext instanceof Transaction) {
            return (Transaction)metadataContext;
        }
        return null;
    }

    public synchronized Transaction getActiveTransaction(Transaction transaction) {
        BaseMetadataStateHolder baseMetadataStateHolder = this.getHolder(transaction, false);
        MetadataContext metadataContext = null;
        for (BaseMetadataStateHolder baseMetadataStateHolder2 = baseMetadataStateHolder; baseMetadataStateHolder2 != null; baseMetadataStateHolder2 = baseMetadataStateHolder2.getParent()) {
            if (!baseMetadataStateHolder2.hasState()) continue;
            metadataContext = baseMetadataStateHolder2.getMetadataContext();
            break;
        }
        if (metadataContext instanceof Transaction) {
            return (Transaction)metadataContext;
        }
        return null;
    }

    public MetadataState getCurrentStateForRead(MetadataContext metadataContext) throws TransactionTypeUnavailableException, TransactionInactiveException, TransactionalObjectInvalidException {
        return this.getCurrentStateForRead(metadataContext, true);
    }

    public synchronized MetadataState getCurrentStateForRead(MetadataContext metadataContext, boolean bl) throws TransactionTypeUnavailableException, TransactionInactiveException, TransactionalObjectInvalidException {
        MetadataStateHolder metadataStateHolder = (MetadataStateHolder)this.getHolder(metadataContext, false);
        MetadataState metadataState = metadataStateHolder.getMetadataState(false);
        if (null != metadataState) {
            return metadataState;
        }
        if (bl) {
            throw new TransactionalObjectInvalidException();
        }
        return null;
    }

    public synchronized MetadataState getCurrentStateForWrite(MetadataContext metadataContext) throws TransactionTypeUnavailableException, TransactionInactiveException, TransactionalObjectInvalidException {
        MetadataStateHolder metadataStateHolder = (MetadataStateHolder)this.getHolder(metadataContext, false);
        return (MetadataState)metadataStateHolder.getMetadataState(false).clone();
    }

    public synchronized MetadataState findOrCreateCurrentStateForWrite(MetadataContext metadataContext) throws TransactionTypeUnavailableException, TransactionInactiveException, TransactionalObjectInvalidException {
        MetadataStateHolder metadataStateHolder = (MetadataStateHolder)this.getHolder(metadataContext, true);
        return metadataStateHolder.getMetadataState(true);
    }

    public synchronized Transaction getWriteLockTransaction() throws TransactionalObjectInvalidException {
        MetadataContext metadataContext = null;
        metadataContext = null != this.getIncrementalStateProvider() ? this.getLockContext() : this.getFirstHolder().getMetadataContext();
        if (metadataContext instanceof Transaction) {
            return (Transaction)metadataContext;
        }
        if (metadataContext == PersistentMetadataContext.INSTANCE && this.getFirstHolder().hasState()) {
            return null;
        }
        throw new TransactionalObjectInvalidException();
    }

    public boolean hasCurrentState(Transaction transaction) throws TransactionTypeUnavailableException, TransactionInactiveException {
        return null != this.getCurrentStateForRead(transaction, false);
    }

    public boolean isModified(Transaction transaction) {
        BaseMetadataStateHolder baseMetadataStateHolder = this.getHolder(transaction, false);
        return baseMetadataStateHolder != null && baseMetadataStateHolder.getMetadataContext() == transaction && baseMetadataStateHolder.hasState();
    }

    void setFirstHolder(BaseMetadataStateHolder baseMetadataStateHolder) {
        this.m_FirstHolder = baseMetadataStateHolder;
    }

    public void setCurrentState(MetadataState metadataState, Transaction transaction) throws TransactionTypeUnavailableException, TransactionInactiveException, TransactionalObjectInvalidException, WriteLockException {
        MetadataStateHolder metadataStateHolder = (MetadataStateHolder)this.getHolder(transaction, true);
        metadataStateHolder.setState(metadataState);
    }

    public Object getTransactionalState(Transaction transaction) {
        return this.getCurrentStateForRead(transaction);
    }

    public synchronized void acquireLock(MetadataContext metadataContext, long l) throws WriteLockException {
        if (metadataContext == PersistentMetadataContext.INSTANCE) {
            throw new WriteLockException(null, null, null);
        }
        long l2 = 0L;
        if (l != 0L) {
            l2 = System.currentTimeMillis() + l;
        }
        while (null != this.getLockContext()) {
            if (MetadataStateManager.isMetadataContextDescendantOrSelf(metadataContext, this.getLockContext())) {
                return;
            }
            if (MetadataStateManager.isMetadataContextDescendantOrSelf(this.getLockContext(), metadataContext)) break;
            long l3 = 0L;
            if (0L != l && (l3 = l2 - System.currentTimeMillis()) <= 0L) {
                throw new WriteLockException(null, null, null);
            }
            try {
                this.wait(l3);
            }
            catch (InterruptedException interruptedException) {
                throw new WriteLockException(null, null, null);
            }
        }
        this.setLockContext(metadataContext, true);
        this.getHolder(metadataContext, true);
    }

    synchronized void commit(BaseMetadataStateHolder baseMetadataStateHolder, Transaction transaction) {
        if (baseMetadataStateHolder.getMetadataContext() == this.getLockContext()) {
            this.setLockContext(transaction, true);
        }
        baseMetadataStateHolder.removeFromManager();
    }

    private BaseMetadataStateHolder createHolder(MetadataContext metadataContext, BaseMetadataStateHolder baseMetadataStateHolder, long l) {
        if (null != this.getIncrementalStateProvider()) {
            return new IncrementalMetadataStateHolder(null, this, metadataContext, l, baseMetadataStateHolder);
        }
        return new MetadataStateHolder(null, this, metadataContext, baseMetadataStateHolder);
    }

    private synchronized BaseMetadataStateHolder getHolder(MetadataContext metadataContext, boolean bl) {
        return this.getHolder(metadataContext, bl, false);
    }

    private synchronized BaseMetadataStateHolder getHolder(MetadataContext metadataContext, boolean bl, boolean bl2) {
        MetadataContext metadataContext2 = metadataContext;
        if (null == metadataContext2) {
            metadataContext2 = PersistentMetadataContext.INSTANCE;
        }
        BaseMetadataStateHolder baseMetadataStateHolder = this.getFirstHolder();
        BaseMetadataStateHolder baseMetadataStateHolder2 = null;
        BaseMetadataStateHolder baseMetadataStateHolder3 = null;
        long l = -1L;
        while (null != metadataContext2) {
            boolean bl3 = false;
            while (metadataContext2.getContextNumber() < baseMetadataStateHolder.getMetadataContext().getContextNumber()) {
                baseMetadataStateHolder = baseMetadataStateHolder.getNext();
            }
            if (bl && baseMetadataStateHolder.getMetadataContext() != metadataContext2) {
                long l2 = -1L;
                if (-1L == l) {
                    l2 = l = this.getNextGenerationNumber();
                }
                baseMetadataStateHolder = this.createHolder(metadataContext2, baseMetadataStateHolder, l2);
                bl3 = true;
            }
            if (baseMetadataStateHolder.getMetadataContext() == metadataContext2 || !bl && baseMetadataStateHolder.getMetadataContext() == PersistentMetadataContext.INSTANCE) {
                if (null == baseMetadataStateHolder2) {
                    baseMetadataStateHolder2 = baseMetadataStateHolder;
                    if (!bl3 && bl2 && baseMetadataStateHolder2.getMetadataContext().isIsolationContext() && baseMetadataStateHolder2 instanceof IncrementalMetadataStateHolder) {
                        ((IncrementalMetadataStateHolder)baseMetadataStateHolder2).setIsIsolationHolder(true);
                    }
                }
                if (null != baseMetadataStateHolder3) {
                    baseMetadataStateHolder3.setParent(baseMetadataStateHolder);
                }
                if (!bl3) break;
                baseMetadataStateHolder3 = baseMetadataStateHolder;
                baseMetadataStateHolder = baseMetadataStateHolder.getNext();
            }
            metadataContext2 = metadataContext2.getOuterContext();
        }
        if (null != this.getIncrementalStateProvider() && bl2 && metadataContext.isIsolationContext()) {
            IncrementalMetadataStateHolder incrementalMetadataStateHolder = (IncrementalMetadataStateHolder)baseMetadataStateHolder2;
            incrementalMetadataStateHolder.getIncrementalMetadataState(null, true);
            incrementalMetadataStateHolder.setIsIsolationHolder(true);
        }
        return baseMetadataStateHolder2;
    }

    public synchronized IncrementalMetadataState getIncrementalStateForRead(MetadataContext metadataContext) {
        IncrementalMetadataStateHolder incrementalMetadataStateHolder = (IncrementalMetadataStateHolder)this.getHolder(metadataContext, false);
        return incrementalMetadataStateHolder.getIncrementalMetadataState(null, false);
    }

    public synchronized IncrementalMetadataState getIncrementalStateSince(MetadataContext metadataContext, MetadataContext metadataContext2) {
        IncrementalMetadataStateHolder incrementalMetadataStateHolder = (IncrementalMetadataStateHolder)this.getHolder(metadataContext, false);
        return incrementalMetadataStateHolder.getIncrementalMetadataStateSince(metadataContext2);
    }

    public synchronized IncrementalMetadataState getIncrementalStateForWrite(MetadataContext metadataContext) {
        IncrementalMetadataStateHolder incrementalMetadataStateHolder = (IncrementalMetadataStateHolder)this.getHolder(metadataContext, true);
        return incrementalMetadataStateHolder.getIncrementalMetadataState(null, true);
    }

    public synchronized IncrementalMetadataState findOrCreateIncrementalStateForWrite(MetadataContext metadataContext) {
        return this.findOrCreateIncrementalStateForWrite(metadataContext, false);
    }

    public synchronized IncrementalMetadataState findOrCreateIncrementalStateForWrite(MetadataContext metadataContext, boolean bl) {
        IncrementalMetadataStateHolder incrementalMetadataStateHolder = (IncrementalMetadataStateHolder)this.getHolder(metadataContext, true, bl);
        IncrementalMetadataState incrementalMetadataState = incrementalMetadataStateHolder.getIncrementalMetadataState(null, true);
        if (incrementalMetadataState == null && (incrementalMetadataStateHolder.getChildCount() == 0 || metadataContext == PersistentMetadataContext.INSTANCE)) {
            incrementalMetadataState = this.getIncrementalStateProvider().getInitialState(metadataContext);
            incrementalMetadataStateHolder.setState(incrementalMetadataState);
            incrementalMetadataStateHolder.setGenerationNumber(this.getNextGenerationNumber());
        }
        return incrementalMetadataState;
    }

    public synchronized long getIncrementalStateGenerationNumber(MetadataContext metadataContext) {
        IncrementalMetadataStateHolder incrementalMetadataStateHolder = (IncrementalMetadataStateHolder)this.getHolder(metadataContext, false);
        incrementalMetadataStateHolder.getIncrementalMetadataState(null, false);
        return incrementalMetadataStateHolder.getGenerationNumber();
    }

    public IncrementalMetadataStateProvider getIncrementalStateProvider() {
        return this.m_IncrementalStateProvider;
    }

    public MetadataContext getLockContext() {
        return this.m_LockContext;
    }

    long getNextGenerationNumber() {
        return this.m_NextGenerationNumber++;
    }

    private static boolean isMetadataContextDescendantOrSelf(MetadataContext metadataContext, MetadataContext metadataContext2) {
        for (MetadataContext metadataContext3 = metadataContext2; null != metadataContext3; metadataContext3 = metadataContext3.getOuterContext()) {
            if (metadataContext3 != metadataContext) continue;
            return true;
        }
        return false;
    }

    synchronized void prepare(MetadataContext metadataContext, Transaction transaction) throws NotCommittableException {
        if (null != this.getLockContext() && metadataContext != this.getLockContext() && transaction != this.getLockContext() && MetadataStateManager.isMetadataContextDescendantOrSelf(transaction, this.getLockContext())) {
            throw new NotCommittableException("ObjectLock");
        }
        if (null != this.getOwner() && metadataContext instanceof Transaction) {
            this.getOwner().update((Transaction)metadataContext);
        }
    }

    public synchronized void refresh(MetadataContext metadataContext) {
        if (!metadataContext.isIsolationContext()) {
            return;
        }
        BaseMetadataStateHolder baseMetadataStateHolder = this.getHolder(metadataContext, false);
        if (baseMetadataStateHolder.getMetadataContext() != metadataContext) {
            return;
        }
        if (!baseMetadataStateHolder.hasState()) {
            return;
        }
        baseMetadataStateHolder.refresh();
    }

    public synchronized void releaseLock(MetadataContext metadataContext) throws WriteLockException {
        if (null == this.getLockContext()) {
            return;
        }
        if (!MetadataStateManager.isMetadataContextDescendantOrSelf(this.getLockContext(), metadataContext)) {
            throw new WriteLockException(null, null, null);
        }
        this.setLockContext(null, true);
    }

    public void clearPersistentState() {
        BaseMetadataStateHolder baseMetadataStateHolder = this.getHolder(null, false);
        if (baseMetadataStateHolder instanceof MetadataStateHolder) {
            ((MetadataStateHolder)baseMetadataStateHolder).setState(null);
        } else {
            ((IncrementalMetadataStateHolder)baseMetadataStateHolder).setState(null);
        }
    }

    public synchronized void revert(MetadataContext metadataContext) {
        BaseMetadataStateHolder baseMetadataStateHolder = this.getHolder(metadataContext, false);
        if (baseMetadataStateHolder.getMetadataContext() != metadataContext) {
            return;
        }
        if (!baseMetadataStateHolder.hasState()) {
            return;
        }
        baseMetadataStateHolder.revert();
    }

    synchronized void rollback(BaseMetadataStateHolder baseMetadataStateHolder) {
        if (baseMetadataStateHolder.getMetadataContext() == this.getLockContext()) {
            this.setLockContext(null, true);
        }
        BaseMetadataStateHolder baseMetadataStateHolder2 = baseMetadataStateHolder.getParent();
        baseMetadataStateHolder.removeFromManager();
        while (null != baseMetadataStateHolder2 && !baseMetadataStateHolder2.hasState() && baseMetadataStateHolder2.getChildCount() == 0) {
            if (baseMetadataStateHolder2.getMetadataContext() == PersistentMetadataContext.INSTANCE) {
                if (null == this.getOwner()) break;
                this.getOwner().rollbackPersistentState();
                break;
            }
            baseMetadataStateHolder = baseMetadataStateHolder2;
            baseMetadataStateHolder2 = baseMetadataStateHolder.getParent();
            baseMetadataStateHolder.unregisterAsParticipant();
            baseMetadataStateHolder.removeFromManager();
        }
    }

    synchronized void rollback(MetadataContext metadataContext) {
        if (metadataContext == this.getLockContext()) {
            this.setLockContext(null, true);
        }
    }

    private void setIncrementalStateProvider(IncrementalMetadataStateProvider incrementalMetadataStateProvider) {
        this.m_IncrementalStateProvider = incrementalMetadataStateProvider;
    }

    private void setLockContext(MetadataContext metadataContext, boolean bl) {
        this.m_LockContext = metadataContext;
        if (bl) {
            this.notify();
        }
    }

    public synchronized void clearStates() {
        for (BaseMetadataStateHolder baseMetadataStateHolder = this.getFirstHolder(); null != baseMetadataStateHolder; baseMetadataStateHolder = baseMetadataStateHolder.getNext()) {
            if (baseMetadataStateHolder instanceof MetadataStateHolder) {
                ((MetadataStateHolder)baseMetadataStateHolder).setState(null);
                continue;
            }
            ((IncrementalMetadataStateHolder)baseMetadataStateHolder).setState(null);
        }
        if (null != this.getOwner()) {
            this.getOwner().rollbackPersistentState();
        }
    }
}

