/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax.parser;

import java.util.List;
import oracle.olapi.metadata.MetadataXMLParserCallback;
import oracle.olapi.metadata.mdm.MdmBaseMeasure;
import oracle.olapi.metadata.mdm.MdmCube;
import oracle.olapi.metadata.mdm.MdmDimension;
import oracle.olapi.metadata.mdm.MdmDimensionCalculationModel;
import oracle.olapi.metadata.mdm.MdmDimensionLevel;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmQuery;
import oracle.olapi.metadata.mdm.MdmQueryColumn;
import oracle.olapi.metadata.mdm.MdmRootSchema;
import oracle.olapi.metadata.mdm.MdmTable;
import oracle.olapi.syntax.Buildable;
import oracle.olapi.syntax.DataType;
import oracle.olapi.syntax.DimensionArgument;
import oracle.olapi.syntax.FunctionDescriptorDimensionArgument;
import oracle.olapi.syntax.Query;
import oracle.olapi.syntax.SyntaxException;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.UnresolvedDimensionArgument;
import oracle.olapi.syntax.UnresolvedExpression;
import oracle.olapi.syntax.UnresolvedQuery;
import oracle.olapi.syntax.ValidationContext;
import oracle.olapi.syntax.parser.Identifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifierResolver {
    private String m_Owner = null;
    private List<Query> m_Queries = null;
    private MdmMetadataProvider m_MetadataProvider = null;
    private MdmRootSchema m_RootSchema = null;
    private MetadataXMLParserCallback m_XMLCallback = null;

    private String getOwner() {
        return this.m_Owner;
    }

    private List<Query> getQueries() {
        return this.m_Queries;
    }

    private MdmMetadataProvider getMetadataProvider() {
        return this.m_MetadataProvider;
    }

    private MdmRootSchema getRootSchema() {
        return this.m_RootSchema;
    }

    private MetadataXMLParserCallback getXMLCallback() {
        return this.m_XMLCallback;
    }

    private boolean fullyQualifyObjectID(Identifier identifier, int n, boolean bl, Class clazz) {
        return this.fullyQualifyObjectID(identifier, n, n, bl, clazz);
    }

    private boolean fullyQualifyObjectID(Identifier identifier, int n, int n2, boolean bl, Class clazz) {
        Identifier identifier2;
        boolean bl2 = false;
        int n3 = identifier.getNumComponents();
        if (identifier.hasNamespace()) {
            ++n;
            ++n2;
        }
        if (n3 == n - 1) {
            bl2 = true;
        } else if (n3 == n2) {
            bl2 = false;
        } else if (n != n2 && n3 == n) {
            identifier2 = new Identifier(identifier);
            identifier2.addOwner(this.getOwner());
            MdmObject mdmObject = this.getMetadataProvider().getMdmObject(identifier2);
            bl2 = null != mdmObject;
        } else {
            if (bl) {
                this.error(identifier);
            }
            return false;
        }
        if (bl2) {
            identifier.addOwner(this.getOwner());
        }
        if (null != this.getXMLCallback()) {
            identifier2 = this.getXMLCallback().applyRenameForSyntaxID(identifier, null, clazz);
            identifier.setValue(identifier2);
        }
        return true;
    }

    private MdmObject getMdmObject(Identifier identifier) {
        return this.getMetadataProvider().getMdmObject(identifier);
    }

    public void error(Identifier identifier) {
        throw new SyntaxException("InvalidIdentifier", identifier.toString());
    }

    public Query getQuery(Identifier identifier) {
        return this.getQuery(identifier, true);
    }

    Query getQuery(Identifier identifier, boolean bl) {
        boolean bl2;
        if (1 == identifier.getNumComponents() && null != this.getQueries()) {
            for (Query object2 : this.getQueries()) {
                if (!object2.getName().equals(identifier)) continue;
                return object2;
            }
        }
        if (!(bl2 = this.fullyQualifyObjectID(identifier, 2, bl, MdmQuery.class))) {
            return null;
        }
        MdmObject mdmObject = this.getMdmObject(identifier);
        Query query = null;
        if (mdmObject instanceof MdmCube) {
            query = ((MdmCube)mdmObject).getQuery();
        } else if (mdmObject instanceof MdmPrimaryDimension) {
            query = ((MdmPrimaryDimension)mdmObject).getQuery();
        } else if (mdmObject instanceof MdmTable) {
            query = ((MdmTable)mdmObject).getQuery();
        } else if (mdmObject instanceof MdmHierarchy) {
            query = ((MdmHierarchy)mdmObject).getQuery();
        }
        if (null == query) {
            query = new UnresolvedQuery(identifier, this);
        }
        return query;
    }

    private MdmObject getMdmObjectAndID(Identifier identifier, int n, Class clazz) {
        boolean bl = this.fullyQualifyObjectID(identifier, n, n, true, clazz);
        return this.getMetadataProvider().getMdmObject(identifier);
    }

    UnresolvedExpression getUnresolvedExpression(Identifier identifier) {
        return new UnresolvedExpression(identifier, this);
    }

    DataType getDataType(Identifier identifier) {
        if (identifier.getNumComponents() > 1) {
            this.error(identifier);
        }
        String string = this.getString(identifier);
        DataType[] dataTypeArray = DataType.LITERAL_DATA_TYPES;
        for (int i = 0; i < dataTypeArray.length; ++i) {
            if (!dataTypeArray[i].getName().equals(string)) continue;
            return dataTypeArray[i];
        }
        return null;
    }

    Buildable getBuildObject(Identifier identifier) {
        MdmObject mdmObject = this.getMdmObjectAndID(identifier, 2, Buildable.class);
        if (mdmObject instanceof Buildable) {
            return (Buildable)((Object)mdmObject);
        }
        this.error(identifier);
        return null;
    }

    MdmPrimaryDimension getPrimaryDimension(Identifier identifier) {
        MdmObject mdmObject = this.getMdmObjectAndID(identifier, 2, MdmPrimaryDimension.class);
        if (mdmObject instanceof MdmPrimaryDimension) {
            return (MdmPrimaryDimension)mdmObject;
        }
        this.error(identifier);
        return null;
    }

    MdmDimensionLevel getDimensionLevel(Identifier identifier) {
        MdmObject mdmObject = this.getMdmObjectAndID(identifier, 3, MdmDimensionLevel.class);
        if (mdmObject instanceof MdmDimensionLevel) {
            return (MdmDimensionLevel)mdmObject;
        }
        this.error(identifier);
        return null;
    }

    MdmHierarchy getHierarchy(Identifier identifier) {
        MdmObject mdmObject = this.getMdmObjectAndID(identifier, 3, MdmHierarchy.class);
        if (mdmObject instanceof MdmHierarchy) {
            return (MdmHierarchy)mdmObject;
        }
        this.error(identifier);
        return null;
    }

    MdmDimensionCalculationModel getDimensionCalculationModel(Identifier identifier) {
        MdmObject mdmObject = this.getMdmObjectAndID(identifier, 3, MdmDimensionCalculationModel.class);
        if (mdmObject instanceof MdmDimensionCalculationModel) {
            return (MdmDimensionCalculationModel)mdmObject;
        }
        this.error(identifier);
        return null;
    }

    MdmBaseMeasure getBaseMeasure(Identifier identifier) {
        MdmObject mdmObject = this.getMdmObjectAndID(identifier, 3, MdmBaseMeasure.class);
        if (mdmObject instanceof MdmBaseMeasure) {
            return (MdmBaseMeasure)mdmObject;
        }
        this.error(identifier);
        return null;
    }

    MdmMeasure getMeasure(Identifier identifier) {
        MdmObject mdmObject = this.getMdmObjectAndID(identifier, 3, MdmMeasure.class);
        if (mdmObject instanceof MdmMeasure) {
            return (MdmMeasure)mdmObject;
        }
        this.error(identifier);
        return null;
    }

    void resolveHierarchyList(List list, MdmPrimaryDimension mdmPrimaryDimension) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Identifier identifier = (Identifier)list.get(i);
            String string = this.getString(identifier);
            MdmHierarchy mdmHierarchy = mdmPrimaryDimension.getHierarchy(string);
            if (null == mdmHierarchy) {
                this.error(identifier);
            }
            list.set(i, mdmHierarchy);
        }
    }

    public TypedExpression getColumnExpression(Identifier identifier, boolean bl) {
        Object object;
        String string = identifier.getName();
        identifier.removeLastComponent();
        Query query = this.getQuery(identifier, false);
        identifier.addComponent(string);
        if (null != this.getXMLCallback()) {
            object = this.getXMLCallback().applyRenameForSyntaxID(identifier, identifier.getParentID(), MdmQueryColumn.class);
            identifier.setValue((Identifier)object);
        }
        object = null;
        if (null != query) {
            object = query.getColumnExpression(identifier.getName());
        }
        if (null == object) {
            if (bl) {
                this.error(identifier);
            }
            if (null != query) {
                object = new UnresolvedExpression(identifier, this);
            }
        }
        return object;
    }

    public DimensionArgument getDimensionArgument(Identifier identifier, ValidationContext validationContext, int n, boolean bl) {
        int n2;
        int n3;
        int n4 = FunctionDescriptorDimensionArgument.getMinExpectedNumComponents(n);
        boolean bl2 = this.fullyQualifyObjectID(identifier, n4, n3 = FunctionDescriptorDimensionArgument.getMaxExpectedNumComponents(n), bl, MdmDimension.class);
        if (!bl2) {
            return null;
        }
        MdmObject mdmObject = this.getMdmObject(identifier);
        if (mdmObject instanceof MdmDimension) {
            MdmDimension mdmDimension = (MdmDimension)mdmObject;
            return new DimensionArgument(mdmDimension);
        }
        if (bl) {
            this.error(identifier);
        }
        if (n4 <= (n2 = identifier.getNumComponents()) && n2 <= n3) {
            return new UnresolvedDimensionArgument(identifier, this, n);
        }
        return null;
    }

    public String getString(Identifier identifier) {
        int n = identifier.getNumComponents();
        if (1 == n) {
            return identifier.getComponent(0);
        }
        return identifier.toString();
    }

    public String getComponent(Identifier identifier, int n) {
        return identifier.getComponent(n);
    }

    public String getOracleID(String string) {
        if (null == string) {
            return null;
        }
        if (string.length() == 0) {
            return string;
        }
        if ('\"' == string.charAt(0)) {
            return string.substring(1, string.length() - 1);
        }
        return string.toUpperCase();
    }

    public IdentifierResolver(String string, List list, MdmMetadataProvider mdmMetadataProvider, MetadataXMLParserCallback metadataXMLParserCallback) {
        this.m_Owner = this.getOracleID(string);
        this.m_Queries = list;
        this.m_MetadataProvider = mdmMetadataProvider;
        this.m_XMLCallback = metadataXMLParserCallback;
        if (null != mdmMetadataProvider && mdmMetadataProvider.getRootSchema() instanceof MdmRootSchema) {
            this.m_RootSchema = (MdmRootSchema)mdmMetadataProvider.getRootSchema();
        }
    }
}

