/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import oracle.olapi.syntax.Condition;
import oracle.olapi.syntax.DataType;
import oracle.olapi.syntax.SymmetricCondition;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.UnresolvedIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationContext {
    private Stack<SyntaxObject> m_Stack = new Stack();
    private DataType m_CurrentDataType;
    private List<UnresolvedIdentifier> m_UnresolvedIDs = new ArrayList<UnresolvedIdentifier>();

    private Stack<SyntaxObject> getStack() {
        return this.m_Stack;
    }

    void push(SyntaxObject syntaxObject) {
        this.getStack().push(syntaxObject);
    }

    void pop() {
        SyntaxObject syntaxObject = this.getStack().pop();
        if (syntaxObject.checkIfDefinitionIsComplete()) {
            syntaxObject.setDefinitionComplete(true);
        }
    }

    DataType getCurrentDataType() {
        return this.m_CurrentDataType;
    }

    void setCurrentDataType(DataType dataType) {
        this.m_CurrentDataType = dataType;
    }

    public boolean isTopLevel() {
        return this.getStack().isEmpty();
    }

    public TypedExpression validateExp(TypedExpression typedExpression) {
        return (TypedExpression)this.validate(typedExpression);
    }

    public Condition validateCond(Condition condition) {
        return (Condition)this.validate(condition);
    }

    public SymmetricCondition validateSymmetricCond(SymmetricCondition symmetricCondition) {
        return (SymmetricCondition)this.validate(symmetricCondition);
    }

    public SyntaxObject validate(SyntaxObject syntaxObject) {
        if (syntaxObject.isValidated()) {
            return syntaxObject;
        }
        SyntaxObject syntaxObject2 = syntaxObject.validate(this);
        syntaxObject2.setValidated(true);
        return syntaxObject2;
    }

    public final void validateComponents(SyntaxObject syntaxObject, SyntaxObject[] syntaxObjectArray) {
        this.push(syntaxObject);
        for (int i = 0; i < syntaxObjectArray.length; ++i) {
            syntaxObjectArray[i] = this.validate(syntaxObjectArray[i]);
        }
        this.pop();
    }

    List<UnresolvedIdentifier> getUnresolvedIDs() {
        return this.m_UnresolvedIDs;
    }

    void addUnresolvedID(UnresolvedIdentifier unresolvedIdentifier) {
        this.getUnresolvedIDs().add(unresolvedIdentifier);
    }
}

