/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.syntax.Condition;
import oracle.olapi.syntax.DataObject;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValidationContext;

public final class SearchedCase
extends DataObject {
    private Condition m_WhenCondition = null;
    private TypedExpression m_ThenExpression = null;

    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append("WHEN ");
        syntaxPrintingContext.print(this.getWhenCondition());
        syntaxPrintingContext.append(" THEN ");
        syntaxPrintingContext.print(this.getThenExpression());
    }

    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        this.m_WhenCondition = validationContext.validateCond(this.m_WhenCondition);
        this.m_ThenExpression = validationContext.validateExp(this.m_ThenExpression);
        validationContext.pop();
        return this;
    }

    protected boolean checkIfDefinitionIsComplete() {
        return this.getWhenCondition().isDefinitionComplete() && this.getThenExpression().isDefinitionComplete();
    }

    public SearchedCase(Condition condition, TypedExpression typedExpression) {
        SearchedCase.validateValue(condition);
        SearchedCase.validateValue(typedExpression);
        this.m_WhenCondition = condition;
        this.m_ThenExpression = typedExpression;
        this.initialize();
    }

    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitSearchedCase(this, object);
    }

    public Condition getWhenCondition() {
        return this.m_WhenCondition;
    }

    public TypedExpression getThenExpression() {
        return this.m_ThenExpression;
    }

    public boolean isCompositeObject() {
        return true;
    }
}

